/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.gitlab;

import gitlabbt.org.gitlab4j.api.GitLabApiException;
import gitlabbt.org.gitlab4j.api.models.AbstractIssue;
import gitlabbt.org.gitlab4j.api.models.AbstractUser;
import gitlabbt.org.gitlab4j.api.models.FileUpload;
import gitlabbt.org.gitlab4j.api.models.Issue;
import gitlabbt.org.gitlab4j.api.models.IssueFilter;
import gitlabbt.org.gitlab4j.api.models.Project;
import gitlabbt.org.gitlab4j.models.Constants;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Scope;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Component;
import org.squashtest.csp.core.bugtracker.core.BugTrackerLocalException;
import org.squashtest.csp.core.bugtracker.core.BugTrackerNoCredentialsException;
import org.squashtest.csp.core.bugtracker.core.BugTrackerRemoteException;
import org.squashtest.csp.core.bugtracker.core.ProjectNotFoundException;
import org.squashtest.csp.core.bugtracker.core.UnsupportedAuthenticationModeException;
import org.squashtest.csp.core.bugtracker.core.markdown.ExtendedMarkdownBuilder;
import org.squashtest.csp.core.bugtracker.spi.BugTrackerCacheInfo;
import org.squashtest.csp.core.bugtracker.spi.BugTrackerInterfaceDescriptor;
import org.squashtest.tm.bugtracker.advanceddomain.AdvancedIssue;
import org.squashtest.tm.bugtracker.advanceddomain.AdvancedIssueReportForm;
import org.squashtest.tm.bugtracker.advanceddomain.AdvancedProject;
import org.squashtest.tm.bugtracker.advanceddomain.CommonConfigurationKey;
import org.squashtest.tm.bugtracker.advanceddomain.DelegateCommand;
import org.squashtest.tm.bugtracker.advanceddomain.Field;
import org.squashtest.tm.bugtracker.advanceddomain.FieldGroup;
import org.squashtest.tm.bugtracker.advanceddomain.FieldValue;
import org.squashtest.tm.bugtracker.advanceddomain.InputType;
import org.squashtest.tm.bugtracker.advanceddomain.RemoteIssueFindContext;
import org.squashtest.tm.bugtracker.advanceddomain.RemoteIssueSearchForm;
import org.squashtest.tm.bugtracker.advanceddomain.RemoteIssueSearchRequest;
import org.squashtest.tm.bugtracker.advanceddomain.Rendering;
import org.squashtest.tm.bugtracker.advanceddomain.SelectorField;
import org.squashtest.tm.bugtracker.advanceddomain.exception.InvalidRemoteIssueSearchRequestException;
import org.squashtest.tm.bugtracker.definition.Attachment;
import org.squashtest.tm.bugtracker.definition.RemoteIssue;
import org.squashtest.tm.bugtracker.definition.context.BugTrackerBindingInfo;
import org.squashtest.tm.bugtracker.definition.context.RemoteIssueContext;
import org.squashtest.tm.domain.bugtracker.BugTracker;
import org.squashtest.tm.domain.servers.AuthenticationProtocol;
import org.squashtest.tm.domain.servers.Credentials;
import org.squashtest.tm.plugin.bugtracker.gitlab.GitLabBugtrackerConnectorInterfaceDescriptor;
import org.squashtest.tm.plugin.bugtracker.gitlab.GitLabBugtrackerConnectorProperties;
import org.squashtest.tm.plugin.bugtracker.gitlab.caching.ValueCacheManager;
import org.squashtest.tm.plugin.bugtracker.gitlab.client.CredentialHolder;
import org.squashtest.tm.plugin.bugtracker.gitlab.client.GitLabApiWrapper;
import org.squashtest.tm.plugin.bugtracker.gitlab.client.ScopedLabelHelper;
import org.squashtest.tm.plugin.bugtracker.gitlab.configuration.PersistedConfiguration;
import org.squashtest.tm.plugin.bugtracker.gitlab.conversion.RemoteIssueContextFormatter;
import org.squashtest.tm.plugin.bugtracker.gitlab.conversion.SquashToGitLabIssueConverter;
import org.squashtest.tm.plugin.bugtracker.gitlab.dao.ConfigurationDao;
import org.squashtest.tm.plugin.bugtracker.gitlab.dao.GitLabIssueKeyDao;
import org.squashtest.tm.plugin.bugtracker.gitlab.domain.DeepSchemeBuilder;
import org.squashtest.tm.plugin.bugtracker.gitlab.domain.GitLabAdvancedIssue;
import org.squashtest.tm.plugin.bugtracker.gitlab.domain.GitLabIssueCreationParameters;
import org.squashtest.tm.plugin.bugtracker.gitlab.domain.GitLabIssueKey;
import org.squashtest.tm.plugin.bugtracker.gitlab.domain.ShallowSchemeBuilder;
import org.squashtest.tm.plugin.bugtracker.gitlab.dto.IssueMappingsDto;
import org.squashtest.tm.plugin.bugtracker.gitlab.extension.DelegateCommands;
import org.squashtest.tm.plugin.bugtracker.gitlab.service.ConfigurationService;
import org.squashtest.tm.plugin.bugtracker.gitlab.utils.GitLabCheckedConsumer;
import org.squashtest.tm.plugin.bugtracker.gitlab.utils.GitLabCheckedFunction;
import org.squashtest.tm.service.bugtracker.knownissues.remote.RemoteKnownIssue;
import org.squashtest.tm.service.bugtracker.knownissues.remote.RemoteKnownIssueFinder;
import org.squashtest.tm.service.internal.bugtracker.knownissues.remote.IssueHolderEntityType;
import org.squashtest.tm.service.spi.AdvancedBugTrackerConnector;

@Component
@Scope(value="prototype")
public class GitLabBugtrackerConnector
implements AdvancedBugTrackerConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger(GitLabBugtrackerConnector.class);
    static final String PLACEHOLDER_DASH = "-";
    private BugTracker bugtracker;
    private final CredentialHolder credentialHolder = new CredentialHolder();
    @Inject
    @Named(value="squash.tm.plugin.bugtracker.gitlab.ShallowSchemeBuilder")
    private ShallowSchemeBuilder shallowSchemeBuilder;
    @Inject
    @Named(value="squash.tm.plugin.bugtracker.gitlab.DeepSchemeBuilder")
    private DeepSchemeBuilder deepSchemeBuilder;
    @Inject
    private GitLabBugtrackerConnectorInterfaceDescriptor bugTrackerInterfaceDescriptor;
    @Inject
    private GitLabIssueKeyDao gitLabIssueKeyDao;
    @Inject
    @Named(value="squashtest.bugtracker.gitlab.RemoteIssueContextFormatter")
    private RemoteIssueContextFormatter remoteIssueContextFormatter;
    @Inject
    @Named(value="gitlabConnectorMessageSource")
    private MessageSource messageSource;
    @Inject
    @Named(value="squash.tm.plugin.bugtracker.gitlab.ConfigurationService")
    private ConfigurationService configurationService;
    @Inject
    private ValueCacheManager valueCacheManager;
    @Inject
    private RemoteKnownIssueFinder remoteKnownIssueFinder;
    @Inject
    private GitLabBugtrackerConnectorProperties connectorProperties;
    @Inject
    private ConfigurationDao configurationDao;

    public void setBugTracker(BugTracker bugtracker) {
        this.bugtracker = bugtracker;
    }

    public AuthenticationProtocol[] getSupportedAuthProtocols() {
        return new AuthenticationProtocol[]{AuthenticationProtocol.TOKEN_AUTH};
    }

    public URL makeViewIssueUrl(String issueId) {
        try {
            GitLabIssueKey gitLabIssueKey = this.gitLabIssueKeyDao.fetchGitLabIssueKey(this.bugtracker.getId(), issueId);
            String url = String.format("%s/%s/issues/%s", this.bugtracker.getUrl(), gitLabIssueKey.getProjectPath(), gitLabIssueKey.getIid());
            return new URL(url);
        }
        catch (MalformedURLException e) {
            throw new BugTrackerRemoteException((Throwable)e);
        }
    }

    public AdvancedProject findProject(String projectPath) throws BugTrackerRemoteException {
        return this.executeWithGitlabApi((GitLabApiWrapper gitLabApi) -> this.doFetchShallowProject(projectPath, gitLabApi));
    }

    private AdvancedProject doFetchShallowProject(String projectPath, GitLabApiWrapper gitLabApi) throws GitLabApiException {
        Project project = gitLabApi.getProject(projectPath);
        return this.convertShallowGitLabProject(project, gitLabApi);
    }

    private AdvancedProject convertShallowGitLabProject(Project project, GitLabApiWrapper gitLabApi) {
        Map<String, List<Field>> defaultScheme = this.shallowSchemeBuilder.buildSchemes(project, gitLabApi);
        return AdvancedProject.create((String)project.getPathWithNamespace(), (String)String.format("%s (%s)", project.getName(), project.getPathWithNamespace()), defaultScheme);
    }

    public AdvancedProject findDeepProject(String projectPath) throws BugTrackerRemoteException {
        return this.executeWithGitlabApi((GitLabApiWrapper gitLabApi) -> this.doFetchDeepProject(projectPath, gitLabApi));
    }

    private AdvancedProject doFetchDeepProject(String projectPath, GitLabApiWrapper gitLabApi) throws ProjectNotFoundException {
        Project project;
        try {
            project = gitLabApi.getProject(projectPath);
        }
        catch (GitLabApiException ex) {
            throw new ProjectNotFoundException((Throwable)ex);
        }
        return this.convertDeepGitLabProject(project, gitLabApi);
    }

    private AdvancedProject convertDeepGitLabProject(Project project, GitLabApiWrapper gitLabApi) {
        return AdvancedProject.create((String)project.getPathWithNamespace(), (String)String.format("%s (%s)", project.getName(), project.getPathWithNamespace()), this.deepSchemeBuilder.buildSchemes(project, gitLabApi));
    }

    private void executeWithGitlabApi(GitLabCheckedConsumer consumer) {
        try (GitLabApiWrapper gitLabApi = this.createGitLabApiWrapper();){
            consumer.accept(gitLabApi);
        }
        catch (GitLabApiException e) {
            throw new BugTrackerRemoteException((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T executeWithGitlabApi(GitLabCheckedFunction<T> function) {
        try (GitLabApiWrapper gitLabApi = this.createGitLabApiWrapper();){
            T t = function.run(gitLabApi);
            return t;
        }
        catch (GitLabApiException e) {
            throw new BugTrackerRemoteException((Throwable)e);
        }
    }

    private GitLabApiWrapper createGitLabApiWrapper() throws GitLabApiException {
        return new GitLabApiWrapper(this.bugtracker, (Credentials)this.credentialHolder.get());
    }

    public AdvancedProject findProjectById(String projectPath) throws ProjectNotFoundException, BugTrackerRemoteException {
        return this.findProject(projectPath);
    }

    public AdvancedIssue createIssue(RemoteIssue remoteIssue) throws BugTrackerRemoteException {
        AdvancedIssue advancedIssue = (AdvancedIssue)remoteIssue;
        this.executeWithGitlabApi((GitLabApiWrapper gitLabApi) -> {
            String projectPath = advancedIssue.getProject().getId();
            GitLabIssueCreationParameters parameters = SquashToGitLabIssueConverter.convert(advancedIssue);
            Issue issue = gitLabApi.createIssue(parameters);
            advancedIssue.setId(String.valueOf(issue.getId()));
            advancedIssue.setAdditionalData(GitLabIssueKey.create(issue, projectPath).toJsonString());
        });
        return advancedIssue;
    }

    public RemoteIssueSearchForm createIssueSearchForm(BugTrackerBindingInfo bugTrackerBindingInfo) {
        Locale locale = LocaleContextHolder.getLocale();
        Field projectPathField = this.buildProjectPathField(bugTrackerBindingInfo, locale);
        SelectorField iidOrTitleField = this.buildIidOrTitleSelectorField(locale);
        List<String> fieldsToRetain = List.of("projectPath", "iidOrTitle", "issueTitleCheckClosedIssues");
        return new RemoteIssueSearchForm(Arrays.asList(projectPathField, iidOrTitleField), "iidOrTitle", fieldsToRetain);
    }

    private SelectorField buildIidOrTitleSelectorField(Locale locale) {
        String issueIdLabel = this.messageSource.getMessage("interface.attach.issue-id.label", null, locale);
        String issueTitleLabel = this.messageSource.getMessage("interface.attach.issue-title.label", null, locale);
        String issueTitleShowClosedIssuesLabel = this.messageSource.getMessage("interface.attach.issue-title-show-closed-issues.label", null, locale);
        String searchByLabel = this.messageSource.getMessage("interface.attach.search-by.label", null, locale);
        String issueTitleTooltipLabel = this.messageSource.getMessage("interface.attach.issue-title.tooltip.label", null, locale);
        SelectorField iidOrTitleField = new SelectorField("iidOrTitle", searchByLabel);
        iidOrTitleField.getRendering().getInputType().addConfiguration(CommonConfigurationKey.HELP_MESSAGE.value, issueTitleTooltipLabel);
        iidOrTitleField.getRendering().getInputType().addConfiguration(CommonConfigurationKey.FIELD_LINKED_TO_HELP_MESSAGE.value, "issueTitle");
        Field issueIidField = RemoteIssueSearchForm.textField((String)"key", (String)issueIdLabel);
        issueIidField.getRendering().setRequired(true);
        Field issueTitleField = this.buildIssueTitleField(issueTitleLabel);
        Field issueTitleShowClosedIssuesField = this.buildShowClosedIssuesField(issueTitleShowClosedIssuesLabel);
        FieldGroup issueTitleFieldGroup = new FieldGroup(List.of(issueTitleField, issueTitleShowClosedIssuesField));
        issueTitleFieldGroup.setId("issueTitle");
        issueTitleFieldGroup.setLabel(issueTitleLabel);
        iidOrTitleField.setFields(List.of(issueTitleFieldGroup, issueIidField));
        return iidOrTitleField;
    }

    private Field buildProjectPathField(BugTrackerBindingInfo bugTrackerBindingInfo, Locale locale) {
        String projectPathLabel = this.messageSource.getMessage("interface.attach.project-path.label", null, locale);
        Field projectPathField = new Field("projectPath", projectPathLabel);
        InputType inputType = new InputType();
        inputType.setName(InputType.TypeName.COMBO_BOX.value);
        Rendering rendering = new Rendering(new String[0], inputType, true);
        projectPathField.setRendering(rendering);
        projectPathField.setPossibleValues((FieldValue[])bugTrackerBindingInfo.getRemoteProjectNames().stream().map(projectName -> new FieldValue(projectName, projectName)).toArray(FieldValue[]::new));
        return projectPathField;
    }

    private Field buildIssueTitleField(String issueTitleLabel) {
        Field issueTitleField = RemoteIssueSearchForm.textField((String)"issueTitle", (String)issueTitleLabel);
        issueTitleField.getRendering().setRequired(false);
        issueTitleField.getRendering().getInputType().addConfiguration(CommonConfigurationKey.ONCHANGE.value, "set-issue-title");
        issueTitleField.getRendering().getInputType().addConfiguration(CommonConfigurationKey.DIRECT_SEARCH_FIELD_KEY.value, "key");
        return issueTitleField;
    }

    private Field buildShowClosedIssuesField(String issueTitleShowClosedIssuesLabel) {
        Field issueTitleShowClosedIssuesField = RemoteIssueSearchForm.textField((String)"issueTitleCheckClosedIssues", (String)issueTitleShowClosedIssuesLabel);
        InputType inputType = new InputType();
        inputType.setName(InputType.TypeName.CHECKBOX.value);
        Rendering rendering = new Rendering();
        rendering.setInputType(inputType);
        issueTitleShowClosedIssuesField.setRendering(rendering);
        issueTitleShowClosedIssuesField.getRendering().setRequired(false);
        return issueTitleShowClosedIssuesField;
    }

    public Optional<AdvancedIssue> searchIssue(RemoteIssueSearchRequest remoteIssueSearchRequest) {
        boolean isIssueIdSearch;
        boolean bl = isIssueIdSearch = remoteIssueSearchRequest.hasSearchTerm("projectPath") && remoteIssueSearchRequest.hasSearchTerm("key") && remoteIssueSearchRequest.getSearchTermStringValue("key") != null;
        if (isIssueIdSearch) {
            String projectPath = remoteIssueSearchRequest.getSearchTermStringValue("projectPath");
            String issueId = remoteIssueSearchRequest.getSearchTermStringValue("key");
            return this.doSearchIssueWithId(projectPath, issueId);
        }
        throw new InvalidRemoteIssueSearchRequestException(String.format("The search terms should contain '%s' and '%s'", "projectPath", "key"), null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Optional<AdvancedIssue> doSearchIssueWithId(String projectPath, String issueId) {
        try (GitLabApiWrapper gitLabApi = this.createGitLabApiWrapper();){
            List<Issue> gitLabIssues222 = gitLabApi.getIssues(projectPath, issueId);
            if (gitLabIssues222.isEmpty()) {
                Optional<AdvancedIssue> optional = Optional.empty();
                return optional;
            }
            Issue gitLabIssue222 = gitLabIssues222.get(0);
            AdvancedProject advancedProject = this.findProject(projectPath);
            GitLabAdvancedIssue advancedIssue = this.convertGitLabIssue(advancedProject, gitLabIssue222);
            Optional<AdvancedIssue> optional = Optional.of(advancedIssue);
            return optional;
        }
        catch (GitLabApiException ex) {
            String i18nKey = "interface.attach.issue-not-found";
            String translation = this.messageSource.getMessage("interface.attach.issue-not-found", new Object[]{projectPath}, LocaleContextHolder.getLocale());
            throw new BugTrackerRemoteException(translation, (Throwable)ex);
        }
    }

    public RemoteIssue createReportIssueTemplate(String projectPath, RemoteIssueContext context) {
        try {
            AdvancedProject project = this.findDeepProject(projectPath);
            return this.createReportForm(projectPath, project, context);
        }
        catch (ProjectNotFoundException ex) {
            throw this.getProjectNotFoundException(projectPath, ex);
        }
    }

    private BugTrackerRemoteException getProjectNotFoundException(String projectPath, Throwable cause) {
        String i18nKey = projectPath.indexOf("/") > 0 ? "exception.project-not-found" : "exception.wrong-project-path-format";
        String translation = this.messageSource.getMessage(i18nKey, new Object[]{projectPath}, LocaleContextHolder.getLocale());
        return new BugTrackerRemoteException(translation, cause);
    }

    private AdvancedIssueReportForm createAdvancedIssue(AdvancedProject project) {
        AdvancedIssueReportForm advancedIssue = new AdvancedIssueReportForm();
        advancedIssue.setBugtracker(this.bugtracker.getName());
        advancedIssue.setProject(project);
        advancedIssue.setCurrentScheme("default");
        return advancedIssue;
    }

    private AdvancedIssue createReportForm(String projectPath, AdvancedProject project, RemoteIssueContext context) {
        AdvancedIssueReportForm advancedIssue = this.createAdvancedIssue(project);
        advancedIssue.setFieldValue("descriptionTemplate", this.deepSchemeBuilder.buildDefaultDescriptionTemplateValue());
        if (context != null) {
            advancedIssue.setRemoteIssueContext(context);
            String additionalContent = this.configurationService.getCustomDescriptionTemplate(context.getProjectId(), projectPath);
            advancedIssue.setDescription(this.remoteIssueContextFormatter.buildDefaultDescription(context, additionalContent));
        }
        advancedIssue.setHasCacheError(this.valueCacheManager.hasCacheError(this.bugtracker.getId(), projectPath));
        advancedIssue.setHasLastCacheUpdateFailed(this.valueCacheManager.hasLastCacheUpdateFailed(this.bugtracker.getId(), projectPath));
        return advancedIssue;
    }

    public AdvancedIssue findIssue(String issueKey) {
        List<AdvancedIssue> issues = this.findIssues(Collections.singletonList(issueKey));
        if (issues.size() == 1) {
            return issues.get(0);
        }
        throw new IllegalStateException("None or more than one issues found with key " + issueKey);
    }

    public List<AdvancedIssue> findIssues(List<String> remoteIssueKeys) {
        Map<String, List<GitLabIssueKey>> issueByProjectPath = this.fetchIssueInformationByProjectPath(remoteIssueKeys);
        return this.executeWithGitlabApi((GitLabApiWrapper gitLabApi) -> {
            ArrayList<GitLabAdvancedIssue> issues = new ArrayList<GitLabAdvancedIssue>();
            Map<String, AdvancedProject> projectByPath = this.fetchShallowRemoteProjectsByPath(issueByProjectPath.keySet(), gitLabApi);
            for (Map.Entry entry : issueByProjectPath.entrySet()) {
                String projectPath = (String)entry.getKey();
                List keys = (List)entry.getValue();
                IssueFilter issueFilter = this.buildIssueInternalIdFilter(keys);
                List<Issue> gitLabIssues = gitLabApi.getIssues(projectPath, issueFilter);
                issues.addAll(gitLabIssues.stream().map(issue -> this.convertGitLabIssue((AdvancedProject)projectByPath.get(projectPath), (Issue)issue)).toList());
            }
            return issues;
        });
    }

    public List<AdvancedIssue> findKnownIssues(List<String> remoteIssueKeys, RemoteIssueFindContext context) {
        Map<String, List<GitLabIssueKey>> issueByProjectPath = this.fetchIssueInformationByProjectPath(remoteIssueKeys);
        PersistedConfiguration persistedConfiguration = this.configurationDao.loadOrGetDefaultConfiguration(context.getTmProjectId());
        Map<String, IssueMappingsDto> configuredMappings = this.configurationService.getConfiguredMappings(persistedConfiguration);
        return this.executeWithGitlabApi((GitLabApiWrapper gitLabApi) -> {
            ArrayList<AdvancedIssue> issues = new ArrayList<AdvancedIssue>();
            Map<String, AdvancedProject> projectByPath = this.fetchShallowRemoteProjectsByPath(issueByProjectPath.keySet(), gitLabApi);
            for (Map.Entry entry : issueByProjectPath.entrySet()) {
                List keys = (List)entry.getValue();
                String projectPath = (String)entry.getKey();
                if (projectByPath.containsKey(projectPath)) {
                    IssueFilter issueFilter = this.buildIssueInternalIdFilter(keys);
                    List<Issue> gitLabIssues = gitLabApi.getIssues(projectPath, issueFilter);
                    issues.addAll(this.convertGitLabIssuesWithMappings(persistedConfiguration, projectByPath.get(projectPath), gitLabIssues));
                    if (gitLabIssues.size() >= keys.size() || configuredMappings == null) continue;
                    issues.addAll(this.stubMissingIssues(keys, gitLabIssues, projectByPath.get(projectPath)));
                    continue;
                }
                issues.addAll(this.stubProjectNotFoundIssues(keys));
            }
            return issues;
        });
    }

    private List<ProjectNotFoundDummyIssue> stubProjectNotFoundIssues(List<GitLabIssueKey> keys) {
        AdvancedProject notFoundProject = new AdvancedProject();
        notFoundProject.setName(PLACEHOLDER_DASH);
        String summary = this.messageSource.getMessage("interface.known-issues.project-not-found", null, LocaleContextHolder.getLocale());
        return keys.stream().map(ProjectNotFoundDummyIssue::new).peek(issue -> issue.setSummary(summary)).peek(issue -> issue.setProject(notFoundProject)).toList();
    }

    private List<AdvancedIssue> stubMissingIssues(List<GitLabIssueKey> keys, List<Issue> gitLabIssues, AdvancedProject project) {
        List foundIds = gitLabIssues.stream().map(AbstractIssue::getId).collect(Collectors.toList());
        String summary = this.messageSource.getMessage("interface.known-issues.issue-not-found", null, LocaleContextHolder.getLocale());
        return keys.stream().filter(gitLabIssueKey -> !foundIds.contains(gitLabIssueKey.getId())).map(ProjectNotFoundDummyIssue::new).peek(issue -> issue.setSummary(summary)).peek(issue -> issue.setProject(project)).collect(Collectors.toList());
    }

    private GitLabAdvancedIssue convertGitLabIssue(AdvancedProject advancedProject, Issue gitLabIssue) {
        GitLabAdvancedIssue advancedIssue = GitLabAdvancedIssue.from(this.createAdvancedIssue(advancedProject));
        String projectPath = advancedIssue.getProject().getId();
        advancedIssue.setId(String.valueOf(gitLabIssue.getId()));
        advancedIssue.setSummary(gitLabIssue.getTitle());
        advancedIssue.setDescription(gitLabIssue.getDescription());
        this.appendAssignees(advancedIssue, gitLabIssue);
        advancedIssue.setAdditionalData(GitLabIssueKey.create(gitLabIssue, projectPath).toJsonString());
        return advancedIssue;
    }

    private List<GitLabAdvancedIssue> convertGitLabIssuesWithMappings(PersistedConfiguration persistedConfiguration, AdvancedProject advancedProject, List<Issue> gitLabIssues) {
        return gitLabIssues.stream().map(gitLabIssue -> {
            GitLabAdvancedIssue advancedIssue = this.convertGitLabIssue(advancedProject, (Issue)gitLabIssue);
            String projectPath = advancedIssue.getProject().getId();
            IssueMappingsDto mappingsConfiguration = this.configurationService.getConfiguredMappings(persistedConfiguration).get(projectPath);
            boolean mustDisplayState = persistedConfiguration.isDisplayState();
            if (mappingsConfiguration != null) {
                this.appendMappedStatusesAndPriorities(advancedIssue, mappingsConfiguration, (Issue)gitLabIssue, mustDisplayState);
            } else {
                if (mustDisplayState) {
                    advancedIssue.setFieldValue("status", new FieldValue(gitLabIssue.getState().toValue(), gitLabIssue.getState().toValue()));
                } else {
                    advancedIssue.setFieldValue("status", new FieldValue("PluginNotConfigured", PLACEHOLDER_DASH));
                }
                advancedIssue.setFieldValue("priority", new FieldValue("PluginNotConfigured", PLACEHOLDER_DASH));
            }
            return advancedIssue;
        }).toList();
    }

    private void appendMappedStatusesAndPriorities(AdvancedIssue advancedIssue, IssueMappingsDto mappingsConfiguration, Issue gitLabIssue, boolean mustDisplayState) {
        List<String> issueLabels = gitLabIssue.getLabels();
        ArrayList<String> statusValue = new ArrayList<String>(this.extractMappedStatusLabels(mappingsConfiguration, issueLabels));
        if (mustDisplayState) {
            statusValue.add(gitLabIssue.getState().toValue());
        } else if (statusValue.isEmpty()) {
            statusValue.add(PLACEHOLDER_DASH);
        }
        ArrayList<String> priorityValue = new ArrayList<String>(this.extractMappedPriorityLabels(mappingsConfiguration, issueLabels));
        if (priorityValue.isEmpty()) {
            priorityValue.add(PLACEHOLDER_DASH);
        }
        String joinedStatusLabels = String.join((CharSequence)", ", statusValue);
        String joinedPriorityLabels = String.join((CharSequence)", ", priorityValue);
        advancedIssue.setFieldValue("status", new FieldValue(joinedStatusLabels, joinedStatusLabels));
        advancedIssue.setFieldValue("priority", new FieldValue(joinedPriorityLabels, joinedPriorityLabels));
    }

    private List<String> extractMappedStatusLabels(IssueMappingsDto mappingsConfiguration, List<String> labels) {
        Stream<String> statusLabels = labels.stream().filter(l -> mappingsConfiguration.statusLabels().contains(l));
        Stream<String> statusScopedLabels = labels.stream().filter(ScopedLabelHelper::isScopedLabel).filter(l -> mappingsConfiguration.statusScopes().contains(ScopedLabelHelper.extractLabelScope(l))).map(ScopedLabelHelper::removeLabelScope);
        return Stream.concat(statusLabels, statusScopedLabels).toList();
    }

    private List<String> extractMappedPriorityLabels(IssueMappingsDto mappingsConfiguration, List<String> labels) {
        Stream<String> priorityLabels = labels.stream().filter(l -> mappingsConfiguration.priorityLabels().contains(l));
        Stream<String> priorityScopedLabels = labels.stream().filter(ScopedLabelHelper::isScopedLabel).filter(l -> mappingsConfiguration.priorityScopes().contains(ScopedLabelHelper.extractLabelScope(l))).map(ScopedLabelHelper::removeLabelScope);
        return Stream.concat(priorityLabels, priorityScopedLabels).toList();
    }

    private void appendAssignees(AdvancedIssue advancedIssueToAppendTo, Issue gitLabIssue) {
        List<String> assigneeUsernames = gitLabIssue.getAssignees().stream().map(DeepSchemeBuilder::formatUserName).toList();
        String displayValue = String.join((CharSequence)", ", assigneeUsernames);
        List<String> assigneeIds = gitLabIssue.getAssignees().stream().map(AbstractUser::getId).map(Object::toString).toList();
        String joinedIds = String.join((CharSequence)",", assigneeIds);
        advancedIssueToAppendTo.setFieldValue("assignee", new FieldValue(joinedIds, displayValue));
    }

    private IssueFilter buildIssueInternalIdFilter(List<GitLabIssueKey> keys) {
        IssueFilter issueFilter = new IssueFilter();
        issueFilter.setIids(keys.stream().map(GitLabIssueKey::getIid).distinct().toList());
        issueFilter.setScope(Constants.IssueScope.ALL);
        return issueFilter;
    }

    private Map<String, AdvancedProject> fetchShallowRemoteProjectsByPath(Set<String> projectPaths, GitLabApiWrapper gitLabApi) throws GitLabApiException {
        ArrayList<AdvancedProject> advancedProjects = new ArrayList<AdvancedProject>();
        for (String projectPath : projectPaths) {
            try {
                advancedProjects.add(this.doFetchShallowProject(projectPath, gitLabApi));
            }
            catch (GitLabApiException gitLabApiException) {
                LOGGER.warn(String.format("Could not find project with path %s.", projectPath));
            }
        }
        return advancedProjects.stream().collect(Collectors.toMap(AdvancedProject::getId, Function.identity()));
    }

    private Map<String, List<GitLabIssueKey>> fetchIssueInformationByProjectPath(List<String> remoteIssueKeys) {
        List<GitLabIssueKey> gitLabIssueKeys = this.fetchGitLabIssueKeys(remoteIssueKeys);
        return gitLabIssueKeys.stream().collect(Collectors.groupingBy(GitLabIssueKey::getProjectPath));
    }

    private List<GitLabIssueKey> fetchGitLabIssueKeys(List<String> remoteIssueKeys) {
        return this.gitLabIssueKeyDao.fetchGitLabIssueKeys(this.bugtracker.getId(), remoteIssueKeys);
    }

    public void forwardAttachments(String issueKey, List<Attachment> attachments) {
        AdvancedIssue advancedIssue = this.findIssue(issueKey);
        if (advancedIssue == null) {
            throw new BugTrackerLocalException("Cannot find issue with ID " + issueKey + " to attach to.", null);
        }
        GitLabIssueKey gitLabIssueKey = GitLabIssueKey.fromJsonString(advancedIssue.getAdditionalData());
        this.executeWithGitlabApi((GitLabApiWrapper gitLabApiWrapper) -> {
            Map<Attachment, FileUpload> uploadByAttachment = gitLabApiWrapper.addProjectUploads(gitLabIssueKey.getProjectPath(), attachments);
            ExtendedMarkdownBuilder markdownBuilder = new ExtendedMarkdownBuilder();
            uploadByAttachment.forEach((attachment, fileUpload) -> {
                boolean isImageFile = GitLabBugtrackerConnector.hasImageFileExtension(attachment.getName());
                String linkOrImage = isImageFile ? markdownBuilder.image(attachment.getName(), fileUpload.getUrl()) : markdownBuilder.link(attachment.getName(), fileUpload.getUrl());
                markdownBuilder.appendParagraph(linkOrImage);
            });
            String newDescription = advancedIssue.getDescription() + markdownBuilder.getLineSeparator() + markdownBuilder.build();
            gitLabApiWrapper.setIssueDescription(gitLabIssueKey.getProjectPath(), gitLabIssueKey.getIid(), newDescription);
        });
    }

    private static boolean hasImageFileExtension(String name) {
        name = name.toLowerCase();
        return Stream.of(".jpg", ".jpeg", ".png", ".webp", ".bmp", ".tiff", ".tif", ".gif").anyMatch(name::endsWith);
    }

    public Object executeDelegateCommand(DelegateCommand delegateCommand) {
        LOGGER.debug("BEGIN : execute delegate command");
        if (DelegateCommands.isSetLabelsCommand(delegateCommand)) {
            return DelegateCommands.executeSetLabelsCommand(delegateCommand);
        }
        if (DelegateCommands.isSetIssueTitleCommand(delegateCommand)) {
            try {
                List<Long> alreadyLinkedIssueIds = this.fetchAlreadyLinkedIssues(delegateCommand.getContext().getBoundEntityInfo()).stream().map(issue -> Long.valueOf(issue.remoteIssue.getId())).toList();
                return DelegateCommands.executeSetIssueTitleCommand(delegateCommand, this.createGitLabApiWrapper(), alreadyLinkedIssueIds, this.connectorProperties.getMaxResultsPerSearch());
            }
            catch (GitLabApiException e) {
                throw new BugTrackerRemoteException((Throwable)e);
            }
        }
        if (DelegateCommands.isSetDescriptionTemplateCommand(delegateCommand)) {
            try {
                return DelegateCommands.executeSetDescriptionTemplateCommand(delegateCommand, this.createGitLabApiWrapper(), this.remoteIssueContextFormatter);
            }
            catch (GitLabApiException e) {
                throw new BugTrackerRemoteException((Throwable)e);
            }
        }
        LOGGER.debug("END : no suitable delegate command found");
        return null;
    }

    private List<RemoteKnownIssue> fetchAlreadyLinkedIssues(Map<String, Object> boundEntityInfo) {
        String bindableEntitySnakeCase = boundEntityInfo.get("bindableEntity").toString().replace("_TYPE", "").replace("_", PLACEHOLDER_DASH).toLowerCase();
        IssueHolderEntityType issueHolder = IssueHolderEntityType.fromValue((String)bindableEntitySnakeCase);
        long boundEntityId = Long.parseLong(boundEntityInfo.get("boundEntityId").toString());
        return this.remoteKnownIssueFinder.findAllByEntityType(issueHolder.getValue(), boundEntityId);
    }

    public void linkIssues(String s, List<String> list) {
    }

    public BugTrackerInterfaceDescriptor getInterfaceDescriptor() {
        return this.bugTrackerInterfaceDescriptor;
    }

    public void authenticate(Credentials credentials) throws UnsupportedAuthenticationModeException {
        this.credentialHolder.set(credentials);
    }

    private void checkCommunicationWithGitLab() {
        this.executeWithGitlabApi(GitLabApiWrapper::getVersion);
    }

    public void checkCredentials(Credentials credentials) throws BugTrackerNoCredentialsException, BugTrackerRemoteException {
        this.authenticate(credentials);
        this.checkCommunicationWithGitLab();
    }

    public boolean allowsReportingCache() {
        return true;
    }

    public void refreshCache(BugTracker bugTracker, long projectId) {
        this.valueCacheManager.refreshCache(bugTracker, projectId);
    }

    public void refreshCache(BugTracker bugTracker) {
        this.valueCacheManager.refreshCache(bugTracker);
    }

    public BugTrackerCacheInfo getCacheInfo() {
        return this.valueCacheManager.getCacheInfo();
    }

    private static class ProjectNotFoundDummyIssue
    extends AdvancedIssue {
        private final GitLabIssueKey gitLabIssueKey;

        ProjectNotFoundDummyIssue(GitLabIssueKey key) {
            this.gitLabIssueKey = key;
            this.setId(key.getId().toString());
        }

        public String getRemoteKey() {
            return "#" + this.gitLabIssueKey.getIid();
        }
    }
}

