/*
 * Decompiled with CFR 0.152.
 */
package plugin.rtc.org.eclipse.lyo.oslc4j.core;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.namespace.QName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import plugin.rtc.com.hp.hpl.jena.datatypes.DatatypeFormatException;
import plugin.rtc.com.hp.hpl.jena.datatypes.RDFDatatype;
import plugin.rtc.com.hp.hpl.jena.datatypes.TypeMapper;
import plugin.rtc.com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import plugin.rtc.com.hp.hpl.jena.datatypes.xsd.XSDDateTime;
import plugin.rtc.com.hp.hpl.jena.datatypes.xsd.impl.XMLLiteralType;
import plugin.rtc.javax.servlet.http.HttpServletRequest;
import plugin.rtc.javax.ws.rs.core.UriBuilder;
import plugin.rtc.org.eclipse.lyo.oslc4j.core.model.Property;
import plugin.rtc.org.eclipse.lyo.oslc4j.core.model.ResourceShape;
import plugin.rtc.org.eclipse.lyo.oslc4j.core.model.XMLLiteral;

public class OSLC4JUtils {
    private static final Logger log = LoggerFactory.getLogger(OSLC4JUtils.class);
    private static String publicURI = System.getProperty("plugin.rtc.org.eclipse.lyo.oslc4j.publicURI");
    private static String servletPath = null;
    private static String servletURI = null;
    private static String useBeanClassForParsing = System.getProperty("plugin.rtc.org.eclipse.lyo.oslc4j.useBeanClassForParsing");
    private static String inferTypeFromShape = System.getProperty("plugin.rtc.org.eclipse.lyo.oslc4j.inferTypeFromResourceShape");
    private static List<ResourceShape> shapes = new ArrayList<ResourceShape>();

    public static String getPublicURI() {
        return publicURI;
    }

    public static void setPublicURI(String newPublicURI) throws MalformedURLException {
        if (newPublicURI != null && !newPublicURI.isEmpty()) {
            new URL(newPublicURI);
        }
        publicURI = newPublicURI;
    }

    public static String getServletPath() {
        return servletPath;
    }

    @Deprecated
    public static String resolveURI(HttpServletRequest request, boolean includePath) {
        UriBuilder builder;
        String pathInfo = request.getPathInfo();
        String servletPath = request.getServletPath();
        String configuredPublicURI = OSLC4JUtils.getPublicURI();
        if (configuredPublicURI != null && !configuredPublicURI.isEmpty()) {
            String uriToBuild = configuredPublicURI;
            if (includePath) {
                uriToBuild = configuredPublicURI + "/" + servletPath + pathInfo;
            }
            builder = UriBuilder.fromUri(uriToBuild);
        } else {
            String contextPath;
            String hostname = OSLC4JUtils.guessHostname(request);
            String pathToBuild = contextPath = request.getContextPath();
            if (includePath) {
                pathToBuild = contextPath + servletPath + pathInfo;
            }
            builder = UriBuilder.fromPath(pathToBuild).scheme(request.getScheme()).host(hostname).port(request.getServerPort());
        }
        URI resolvedURI = builder.build(new Object[0]).normalize();
        return resolvedURI.toString();
    }

    public static String getServletURI() {
        return servletURI;
    }

    public static boolean useBeanClassForParsing() {
        boolean result = false;
        if (null != useBeanClassForParsing) {
            result = Boolean.parseBoolean(useBeanClassForParsing);
        }
        return result;
    }

    public static String getUseBeanClassForParsing() {
        return useBeanClassForParsing;
    }

    public static void setUseBeanClassForParsing(String useBeanClassForParsing) {
        OSLC4JUtils.useBeanClassForParsing = useBeanClassForParsing;
    }

    public static boolean inferTypeFromShape() {
        boolean result = false;
        if (null != inferTypeFromShape) {
            result = Boolean.parseBoolean(inferTypeFromShape);
        }
        return result;
    }

    public static String getInferTypeFromShape() {
        return inferTypeFromShape;
    }

    public static void setInferTypeFromShape(String inferTypeFromShape) {
        OSLC4JUtils.inferTypeFromShape = inferTypeFromShape;
    }

    public static List<ResourceShape> getShapes() {
        return shapes;
    }

    public static void setShapes(List<ResourceShape> shapes) {
        OSLC4JUtils.shapes = shapes;
    }

    public static boolean isHostResolutionDisabled() {
        boolean retVal = false;
        String hostResDisabledProp = System.getProperty("plugin.rtc.org.eclipse.lyo.oslc4j.disableHostResolution");
        if (hostResDisabledProp != null) {
            retVal = Boolean.parseBoolean(hostResDisabledProp);
        }
        return retVal;
    }

    public static void setHostResolutionDisabled(boolean hostResDisabled) {
        System.setProperty("plugin.rtc.org.eclipse.lyo.oslc4j.disableHostResolution", Boolean.toString(hostResDisabled));
    }

    public static String resolveFullUri(HttpServletRequest request) {
        UriBuilder servletUriBuilder = OSLC4JUtils.servletUriBuilderFrom(request);
        String pathInfo = request.getPathInfo();
        UriBuilder publicUriBuilder = servletUriBuilder.path(pathInfo);
        URI resolvedURI = publicUriBuilder.build(new Object[0]).normalize();
        return resolvedURI.toString();
    }

    public static String resolveServletUri(HttpServletRequest request) {
        UriBuilder servletUriBuilder = OSLC4JUtils.servletUriBuilderFrom(request);
        URI resolvedURI = servletUriBuilder.build(new Object[0]).normalize();
        return resolvedURI.toString();
    }

    public static void setServletPath(String newServletPath) {
        if (newServletPath != null && !newServletPath.isEmpty()) {
            URI testServletURI = OSLC4JUtils.servletUriBuilderFrom(OSLC4JUtils.getPublicURI(), newServletPath).build(new Object[0]);
            servletPath = newServletPath;
            servletURI = testServletURI.toString();
        } else {
            servletPath = null;
            servletURI = null;
        }
    }

    private static UriBuilder servletUriBuilderFrom(HttpServletRequest request) {
        String publicUri = OSLC4JUtils.getOrConstructPublicUriBase(request);
        String servletPath = OSLC4JUtils.getServletPath() != null ? OSLC4JUtils.getServletPath() : request.getServletPath();
        return OSLC4JUtils.servletUriBuilderFrom(publicUri, servletPath);
    }

    private static UriBuilder servletUriBuilderFrom(String publicUri, String servletPath) {
        return UriBuilder.fromUri(publicUri).path(servletPath);
    }

    private static String getOrConstructPublicUriBase(HttpServletRequest request) {
        String publicUri = OSLC4JUtils.getPublicURI();
        if (publicUri == null || publicUri.isEmpty()) {
            String scheme = request.getScheme();
            String hostName = OSLC4JUtils.guessHostname(request);
            int serverPort = request.getServerPort();
            String contextPath = request.getContextPath();
            publicUri = OSLC4JUtils.constructPublicUriBase(scheme, hostName, serverPort, contextPath);
        }
        return publicUri;
    }

    private static String constructPublicUriBase(String scheme, String hostName, int serverPort, String contextPath) {
        return UriBuilder.fromPath(contextPath).scheme(scheme).host(hostName).port(serverPort).build(new Object[0]).normalize().toString();
    }

    @Deprecated
    private static String guessHostname(HttpServletRequest request) {
        String hostName = "localhost";
        boolean getHostNameFromRequest = false;
        if (OSLC4JUtils.isHostResolutionDisabled()) {
            getHostNameFromRequest = true;
        } else {
            try {
                hostName = InetAddress.getLocalHost().getCanonicalHostName();
            }
            catch (UnknownHostException e) {
                log.info("Unable to resolve hostname. Extracting hostname from request.");
                getHostNameFromRequest = true;
            }
        }
        if (getHostNameFromRequest) {
            hostName = request.getServerName();
        }
        return hostName;
    }

    public static boolean relativeURIsAreDisabled() {
        boolean retVal = true;
        String relURIsDisabledProp = System.getProperty("plugin.rtc.org.eclipse.lyo.oslc4j.disableRelativeURIs");
        if (relURIsDisabledProp != null) {
            retVal = Boolean.parseBoolean(relURIsDisabledProp);
        }
        return retVal;
    }

    public static boolean isQueryResultListAsContainer() {
        return "true".equals(System.getProperty("plugin.rtc.org.eclipse.lyo.oslc4j.queryResultListAsContainer", "false"));
    }

    private static boolean doesResourceShapeMatchRdfTypes(ResourceShape shape, HashSet<String> rdfTypesList) {
        if (null != shape) {
            URI[] describes;
            for (URI describeUri : describes = shape.getDescribes()) {
                String describeUriStr = describeUri.toASCIIString();
                if (!rdfTypesList.contains(describeUriStr)) continue;
                return true;
            }
        }
        return false;
    }

    public static Object getValueBasedOnResourceShapeType(HashSet<String> rdfTypesList, QName propertyQName, Object originalValue) throws DatatypeConfigurationException, IllegalArgumentException, InstantiationException, InvocationTargetException {
        if (null == rdfTypesList || rdfTypesList.isEmpty() || null == propertyQName || null == originalValue) {
            return null;
        }
        try {
            List<ResourceShape> shapes = OSLC4JUtils.getShapes();
            if (null == shapes || shapes.isEmpty()) {
                return null;
            }
            String propertyName = propertyQName.getNamespaceURI() + propertyQName.getLocalPart();
            TypeMapper typeMapper = TypeMapper.getInstance();
            for (ResourceShape shape : shapes) {
                Property[] props;
                if (!OSLC4JUtils.doesResourceShapeMatchRdfTypes(shape, rdfTypesList)) continue;
                for (Property prop : props = shape.getProperties()) {
                    RDFDatatype dataTypeFromShape;
                    URI propValueType;
                    URI propDefinition = prop.getPropertyDefinition();
                    if (!propertyName.equals(propDefinition.toString()) || null == (propValueType = prop.getValueType()) || null == (dataTypeFromShape = typeMapper.getTypeByName(propValueType.toString()))) continue;
                    try {
                        if (OSLC4JUtils.isXmlLiteralProperty(propValueType)) {
                            return OSLC4JUtils.xmlLiteralPropertyFrom(originalValue);
                        }
                        if (OSLC4JUtils.isDateProperty(dataTypeFromShape)) {
                            return OSLC4JUtils.datePropertyFrom(originalValue);
                        }
                        if (OSLC4JUtils.isBooleanProperty(dataTypeFromShape)) {
                            return OSLC4JUtils.booleanPropertyFrom(originalValue);
                        }
                        if (OSLC4JUtils.isDoubleProperty(dataTypeFromShape)) {
                            return OSLC4JUtils.doublePropertyFrom(originalValue);
                        }
                        if (OSLC4JUtils.isFloatProperty(dataTypeFromShape)) {
                            return OSLC4JUtils.floatPropertyFrom(originalValue);
                        }
                        Constructor<?> cons = dataTypeFromShape.getJavaClass().getConstructor(String.class);
                        return cons.newInstance(originalValue.toString());
                    }
                    catch (IllegalArgumentException | InvocationTargetException | DatatypeFormatException e) {
                        throw new IllegalArgumentException(e);
                    }
                }
            }
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            log.warn("Could not create extended value <{}> based on shape", (Object)propertyQName, (Object)e);
            return null;
        }
        return null;
    }

    private static Object floatPropertyFrom(Object originalValue) {
        return XSDDatatype.XSDfloat.parseValidated(originalValue.toString());
    }

    private static Object doublePropertyFrom(Object originalValue) {
        return XSDDatatype.XSDdouble.parseValidated(originalValue.toString());
    }

    private static Object booleanPropertyFrom(Object originalValue) {
        if (Boolean.TRUE.toString().equals(originalValue.toString()) || "1".equals(originalValue.toString())) {
            return Boolean.TRUE;
        }
        if (Boolean.FALSE.toString().equals(originalValue.toString()) || "0".equals(originalValue.toString())) {
            return Boolean.FALSE;
        }
        throw new IllegalArgumentException("'" + originalValue.toString() + "' has wrong format for Boolean.");
    }

    private static Object datePropertyFrom(Object originalValue) throws DatatypeConfigurationException {
        String dateStr = originalValue.toString();
        GregorianCalendar calendar = DatatypeFactory.newInstance().newXMLGregorianCalendar(dateStr).toGregorianCalendar();
        XSDDateTime xsdDateTime = new XSDDateTime(calendar);
        return xsdDateTime.asCalendar().getTime();
    }

    private static XMLLiteral xmlLiteralPropertyFrom(Object originalValue) {
        return new XMLLiteral(originalValue.toString());
    }

    private static boolean isFloatProperty(RDFDatatype dataTypeFromShape) {
        return dataTypeFromShape.getJavaClass().getCanonicalName().equals(Float.class.getCanonicalName());
    }

    private static boolean isDoubleProperty(RDFDatatype dataTypeFromShape) {
        return dataTypeFromShape.getJavaClass().getCanonicalName().equals(Double.class.getCanonicalName());
    }

    private static boolean isBooleanProperty(RDFDatatype dataTypeFromShape) {
        return dataTypeFromShape.getJavaClass().getCanonicalName().equals(Boolean.class.getCanonicalName());
    }

    private static boolean isDateProperty(RDFDatatype dataTypeFromShape) {
        return dataTypeFromShape.getJavaClass().getCanonicalName().equals(XSDDateTime.class.getCanonicalName());
    }

    private static boolean isXmlLiteralProperty(URI propValueType) {
        return XMLLiteralType.theXMLLiteralType.getURI().equals(propValueType.toString());
    }

    public static RDFDatatype getDataTypeBasedOnResourceShapeType(HashSet<String> rdfTypesList, plugin.rtc.com.hp.hpl.jena.rdf.model.Property property) {
        if (null != rdfTypesList && !rdfTypesList.isEmpty() && null != property) {
            try {
                List<ResourceShape> shapes = OSLC4JUtils.getShapes();
                if (null != shapes && !shapes.isEmpty()) {
                    String propertyName = property.getURI();
                    TypeMapper typeMapper = TypeMapper.getInstance();
                    for (ResourceShape shape : shapes) {
                        Property[] props;
                        if (!OSLC4JUtils.doesResourceShapeMatchRdfTypes(shape, rdfTypesList)) continue;
                        for (Property prop : props = shape.getProperties()) {
                            URI propValueType;
                            URI propDefinition = prop.getPropertyDefinition();
                            if (!propertyName.equals(propDefinition.toString()) || null == (propValueType = prop.getValueType())) continue;
                            return typeMapper.getTypeByName(propValueType.toString());
                        }
                    }
                }
            }
            catch (Exception e) {
                log.warn("Could not find Data Type <{}> based on shape", (Object)property, (Object)e);
                return null;
            }
        }
        return null;
    }
}

