/*
 * Decompiled with CFR 0.152.
 */
package plugin.rtc.org.apache.wink.common.internal.providers.header;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import plugin.rtc.javax.ws.rs.core.Cookie;
import plugin.rtc.javax.ws.rs.ext.RuntimeDelegate;
import plugin.rtc.org.apache.wink.common.internal.i18n.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CookieHeaderDelegate
implements RuntimeDelegate.HeaderDelegate<Cookie> {
    private static Pattern whitespace = Pattern.compile("\\s");
    private static final String VERSION = "$Version";
    private static final String DOMAIN = "$Domain";
    private static final String PATH = "$Path";

    @Override
    public Cookie fromString(String cookie) throws IllegalArgumentException {
        if (cookie == null) {
            throw new IllegalArgumentException(Messages.getMessage("headerIsNull", "Cookie"));
        }
        String[] tokens = cookie.split("[;,]");
        if (tokens.length <= 0) {
            throw new IllegalArgumentException(Messages.getMessage("invalidCookie", cookie));
        }
        ModifiableCookie firstCookie = null;
        int cookieNum = 0;
        boolean versionSet = false;
        for (String token : tokens) {
            String value;
            String[] subTokens = token.trim().split("=", 2);
            String name = subTokens.length > 0 ? subTokens[0] : null;
            String string = value = subTokens.length > 1 ? subTokens[1] : null;
            if (value != null && value.startsWith("\"") && value.endsWith("\"") && value.length() > 1) {
                value = value.substring(1, value.length() - 1);
            }
            if (!name.startsWith("$")) {
                if (++cookieNum > 1) break;
                if (firstCookie == null) {
                    firstCookie = new ModifiableCookie();
                }
                firstCookie.name = name;
                firstCookie.value = value;
                continue;
            }
            if (name.startsWith(VERSION)) {
                if (firstCookie == null) {
                    firstCookie = new ModifiableCookie();
                } else if (versionSet) {
                    throw new IllegalArgumentException(Messages.getMessage("cookieCannotContainAddlVers", cookie));
                }
                versionSet = true;
                firstCookie.version = Integer.parseInt(value);
                continue;
            }
            if (name.startsWith(PATH) && cookie != null) {
                if (firstCookie == null) {
                    throw new IllegalArgumentException(Messages.getMessage("cookieMustStartWithVersion", cookie));
                }
                firstCookie.path = value;
                continue;
            }
            if (!name.startsWith(DOMAIN) || cookie == null) continue;
            if (firstCookie == null) {
                throw new IllegalArgumentException(Messages.getMessage("cookieMustStartWithVersion", cookie));
            }
            firstCookie.domain = value;
        }
        if (cookieNum == 0) {
            throw new IllegalArgumentException(Messages.getMessage("cookieDoesNotContainNAMEVALUE", cookie));
        }
        if (firstCookie != null) {
            return this.validateAndBuildCookie(firstCookie, cookie);
        }
        throw new IllegalArgumentException(Messages.getMessage("failedToParseCookie", cookie));
    }

    private Cookie validateAndBuildCookie(ModifiableCookie firstCookie, String cookie) {
        if (firstCookie.name == null || firstCookie.value == null) {
            throw new IllegalArgumentException(Messages.getMessage("failedToParseCookie", cookie));
        }
        return new Cookie(firstCookie.name, firstCookie.value, firstCookie.path, firstCookie.domain, firstCookie.version);
    }

    @Override
    public String toString(Cookie cookie) {
        if (cookie == null) {
            throw new IllegalArgumentException(Messages.getMessage("headerIsNull", "Cookie"));
        }
        StringBuilder cookieHeader = new StringBuilder();
        cookieHeader.append("$Version=").append(cookie.getVersion()).append(';');
        cookieHeader.append(cookie.getName()).append('=');
        this.appendValue(cookieHeader, cookie.getValue());
        if (cookie.getDomain() != null) {
            cookieHeader.append(";$Domain=");
            this.appendValue(cookieHeader, cookie.getDomain());
        }
        if (cookie.getPath() != null) {
            cookieHeader.append(";$Path=");
            this.appendValue(cookieHeader, cookie.getPath());
        }
        return cookieHeader.toString();
    }

    private void appendValue(StringBuilder cookieHeader, String value) {
        Matcher matcher = whitespace.matcher(value);
        boolean isQuote = matcher.find();
        if (isQuote) {
            cookieHeader.append('\"');
        }
        this.escapeQuotes(cookieHeader, value);
        if (isQuote) {
            cookieHeader.append('\"');
        }
    }

    private void escapeQuotes(StringBuilder b, String value) {
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c == '\"') {
                b.append('\\');
            }
            b.append(c);
        }
    }

    private static class ModifiableCookie {
        public String name;
        public String value;
        public int version = 0;
        public String path;
        public String domain;

        private ModifiableCookie() {
        }
    }
}

