/*
 * Decompiled with CFR 0.152.
 */
package plugin.rtc.org.apache.wink.common.internal.providers.entity;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import plugin.rtc.javax.ws.rs.Consumes;
import plugin.rtc.javax.ws.rs.Produces;
import plugin.rtc.javax.ws.rs.WebApplicationException;
import plugin.rtc.javax.ws.rs.core.Context;
import plugin.rtc.javax.ws.rs.core.MediaType;
import plugin.rtc.javax.ws.rs.core.MultivaluedMap;
import plugin.rtc.javax.ws.rs.ext.MessageBodyReader;
import plugin.rtc.javax.ws.rs.ext.MessageBodyWriter;
import plugin.rtc.javax.ws.rs.ext.Provider;
import plugin.rtc.javax.ws.rs.ext.Providers;
import plugin.rtc.org.apache.wink.common.RuntimeContext;
import plugin.rtc.org.apache.wink.common.annotations.Asset;
import plugin.rtc.org.apache.wink.common.annotations.Scope;
import plugin.rtc.org.apache.wink.common.internal.i18n.Messages;
import plugin.rtc.org.apache.wink.common.internal.registry.Injectable;
import plugin.rtc.org.apache.wink.common.internal.registry.InjectableFactory;
import plugin.rtc.org.apache.wink.common.internal.runtime.RuntimeContextTLS;
import plugin.rtc.org.apache.wink.common.internal.utils.AnnotationUtils;
import plugin.rtc.org.apache.wink.common.internal.utils.GenericsUtils;
import plugin.rtc.org.apache.wink.common.internal.utils.MediaTypeUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Scope(value=Scope.ScopeType.PROTOTYPE)
@Provider
public class AssetProvider
implements MessageBodyReader<Object>,
MessageBodyWriter<Object> {
    private static final Logger logger = LoggerFactory.getLogger(AssetProvider.class);
    @Context
    private Providers providers;
    private MessageBodyWriter<Object> writer;
    private BaseAssetMethod method;

    @Override
    public long getSize(Object t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    @Override
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        if (type.getAnnotation(Asset.class) == null) {
            return false;
        }
        return this.findProducesMethod(type, annotations, mediaType);
    }

    @Override
    public void writeTo(Object t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        RuntimeContext context = this.getRuntimeContext();
        Object[] args = InjectableFactory.getInstance().instantiate(this.method.getFormalParameters(), context);
        try {
            Object object = this.method.getMethod().invoke(t, args);
            this.writer.writeTo(object, this.method.getTypeClass(), this.method.getType(), annotations, mediaType, httpHeaders, entityStream);
        }
        catch (IllegalArgumentException e) {
            if (logger.isErrorEnabled()) {
                logger.error(Messages.getMessage("assetMethodInvokeError", this.method.getMethod().getName()), (Throwable)e);
            }
            throw new WebApplicationException(e);
        }
        catch (IllegalAccessException e) {
            if (logger.isErrorEnabled()) {
                logger.error(Messages.getMessage("assetMethodInvokeError", this.method.getMethod().getName()), (Throwable)e);
            }
            throw new WebApplicationException(e);
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            if (targetException instanceof RuntimeException) {
                throw (RuntimeException)targetException;
            }
            if (logger.isErrorEnabled()) {
                logger.error(Messages.getMessage("assetMethodInvokeError", this.method.getMethod().getName()), (Throwable)e);
            }
            throw new WebApplicationException(targetException);
        }
    }

    @Override
    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        if (type.getAnnotation(Asset.class) == null) {
            return false;
        }
        return this.findConsumesMethod(type, annotations, mediaType);
    }

    @Override
    public Object readFrom(Class<Object> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        RuntimeContext context = this.getRuntimeContext();
        Object[] args = InjectableFactory.getInstance().instantiate(this.method.getFormalParameters(), context);
        try {
            Object asset = type.newInstance();
            this.method.getMethod().invoke(asset, args);
            return asset;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            if (targetException instanceof RuntimeException) {
                throw (RuntimeException)targetException;
            }
            if (logger.isErrorEnabled()) {
                logger.error(Messages.getMessage("assetMethodInvokeError", this.method.getMethod().getName()), (Throwable)e);
            }
            throw new WebApplicationException(e);
        }
        catch (InstantiationException e) {
            if (logger.isErrorEnabled()) {
                logger.error(Messages.getMessage("assetMustHavePublicConstructor", type.getName()), (Throwable)e);
            }
            throw new WebApplicationException(e);
        }
        catch (Exception e) {
            if (logger.isErrorEnabled()) {
                logger.error(Messages.getMessage("assetMethodInvokeError", this.method.getMethod().getName()), (Throwable)e);
            }
            throw new WebApplicationException(e);
        }
    }

    private RuntimeContext getRuntimeContext() {
        return RuntimeContextTLS.getRuntimeContext();
    }

    private boolean findProducesMethod(Class<?> assetType, Annotation[] annotations, MediaType mediaType) {
        List<ProducesMethod> methods = this.getProducingMethods(assetType, mediaType);
        Collections.sort(methods, new Comparator<ProducesMethod>(){

            @Override
            public int compare(ProducesMethod o1, ProducesMethod o2) {
                return o2.compareTo(o1);
            }
        });
        for (ProducesMethod method : methods) {
            MessageBodyWriter<?> writer = this.providers.getMessageBodyWriter(method.getTypeClass(), method.getType(), annotations, mediaType);
            if (writer == null) continue;
            this.writer = writer;
            this.method = method;
            return true;
        }
        return false;
    }

    private boolean findConsumesMethod(Class<?> assetType, Annotation[] annotations, MediaType mediaType) {
        try {
            if (assetType.getConstructor(new Class[0]) == null) {
                if (logger.isWarnEnabled()) {
                    logger.warn(Messages.getMessage("assetCannotInstantiate", assetType.getName()));
                }
                return false;
            }
        }
        catch (SecurityException e) {
            if (logger.isWarnEnabled()) {
                logger.warn(Messages.getMessage("assetCannotInstantiate", assetType.getName()), (Throwable)e);
            }
            return false;
        }
        catch (NoSuchMethodException e) {
            if (logger.isWarnEnabled()) {
                logger.warn(Messages.getMessage("assetCannotInstantiate", assetType.getName()), (Throwable)e);
            }
            return false;
        }
        List<ConsumesMethod> methods = this.getConsumingMethods(assetType, mediaType);
        Collections.sort(methods, new Comparator<ConsumesMethod>(){

            @Override
            public int compare(ConsumesMethod o1, ConsumesMethod o2) {
                return o2.compareTo(o1);
            }
        });
        for (ConsumesMethod method : methods) {
            MessageBodyReader<?> reader = this.providers.getMessageBodyReader(method.getTypeClass(), method.getType(), annotations, mediaType);
            if (reader == null) continue;
            this.method = method;
            return true;
        }
        return false;
    }

    private List<ProducesMethod> getProducingMethods(Class<?> assetType, MediaType mediaType) {
        Method[] methods;
        LinkedList<ProducesMethod> locators = new LinkedList<ProducesMethod>();
        for (Method method : methods = assetType.getMethods()) {
            Produces annotation = method.getAnnotation(Produces.class);
            if (annotation == null) continue;
            String[] producesArray = AnnotationUtils.parseConsumesProducesValues(annotation.value());
            List<MediaType> produces = this.toSortedMediaTypes(producesArray);
            for (MediaType mt : produces) {
                ProducesMethod prodcuesMethod;
                if (!mt.isCompatible(mediaType) || (prodcuesMethod = new ProducesMethod(method, mt)).getType() == null) continue;
                locators.add(prodcuesMethod);
            }
        }
        return locators;
    }

    private List<ConsumesMethod> getConsumingMethods(Class<?> assetType, MediaType mediaType) {
        Method[] methods;
        LinkedList<ConsumesMethod> locators = new LinkedList<ConsumesMethod>();
        for (Method method : methods = assetType.getMethods()) {
            Consumes annotation = method.getAnnotation(Consumes.class);
            if (annotation == null) continue;
            String[] producesArray = AnnotationUtils.parseConsumesProducesValues(annotation.value());
            List<MediaType> produces = this.toSortedMediaTypes(producesArray);
            for (MediaType mt : produces) {
                ConsumesMethod consumesMethod;
                if (!mt.isCompatible(mediaType) || (consumesMethod = new ConsumesMethod(method, mt)).getType() == null) continue;
                locators.add(consumesMethod);
            }
        }
        return locators;
    }

    private List<MediaType> toSortedMediaTypes(String[] array) {
        LinkedList<MediaType> list = new LinkedList<MediaType>();
        for (String mt : array) {
            list.add(MediaType.valueOf(mt));
        }
        Collections.sort(list, new Comparator<MediaType>(){

            @Override
            public int compare(MediaType o1, MediaType o2) {
                return MediaTypeUtils.compareTo(o2, o1);
            }
        });
        return list;
    }

    private static class ConsumesMethod
    extends BaseAssetMethod {
        public ConsumesMethod(Method method, MediaType mediaType) {
            super(method, mediaType);
            for (Injectable fp : this.getFormalParameters()) {
                if (fp.getParamType() != Injectable.ParamType.ENTITY) continue;
                if (this.type != null) {
                    String methodName = method.getDeclaringClass().getName() + "." + method.getName();
                    if (logger.isErrorEnabled()) {
                        logger.error(Messages.getMessage("assetLocatorMethodMoreThanOneEntityParam", methodName));
                    }
                    throw new WebApplicationException();
                }
                this.type = fp.getGenericType();
                this.typeClass = fp.getType();
            }
        }
    }

    private static class ProducesMethod
    extends BaseAssetMethod {
        public ProducesMethod(Method method, MediaType mediaType) {
            super(method, mediaType);
            this.type = method.getGenericReturnType();
            this.typeClass = GenericsUtils.getClassType(this.type, method.getDeclaringClass());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class BaseAssetMethod
    implements Comparable<BaseAssetMethod> {
        private Method method;
        private List<Injectable> formalParameters;
        private MediaType mediaType;
        protected Type type;
        protected Class<?> typeClass;

        public BaseAssetMethod(Method method, MediaType mediaType) {
            this.method = method;
            this.mediaType = mediaType;
            this.createFormalParameters();
        }

        private void createFormalParameters() {
            this.formalParameters = new LinkedList<Injectable>();
            Annotation[][] parameterAnnotations = this.method.getParameterAnnotations();
            Type[] paramTypes = this.method.getGenericParameterTypes();
            int limit = paramTypes.length;
            for (int pos = 0; pos < limit; ++pos) {
                Injectable fp = InjectableFactory.getInstance().create(paramTypes[pos], parameterAnnotations[pos], this.method, false, null);
                this.formalParameters.add(fp);
            }
        }

        public List<Injectable> getFormalParameters() {
            return this.formalParameters;
        }

        public Method getMethod() {
            return this.method;
        }

        public MediaType getMediaType() {
            return this.mediaType;
        }

        public Type getType() {
            return this.type;
        }

        public Class<?> getTypeClass() {
            return this.typeClass;
        }

        public boolean equals(Object obj) {
            return this.method.equals(obj);
        }

        public int hashCode() {
            return this.method.hashCode();
        }

        @Override
        public int compareTo(BaseAssetMethod o) {
            return MediaTypeUtils.compareTo(this.getMediaType(), o.getMediaType());
        }
    }
}

