/*
 * Decompiled with CFR 0.152.
 */
package plugin.rtc.com.hp.hpl.jena.reasoner.rulesys.builtins;

import plugin.rtc.com.hp.hpl.jena.datatypes.RDFDatatype;
import plugin.rtc.com.hp.hpl.jena.datatypes.TypeMapper;
import plugin.rtc.com.hp.hpl.jena.graph.Node;
import plugin.rtc.com.hp.hpl.jena.graph.impl.LiteralLabel;
import plugin.rtc.com.hp.hpl.jena.reasoner.rulesys.RuleContext;
import plugin.rtc.com.hp.hpl.jena.reasoner.rulesys.builtins.BaseBuiltin;
import plugin.rtc.com.hp.hpl.jena.vocabulary.RDFS;

public class IsDType
extends BaseBuiltin {
    @Override
    public String getName() {
        return "isDType";
    }

    @Override
    public int getArgLength() {
        return 2;
    }

    @Override
    public boolean bodyCall(Node[] args, int length, RuleContext context) {
        this.checkArgs(length, context);
        Node val = this.getArg(0, args, context);
        Node dt = this.getArg(1, args, context);
        return IsDType.isTypeOK(val, dt);
    }

    public static boolean isTypeOK(Node val, Node dt) {
        if (!dt.isURI()) {
            return false;
        }
        if (val.isBlank()) {
            return true;
        }
        if (val.isLiteral()) {
            LiteralLabel ll = val.getLiteral();
            if (ll.getDatatype() != null && !ll.isWellFormed()) {
                return false;
            }
            if (dt.equals(RDFS.Nodes.Literal)) {
                return true;
            }
            RDFDatatype dtype = TypeMapper.getInstance().getSafeTypeByName(dt.getURI());
            return dtype.isValidLiteral(val.getLiteral());
        }
        return false;
    }
}

