/*
 * Decompiled with CFR 0.152.
 */
package plugin.rtc.com.hp.hpl.jena.rdf.model;

import plugin.rtc.com.hp.hpl.jena.graph.NodeFactory;
import plugin.rtc.com.hp.hpl.jena.rdf.model.Literal;
import plugin.rtc.com.hp.hpl.jena.rdf.model.Property;
import plugin.rtc.com.hp.hpl.jena.rdf.model.RDFNode;
import plugin.rtc.com.hp.hpl.jena.rdf.model.Resource;
import plugin.rtc.com.hp.hpl.jena.rdf.model.Selector;
import plugin.rtc.com.hp.hpl.jena.rdf.model.Statement;
import plugin.rtc.com.hp.hpl.jena.rdf.model.impl.LiteralImpl;

public class SimpleSelector
implements Selector {
    protected Resource subject;
    protected Property predicate;
    protected RDFNode object;

    public SimpleSelector() {
        this.subject = null;
        this.predicate = null;
        this.object = null;
    }

    public SimpleSelector(Resource subject, Property predicate, RDFNode object) {
        this.subject = subject;
        this.predicate = predicate;
        this.object = object;
    }

    public SimpleSelector(Resource subject, Property predicate, boolean object) {
        this(subject, predicate, String.valueOf(object));
    }

    public SimpleSelector(Resource subject, Property predicate, long object) {
        this(subject, predicate, String.valueOf(object));
    }

    public SimpleSelector(Resource subject, Property predicate, char object) {
        this(subject, predicate, String.valueOf(object));
    }

    public SimpleSelector(Resource subject, Property predicate, float object) {
        this(subject, predicate, String.valueOf(object));
    }

    public SimpleSelector(Resource subject, Property predicate, double object) {
        this(subject, predicate, String.valueOf(object));
    }

    public SimpleSelector(Resource subject, Property predicate, String object) {
        this(subject, predicate, object, "");
    }

    public SimpleSelector(Resource subject, Property predicate, String object, String language) {
        this.subject = subject;
        this.predicate = predicate;
        this.object = object != null ? this.literal(object, language) : null;
    }

    private Literal literal(String s, String lang) {
        return new LiteralImpl(NodeFactory.createLiteral(s, lang), null);
    }

    public SimpleSelector(Resource subject, Property predicate, Object object) {
        this.subject = subject;
        this.predicate = predicate;
        this.object = object != null ? this.literal(object.toString(), "") : null;
    }

    @Override
    public Resource getSubject() {
        return this.subject;
    }

    @Override
    public Property getPredicate() {
        return this.predicate;
    }

    @Override
    public RDFNode getObject() {
        return this.object;
    }

    @Override
    public boolean isSimple() {
        return this.getClass() == SimpleSelector.class;
    }

    @Override
    public boolean test(Statement s) {
        return !(this.subject != null && !this.subject.equals(s.getSubject()) || this.predicate != null && !this.predicate.equals(s.getPredicate()) || this.object != null && !this.object.equals(s.getObject()) || !this.selects(s));
    }

    public boolean selects(Statement s) {
        return true;
    }
}

