/*
 * Decompiled with CFR 0.152.
 */
package plugin.rtc.com.hp.hpl.jena.ontology.impl;

import plugin.rtc.com.hp.hpl.jena.enhanced.EnhGraph;
import plugin.rtc.com.hp.hpl.jena.enhanced.EnhNode;
import plugin.rtc.com.hp.hpl.jena.enhanced.Implementation;
import plugin.rtc.com.hp.hpl.jena.graph.Node;
import plugin.rtc.com.hp.hpl.jena.ontology.ConversionException;
import plugin.rtc.com.hp.hpl.jena.ontology.HasValueRestriction;
import plugin.rtc.com.hp.hpl.jena.ontology.Individual;
import plugin.rtc.com.hp.hpl.jena.ontology.OntModel;
import plugin.rtc.com.hp.hpl.jena.ontology.Profile;
import plugin.rtc.com.hp.hpl.jena.ontology.impl.RestrictionImpl;
import plugin.rtc.com.hp.hpl.jena.rdf.model.Literal;
import plugin.rtc.com.hp.hpl.jena.rdf.model.RDFNode;

public class HasValueRestrictionImpl
extends RestrictionImpl
implements HasValueRestriction {
    public static Implementation factory = new Implementation(){

        @Override
        public EnhNode wrap(Node n, EnhGraph eg) {
            if (this.canWrap(n, eg)) {
                return new HasValueRestrictionImpl(n, eg);
            }
            throw new ConversionException("Cannot convert node " + n + " to HasValueRestriction");
        }

        @Override
        public boolean canWrap(Node node, EnhGraph eg) {
            Profile profile = eg instanceof OntModel ? ((OntModel)((Object)eg)).getProfile() : null;
            return profile != null && profile.isSupported(node, eg, HasValueRestriction.class);
        }
    };

    public HasValueRestrictionImpl(Node n, EnhGraph g) {
        super(n, g);
    }

    @Override
    public void setHasValue(RDFNode value) {
        this.setPropertyValue(this.getProfile().HAS_VALUE(), "HAS_VALUE", value);
    }

    @Override
    public RDFNode getHasValue() {
        this.checkProfile(this.getProfile().HAS_VALUE(), "HAS_VALUE");
        RDFNode n = this.getPropertyValue(this.getProfile().HAS_VALUE());
        if (!(n instanceof Literal) && n.canAs(Individual.class)) {
            n = n.as(Individual.class);
        }
        return n;
    }

    @Override
    public boolean hasValue(RDFNode value) {
        return this.hasPropertyValue(this.getProfile().HAS_VALUE(), "HAS_VALUE", value);
    }

    @Override
    public void removeHasValue(RDFNode value) {
        this.removePropertyValue(this.getProfile().HAS_VALUE(), "HAS_VALUE", value);
    }
}

