/*
 * Decompiled with CFR 0.152.
 */
package plugin.rtc.com.hp.hpl.jena.graph.impl;

import java.io.File;
import java.io.FilenameFilter;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import plugin.rtc.com.hp.hpl.jena.graph.Graph;
import plugin.rtc.com.hp.hpl.jena.graph.impl.BaseGraphMaker;
import plugin.rtc.com.hp.hpl.jena.graph.impl.FileGraph;
import plugin.rtc.com.hp.hpl.jena.shared.AlreadyExistsException;
import plugin.rtc.com.hp.hpl.jena.util.CollectionFactory;
import plugin.rtc.com.hp.hpl.jena.util.iterator.ExtendedIterator;
import plugin.rtc.com.hp.hpl.jena.util.iterator.Map1;
import plugin.rtc.com.hp.hpl.jena.util.iterator.WrappedIterator;

public class FileGraphMaker
extends BaseGraphMaker
implements FileGraph.NotifyOnClose {
    protected String fileBase;
    protected boolean deleteOnClose;
    protected Map<File, FileGraph> created = CollectionFactory.createHashedMap();
    protected Set<File> toDelete = CollectionFactory.createHashedSet();
    private static Map1<String, String> unconvert = new Map1<String, String>(){

        @Override
        public String map1(String x) {
            return FileGraphMaker.toGraphname(x);
        }
    };

    public FileGraphMaker(String root) {
        this(root, false);
    }

    public FileGraphMaker(String root, boolean deleteOnClose) {
        this.fileBase = root;
        this.deleteOnClose = deleteOnClose;
    }

    public String getFileBase() {
        return this.fileBase;
    }

    @Override
    public Graph createGraph() {
        return FileGraph.create();
    }

    @Override
    public Graph createGraph(String name, boolean strict) {
        File f = this.withRoot(name);
        FileGraph already = this.created.get(f);
        if (already == null) {
            return this.remember(f, new FileGraph(this, f, true, strict));
        }
        if (strict) {
            throw new AlreadyExistsException(name);
        }
        return already.openAgain();
    }

    @Override
    public Graph openGraph(String name, boolean strict) {
        File f = this.withRoot(name);
        return this.created.containsKey(f) ? this.created.get(f).openAgain() : this.remember(f, new FileGraph(this, f, false, strict));
    }

    @Override
    public void notifyClosed(File f) {
        this.toDelete.add(f);
        this.created.remove(f);
    }

    private File withRoot(String name) {
        return new File(this.fileBase, FileGraphMaker.toFilename(name));
    }

    public static String toFilename(String name) {
        return name.replaceAll("_", "_U").replaceAll("/", "_S").replaceAll(":", "_C");
    }

    public static String toGraphname(String fileName) {
        return fileName.replaceAll("_C", ":").replaceAll("_S", "/").replaceAll("_U", "_");
    }

    @Override
    public void removeGraph(String name) {
        this.forget(this.withRoot(name)).delete();
    }

    private FileGraph remember(File f, FileGraph g) {
        this.created.put(f, g);
        return g;
    }

    private File forget(File f) {
        this.created.remove(f);
        return f;
    }

    @Override
    public boolean hasGraph(String name) {
        File f = this.withRoot(name);
        return this.created.containsKey(f) || f.exists();
    }

    @Override
    public void close() {
        if (this.deleteOnClose) {
            this.deleteFiles(this.created.keySet().iterator());
            this.deleteFiles(this.toDelete.iterator());
        }
    }

    protected void deleteFiles(Iterator<File> it) {
        while (it.hasNext()) {
            it.next().delete();
        }
    }

    public static FilenameFilter graphName() {
        return new FilenameFilter(){

            @Override
            public boolean accept(File file, String name) {
                return !new File(file, name).isDirectory() && FileGraph.isPlausibleGraphName(name);
            }
        };
    }

    @Override
    public ExtendedIterator<String> listGraphs() {
        String[] fileNames = new File(this.fileBase).list(FileGraphMaker.graphName());
        Set<String> allNames = CollectionFactory.createHashedSet(Arrays.asList(fileNames));
        for (File file : this.created.keySet()) {
            allNames.add(file.getName());
        }
        return WrappedIterator.create(allNames.iterator()).mapWith(unconvert);
    }
}

