/*
 * Decompiled with CFR 0.152.
 */
package plugin.rtc.com.hp.hpl.jena.graph.impl;

import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import plugin.rtc.com.hp.hpl.jena.graph.Capabilities;
import plugin.rtc.com.hp.hpl.jena.graph.Node;
import plugin.rtc.com.hp.hpl.jena.graph.NodeFactory;
import plugin.rtc.com.hp.hpl.jena.graph.Triple;
import plugin.rtc.com.hp.hpl.jena.graph.impl.AllCapabilities;
import plugin.rtc.com.hp.hpl.jena.graph.impl.GraphBase;
import plugin.rtc.com.hp.hpl.jena.graph.impl.SimpleEventManager;
import plugin.rtc.com.hp.hpl.jena.util.iterator.ExtendedIterator;
import plugin.rtc.com.hp.hpl.jena.util.iterator.Filter;
import plugin.rtc.com.hp.hpl.jena.util.iterator.WrappedIterator;

public class CollectionGraph
extends GraphBase {
    private Capabilities cgCapabilities = new AllCapabilities(){

        @Override
        public boolean iteratorRemoveAllowed() {
            return CollectionGraph.this.iteratorDeleteAllowed;
        }

        @Override
        public boolean handlesLiteralTyping() {
            return false;
        }
    };
    private final Collection<Triple> triples;
    private final boolean uniqueOnly;
    private final boolean iteratorDeleteAllowed;

    static boolean tripleContained(Triple patternTriple, Triple dataTriple) {
        return CollectionGraph.equalNode(patternTriple.getSubject(), dataTriple.getSubject()) && CollectionGraph.equalNode(patternTriple.getPredicate(), dataTriple.getPredicate()) && CollectionGraph.equalNode(patternTriple.getObject(), dataTriple.getObject());
    }

    private static boolean equalNode(Node m, Node n) {
        n = CollectionGraph.fixupNode(n);
        return (m = CollectionGraph.fixupNode(m)) == null || m == Node.ANY || m.equals(n);
    }

    private static Node fixupNode(Node node) {
        String lang;
        if (node == null || node == Node.ANY) {
            return node;
        }
        if (node.isLiteral() && (lang = node.getLiteralLanguage()) != null && !lang.equals("")) {
            node = NodeFactory.createLiteral(node.getLiteralLexicalForm(), lang.toLowerCase(Locale.ROOT));
        }
        return node;
    }

    public CollectionGraph() {
        this(new HashSet<Triple>(), true);
    }

    public CollectionGraph(Collection<Triple> triples) {
        this(triples, false);
    }

    public CollectionGraph(Collection<Triple> triples, boolean iteratorDeleteAllowed) {
        this.triples = triples;
        this.uniqueOnly = triples instanceof Set;
        this.iteratorDeleteAllowed = iteratorDeleteAllowed;
    }

    @Override
    protected ExtendedIterator<Triple> graphBaseFind(Triple m) {
        ExtendedIterator<Triple> iter = null;
        iter = this.iteratorDeleteAllowed ? SimpleEventManager.notifyingRemove(this, this.triples.iterator()) : WrappedIterator.createNoRemove(this.triples.iterator());
        return iter.filterKeep(new TripleMatchFilterEquality(m));
    }

    @Override
    public void performAdd(Triple t) {
        if (this.uniqueOnly || !this.triples.contains(t)) {
            this.triples.add(t);
        }
    }

    @Override
    public void performDelete(Triple t) {
        this.triples.remove(t);
    }

    @Override
    public Capabilities getCapabilities() {
        return this.cgCapabilities;
    }

    static class TripleMatchFilterEquality
    extends Filter<Triple> {
        protected final Triple tMatch;

        public TripleMatchFilterEquality(Triple tMatch) {
            this.tMatch = tMatch;
        }

        @Override
        public boolean accept(Triple t) {
            return CollectionGraph.tripleContained(this.tMatch, t);
        }
    }
}

