/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.report.legacybooks.testcases.query;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;
import org.squashtest.tm.api.report.criteria.Criteria;
import org.squashtest.tm.api.report.query.ReportQuery;
import org.squashtest.tm.api.repository.SqlQueryRunner;
import org.squashtest.tm.api.utils.CurrentUserHelper;
import org.squashtest.tm.plugin.report.legacybooks.testcases.beans.CufBean;
import org.squashtest.tm.plugin.report.legacybooks.testcases.beans.Dataset;
import org.squashtest.tm.plugin.report.legacybooks.testcases.beans.DatasetParamValue;
import org.squashtest.tm.plugin.report.legacybooks.testcases.beans.LinkedRequirementsBean;
import org.squashtest.tm.plugin.report.legacybooks.testcases.beans.NodeBean;
import org.squashtest.tm.plugin.report.legacybooks.testcases.beans.Parameter;
import org.squashtest.tm.plugin.report.legacybooks.testcases.beans.TestCaseBean;
import org.squashtest.tm.plugin.report.legacybooks.testcases.beans.TestCaseStepsBean;
import org.squashtest.tm.plugin.report.legacybooks.testcases.foundation.CriteriaEntry;
import org.squashtest.tm.plugin.report.legacybooks.testcases.foundation.CufType;
import org.squashtest.tm.plugin.report.legacybooks.testcases.foundation.EntityType;
import org.squashtest.tm.plugin.report.legacybooks.testcases.foundation.ReportOptions;
import org.squashtest.tm.plugin.report.legacybooks.testcases.query.TestCasesTreeFormatter;
import org.squashtest.tm.plugin.report.legacybooks.testcases.query.TestCasesTreeQueryFinder;

public class TestCasesTreeQuery
implements ReportQuery,
InitializingBean {
    private static final String MILESTONE_ID = "milestoneId";
    private static final String MILESTONE_LABEL = "milestoneLabel";
    private static final String TREE_PICKER = "TREE_PICKER";
    private static final String MILESTONE_PICKER = "MILESTONE_PICKER";
    private static final String TAG_PICKER = "TAG_PICKER";
    private static final String DATA = "data";
    private static final String SQL_FIND_MILESTONE_LABEL = "select label from MILESTONE where milestone_id = :milestoneId";
    private Collection<NodeBean> nodesBeans;
    private SqlQueryRunner runner;
    private TestCasesTreeQueryFinder queryFinder = new TestCasesTreeQueryFinder();
    private TestCasesTreeFormatter formatter = new TestCasesTreeFormatter();
    private CurrentUserHelper currentUserHelper;

    public void afterPropertiesSet() throws Exception {
        this.queryFinder.setRunner(this.runner);
    }

    public void setRunner(SqlQueryRunner runner) {
        this.runner = runner;
    }

    public void setCurrentUserHelper(CurrentUserHelper currentUserHelper) {
        this.currentUserHelper = currentUserHelper;
    }

    /*
     * WARNING - void declaration
     */
    public void executeQuery(Map<String, Criteria> crit, Map<String, Object> res) {
        this.nodesBeans = Collections.emptyList();
        HashMap<String, Boolean> optionsMap = new HashMap<String, Boolean>();
        Criteria options = crit.get(CriteriaEntry.REPORT_OPTIONS.getValue());
        optionsMap.put(ReportOptions.PRINT_STEPS.getValue(), false);
        optionsMap.put(ReportOptions.PRINT_LINKED_REQUIREMENTS.getValue(), false);
        optionsMap.put(ReportOptions.PRINT_CALL_STEPS.getValue(), false);
        optionsMap.put(ReportOptions.PRINT_PARAMETERS.getValue(), false);
        optionsMap.put(ReportOptions.PRINT_STEP_CUFS.getValue(), false);
        Collection selectedOptions = (Collection)options.getValue();
        for (String option : selectedOptions) {
            optionsMap.put(option, true);
        }
        Collection<Object[]> rawNodesData = this.getNodeBean(crit);
        this.nodesBeans = this.formatter.toNodesBean(rawNodesData);
        Collection<Long> tcIds = this.getTcIds(crit);
        if (!tcIds.isEmpty()) {
            Collection<Object[]> rawTestCaseData = this.queryFinder.getTestCasesData(tcIds);
            boolean printSteps = (Boolean)optionsMap.get(ReportOptions.PRINT_STEPS.getValue());
            ArrayList<LinkedRequirementsBean> linkedRequirementsBeans = new ArrayList();
            if (((Boolean)optionsMap.get(ReportOptions.PRINT_LINKED_REQUIREMENTS.getValue())).booleanValue()) {
                Collection<Object[]> rawLinkedReqData = this.queryFinder.getLinkedReqData(tcIds);
                linkedRequirementsBeans = this.formatter.toLinkedRequirementBean(rawLinkedReqData);
            }
            ArrayList<Parameter> parameters = new ArrayList();
            ArrayList<Dataset> datasets = new ArrayList();
            ArrayList<DatasetParamValue> datasetParamValuesData = new ArrayList();
            if (((Boolean)optionsMap.get(ReportOptions.PRINT_PARAMETERS.getValue())).booleanValue()) {
                Collection<Object[]> rawParametersData = this.queryFinder.getParametersData(tcIds);
                parameters = this.formatter.toParameter(rawParametersData);
                Collection<Object[]> rawDataSetData = this.queryFinder.getDataSetData(tcIds);
                datasets = this.formatter.toDataSet(rawDataSetData);
                Collection<Object[]> rawDataSetParamValuesData = this.queryFinder.getDataSetParamValueData(tcIds);
                datasetParamValuesData = this.formatter.toDataSetParamValue(rawDataSetParamValuesData);
            }
            Collection<Object> testCaseStepsBeans = new ArrayList();
            HashMap<String, Collection<CufBean>> stepCufMap = new HashMap<String, Collection<CufBean>>();
            if (((Boolean)optionsMap.get(ReportOptions.PRINT_STEPS.getValue())).booleanValue()) {
                void var18_23;
                Collection<Object[]> rawTestCaseStepsData = this.queryFinder.getTestCaseStepsData(tcIds);
                testCaseStepsBeans = this.formatter.toTestCaseSteps(rawTestCaseStepsData);
                if (((Boolean)optionsMap.get(ReportOptions.PRINT_CALL_STEPS.getValue())).booleanValue()) {
                    ArrayList<TestCaseStepsBean> caseStepsBeans = new ArrayList<TestCaseStepsBean>();
                    this.addCalledSteps(testCaseStepsBeans, caseStepsBeans);
                    testCaseStepsBeans = caseStepsBeans;
                }
                ArrayList<Long> stepIds = new ArrayList<Long>();
                for (TestCaseStepsBean testCaseStepsBean : testCaseStepsBeans) {
                    stepIds.add(testCaseStepsBean.getId());
                }
                ArrayList arrayList = new ArrayList();
                Collection<Object> stepNumCuf = new ArrayList();
                Collection<Object> stepTagCuf = new ArrayList();
                Collection<Object> stepRtfCuf = new ArrayList();
                if (!stepIds.isEmpty() && ((Boolean)optionsMap.get(ReportOptions.PRINT_STEP_CUFS.getValue())).booleanValue()) {
                    Collection<Object[]> rawStepCuf = this.queryFinder.getCufData(EntityType.TEST_STEP.name(), stepIds);
                    Collection<Object[]> rawStepNumCuf = this.queryFinder.getNumCufData(EntityType.TEST_STEP.name(), stepIds);
                    Collection<Object[]> rawStepTagCuf = this.queryFinder.getTagCufData(EntityType.TEST_STEP.name(), stepIds);
                    Collection<Object[]> rawStepRtfCuf = this.queryFinder.getRtfCufData(EntityType.TEST_STEP.name(), stepIds);
                    Collection<CufBean> collection = this.formatter.toCufBean(rawStepCuf);
                    stepNumCuf = this.formatter.toCufBean(rawStepNumCuf);
                    stepTagCuf = this.formatter.toTagCufBean(rawStepTagCuf);
                    stepRtfCuf = this.formatter.toCufBean(rawStepRtfCuf);
                }
                stepCufMap.put(CufType.CUFS.getValue(), (Collection<CufBean>)var18_23);
                stepCufMap.put(CufType.NUM_CUFS.getValue(), stepNumCuf);
                stepCufMap.put(CufType.TAG_CUFS.getValue(), stepTagCuf);
                stepCufMap.put(CufType.RTF_CUFS.getValue(), stepRtfCuf);
            }
            HashMap<String, Collection<CufBean>> testCaseCufMap = new HashMap<String, Collection<CufBean>>();
            Collection<Object[]> rawTestCaseCuf = this.queryFinder.getCufData(EntityType.TEST_CASE.name(), tcIds);
            Collection<CufBean> collection = this.formatter.toCufBean(rawTestCaseCuf);
            testCaseCufMap.put(CufType.CUFS.getValue(), collection);
            Collection<Object[]> rawTestCaseNumCuf = this.queryFinder.getNumCufData(EntityType.TEST_CASE.name(), tcIds);
            Collection<CufBean> testCaseNumCuf = this.formatter.toCufBean(rawTestCaseNumCuf);
            testCaseCufMap.put(CufType.NUM_CUFS.getValue(), testCaseNumCuf);
            Collection<Object[]> rawTestCaseTagCuf = this.queryFinder.getTagCufData(EntityType.TEST_CASE.name(), tcIds);
            Collection<CufBean> testCaseTagCuf = this.formatter.toTagCufBean(rawTestCaseTagCuf);
            testCaseCufMap.put(CufType.TAG_CUFS.getValue(), testCaseTagCuf);
            Collection<Object[]> rawTestCaseRtfCuf = this.queryFinder.getRtfCufData(EntityType.TEST_CASE.name(), tcIds);
            Collection<CufBean> testCaseRtfCuf = this.formatter.toCufBean(rawTestCaseRtfCuf);
            testCaseCufMap.put(CufType.RTF_CUFS.getValue(), testCaseRtfCuf);
            Collection<TestCaseBean> testCaseBeans = this.formatter.toTestCaseBean(rawTestCaseData, printSteps);
            this.formatter.bindAll(testCaseStepsBeans, testCaseCufMap, stepCufMap, linkedRequirementsBeans, testCaseBeans, parameters, datasets, datasetParamValuesData, this.nodesBeans);
        }
        res.put(DATA, this.nodesBeans);
        if (this.isMilestonePicker(crit)) {
            List milestoneIds = (List)crit.get(CriteriaEntry.MILESTONES.getValue()).getValue();
            HashMap params = new HashMap();
            params.put(MILESTONE_ID, milestoneIds.get(0));
            String milestoneLabel = (String)this.runner.executeUniqueSelect(SQL_FIND_MILESTONE_LABEL, params);
            res.put(MILESTONE_LABEL, milestoneLabel);
        }
    }

    private void addCalledSteps(Collection<TestCaseStepsBean> stepsBeans, Collection<TestCaseStepsBean> allSteps) {
        ArrayList<Long> tcAlreadyAdd = new ArrayList<Long>();
        for (TestCaseStepsBean testCaseStepsBean : stepsBeans) {
            if ("C".equals(testCaseStepsBean.getType())) {
                Long id = testCaseStepsBean.getId();
                Collection<Object[]> objects = this.queryFinder.getTestCaseStepsData(id);
                Collection<TestCaseStepsBean> testCaseStepsBeans = this.formatter.toCallStepBean(objects, testCaseStepsBean.getTestCaseId());
                tcAlreadyAdd.add(testCaseStepsBean.getTestCaseId());
                this.addCalledSteps(testCaseStepsBeans, allSteps);
                continue;
            }
            allSteps.add(testCaseStepsBean);
        }
    }

    public void setIdsByProjectQuery(Resource idsByProjectQuery) {
        String query = this.loadQuery(idsByProjectQuery);
        this.queryFinder.setIdsByProjectQuery(query);
    }

    public void setIdsByTagQuery(Resource idsByTagQuery) {
        String query = this.loadQuery(idsByTagQuery);
        this.queryFinder.setIdsByTagQuery(query);
    }

    public void setIdsBySelectionQuery(Resource idsBySelectionQuery) {
        String query = this.loadQuery(idsBySelectionQuery);
        this.queryFinder.setIdsBySelectionQuery(query);
    }

    public void setIdsByMilestoneQuery(Resource idsByMilestoneQuery) {
        String query = this.loadQuery(idsByMilestoneQuery);
        this.queryFinder.setIdsByMilestoneQuery(query);
    }

    public void setTestCaseDataQuery(Resource testCaseDataQuery) {
        String query = this.loadQuery(testCaseDataQuery);
        this.queryFinder.setTestCasesQuery(query);
    }

    public void setLinkedReqDataQuery(Resource linkedReqDataQuery) {
        String query = this.loadQuery(linkedReqDataQuery);
        this.queryFinder.setLinkedReqQuery(query);
    }

    public void setTestCaseStepsDataQuery(Resource testCaseStepsDataQuery) {
        String query = this.loadQuery(testCaseStepsDataQuery);
        this.queryFinder.setTestCaseStepsQuery(query);
    }

    public void setCufsDataQuery(Resource cufsDataQuery) {
        String query = this.loadQuery(cufsDataQuery);
        this.queryFinder.setCufQuery(query);
    }

    public void setNumCufsDataQuery(Resource numCufsDataQuery) {
        String query = this.loadQuery(numCufsDataQuery);
        this.queryFinder.setNumCufQuery(query);
    }

    public void setTagCufsDataQuery(Resource tagCufsDataQuery) {
        String query = this.loadQuery(tagCufsDataQuery);
        this.queryFinder.setTagCufQuery(query);
    }

    public void setRtfCufsDataQuery(Resource rtfCufsDataQuery) {
        String query = this.loadQuery(rtfCufsDataQuery);
        this.queryFinder.setRtfCufQuery(query);
    }

    public void setNodesByTestCaseIdsDataQuery(Resource nodesByTestCaseIdsDataQuery) {
        String query = this.loadQuery(nodesByTestCaseIdsDataQuery);
        this.queryFinder.setNodesByTestCaseIdsQuery(query);
    }

    public void setNodesByMilestonesDataQuery(Resource nodesByMilestonesDataQuery) {
        String query = this.loadQuery(nodesByMilestonesDataQuery);
        this.queryFinder.setNodesByMilestonesQuery(query);
    }

    public void setNodesByTagsDataQuery(Resource nodesByTagsDataQuery) {
        String query = this.loadQuery(nodesByTagsDataQuery);
        this.queryFinder.setNodesByTagsQuery(query);
    }

    public void setNodesByProjectIdsDataQuery(Resource nodesByProjectIdsDataQuery) {
        String query = this.loadQuery(nodesByProjectIdsDataQuery);
        this.queryFinder.setNodesByProjectIdsQuery(query);
    }

    public void setStepsByCallStepDataQuery(Resource stepsByCallStepDataQuery) {
        String query = this.loadQuery(stepsByCallStepDataQuery);
        this.queryFinder.setTestStepsByCallSteps(query);
    }

    public void setParameterDataQuery(Resource parameterDataQuery) {
        String query = this.loadQuery(parameterDataQuery);
        this.queryFinder.setParametersQuery(query);
    }

    public void setDataSetDataQuery(Resource dataSetDataQuery) {
        String query = this.loadQuery(dataSetDataQuery);
        this.queryFinder.setDataSetQuery(query);
    }

    public void setDataSetParamValueDataQuery(Resource dataSetParamValueDataQuery) {
        String query = this.loadQuery(dataSetParamValueDataQuery);
        this.queryFinder.setDataSetParamValueQuery(query);
    }

    private Collection<Long> getTcIds(Map<String, Criteria> criteriaMap) {
        Criteria selectionMode = criteriaMap.get(CriteriaEntry.TEST_CASES_SELECTION_MODE.getValue());
        Collection<Object> testCaseIdList = Collections.emptyList();
        List readableProjectIds = this.currentUserHelper.findReadableProjectIds();
        if (TREE_PICKER.equals(selectionMode.getValue())) {
            Criteria idsCrit = criteriaMap.get(CriteriaEntry.TEST_CASE_IDS.getValue());
            Collection testCaseIds = this.addNodesIds(idsCrit);
            testCaseIdList = this.queryFinder.findIdsBySelection(testCaseIds, readableProjectIds);
        } else if (MILESTONE_PICKER.equals(selectionMode.getValue())) {
            Collection milestones = (Collection)criteriaMap.get(CriteriaEntry.MILESTONES.getValue()).getValue();
            testCaseIdList = this.queryFinder.findIdsByMilestone(milestones, readableProjectIds);
        } else if (TAG_PICKER.equals(selectionMode.getValue())) {
            Collection tags = (Collection)criteriaMap.get(CriteriaEntry.TAGS.getValue()).getValue();
            testCaseIdList = this.queryFinder.findIdsByTags(tags, readableProjectIds);
        } else {
            Criteria idsCrit = criteriaMap.get(CriteriaEntry.PROJECT_IDS.getValue());
            if (!idsCrit.getValue().toString().trim().isEmpty()) {
                List<Long> projectIds = ((Collection)idsCrit.getValue()).stream().map(Long::valueOf).toList();
                readableProjectIds.retainAll(projectIds);
                testCaseIdList = this.queryFinder.findIdsByProject(readableProjectIds);
            }
        }
        return testCaseIdList;
    }

    private Collection<Object[]> getNodeBean(Map<String, Criteria> criteriaMap) {
        Criteria selectionMode = criteriaMap.get(CriteriaEntry.TEST_CASES_SELECTION_MODE.getValue());
        Collection<Object> result = new ArrayList();
        List readableProjectIds = this.currentUserHelper.findReadableProjectIds();
        if (TREE_PICKER.equals(selectionMode.getValue())) {
            Criteria idsCrit = criteriaMap.get(CriteriaEntry.TEST_CASE_IDS.getValue());
            Collection testCaseIds = this.addNodesIds(idsCrit);
            result = this.queryFinder.getNodesByTestCasesIds(testCaseIds, readableProjectIds);
        } else if (MILESTONE_PICKER.equals(selectionMode.getValue())) {
            Collection milestoneIds = (Collection)criteriaMap.get(CriteriaEntry.MILESTONES.getValue()).getValue();
            result = this.queryFinder.getNodesByMilestones(milestoneIds, readableProjectIds);
        } else if (TAG_PICKER.equals(selectionMode.getValue())) {
            Collection tags = (Collection)criteriaMap.get(CriteriaEntry.TAGS.getValue()).getValue();
            result = this.queryFinder.getNodesTags(tags, readableProjectIds);
        } else {
            Criteria idsCrit = criteriaMap.get(CriteriaEntry.PROJECT_IDS.getValue());
            if (!idsCrit.getValue().toString().trim().isEmpty()) {
                List<Long> projectIds = ((List)idsCrit.getValue()).stream().map(Long::valueOf).toList();
                readableProjectIds.retainAll(projectIds);
                result = this.queryFinder.getNodesByProjectIds(readableProjectIds);
            }
        }
        return result;
    }

    private Collection addNodesIds(Criteria idsCrit) {
        if (idsCrit != null) {
            Collection ids = ((Map)idsCrit.getValue()).values();
            if (!ids.isEmpty()) {
                HashSet nodesIds = new HashSet();
                nodesIds.addAll(ids);
                return nodesIds;
            }
            return Collections.emptyList();
        }
        return Collections.emptyList();
    }

    private boolean isMilestonePicker(Map<String, Criteria> criteriaMap) {
        Criteria selectionMode = criteriaMap.get(CriteriaEntry.TEST_CASES_SELECTION_MODE.getValue());
        return MILESTONE_PICKER.equals(selectionMode.getValue());
    }

    protected String loadQuery(Resource query) {
        InputStream is;
        try {
            is = query.getInputStream();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return new Scanner(is, "UTF-8").useDelimiter("\\A").next();
    }
}

