/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.mantis.internal.domain.project.customfields;

import jakarta.inject.Named;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSource;
import org.springframework.context.NoSuchMessageException;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Component;
import org.squashtest.tm.bugtracker.advanceddomain.Field;
import org.squashtest.tm.bugtracker.advanceddomain.FieldValue;
import org.squashtest.tm.bugtracker.advanceddomain.InputType;
import org.squashtest.tm.bugtracker.advanceddomain.Rendering;
import org.squashtest.tm.plugin.bugtracker.mantis.internal.client.model.Category;
import org.squashtest.tm.plugin.bugtracker.mantis.internal.client.model.Project;
import org.squashtest.tm.plugin.bugtracker.mantis.internal.client.model.ProjectCustomField;
import org.squashtest.tm.plugin.bugtracker.mantis.internal.client.model.Version;
import org.squashtest.tm.plugin.bugtracker.mantis.internal.client.model.template.LabelTemplate;
import org.squashtest.tm.plugin.bugtracker.mantis.internal.client.model.template.NameTemplate;
import org.squashtest.tm.plugin.bugtracker.mantis.internal.domain.project.customfields.converter.CustomFieldConverterType;
import org.squashtest.tm.plugin.bugtracker.mantis.internal.domain.project.customfields.converter.factory.CustomFieldConverterFactory;

@Component(value="squash.tm.plugin.bugtracker.mantis.SchemeBuilder")
public class SchemeBuilder {
    private final MessageSource messageSource;
    private static final Logger LOGGER = LoggerFactory.getLogger(SchemeBuilder.class);
    public static final String DEFAULT_SCHEME = "Issue";
    public static final String NONE_OPTION = "none";
    public static final String HAVE_NOT_TRIED_OPTION = "have not tried";
    private final CustomFieldConverterFactory customFieldConverterFactory = new CustomFieldConverterFactory();

    public SchemeBuilder(@Named(value="mantisConnectorMessageSource") MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    public Map<String, List<Field>> buildSchemes(Project project, List<LabelTemplate> severities, List<LabelTemplate> priorities, List<LabelTemplate> reproducibilities) {
        HashMap<String, List<Field>> scheme = new HashMap<String, List<Field>>();
        ArrayList<Field> fields = new ArrayList<Field>();
        List<Category> categories = project.getCategories();
        List<Version> versions = project.getVersions();
        fields.add(this.buildCategoryField(categories));
        fields.add(this.buildReproducibilityField(reproducibilities));
        fields.add(this.buildSeveritiesField(severities));
        fields.add(this.buildPrioritiesField(priorities));
        fields.add(this.buildVersionsField(versions));
        fields.add(this.buildAssigneeField());
        fields.add(this.buildSummaryField());
        fields.add(this.buildDescriptionField());
        fields.add(this.buildStepsToReproduceField());
        fields.add(this.buildAdditionalInformationField());
        fields.add(this.buildTagsField());
        fields.addAll(this.getAllFields(project));
        fields.add(this.buildAttachmentsField());
        fields.add(this.buildVisibilityField());
        scheme.put(DEFAULT_SCHEME, fields);
        return scheme;
    }

    private Field createBasicField(String fieldId, String label, String type) {
        Field field = new Field(fieldId, label);
        Rendering rendering = new Rendering();
        InputType inputType = new InputType(type, InputType.TypeName.UNKNOWN.value);
        rendering.setInputType(inputType);
        field.setRendering(rendering);
        return field;
    }

    private List<Field> getAllFields(Project project) {
        List<ProjectCustomField> customFields = project.getCustomFields();
        ArrayList<Field> fields = new ArrayList<Field>();
        customFields.forEach(customField -> {
            CustomFieldConverterType converterType = this.customFieldConverterFactory.get(customField.getType());
            Field converted = converterType.getConverter().convert((ProjectCustomField)customField, converterType.getTypeValue());
            fields.add(converted);
        });
        return fields;
    }

    private Field createDropdownListField(String id, String label) {
        return this.createBasicField(id, label, InputType.TypeName.DROPDOWN_LIST.value);
    }

    private Field buildCategoryField(List<Category> categories) {
        String label = this.messageSource.getMessage("interface.report.category.label", null, LocaleContextHolder.getLocale());
        Field field = this.buildCollectionField(categories, label, "category");
        field.getRendering().setRequired(true);
        return field;
    }

    private Field buildSeveritiesField(List<LabelTemplate> severities) {
        String label = this.messageSource.getMessage("interface.report.severity.label", null, LocaleContextHolder.getLocale());
        return this.buildTranslationCollectionField(severities, label, "severity");
    }

    private Field buildReproducibilityField(List<LabelTemplate> reproducibilities) {
        String label = this.messageSource.getMessage("interface.report.reproducibility.label", null, LocaleContextHolder.getLocale());
        Field field = this.buildTranslationCollectionField(reproducibilities, label, "reproducibility");
        List<FieldValue> possibleValues = Arrays.stream(field.getPossibleValues()).collect(Collectors.toList());
        FieldValue defaultFieldValue = possibleValues.stream().filter(value -> value.getId().equals(HAVE_NOT_TRIED_OPTION)).findAny().orElse(null);
        if (!Objects.isNull(defaultFieldValue)) {
            int defaultValueIndex = possibleValues.indexOf(defaultFieldValue);
            Collections.swap(possibleValues, defaultValueIndex, 0);
            field.setPossibleValues(possibleValues.toArray(new FieldValue[0]));
        }
        return field;
    }

    private Field buildPrioritiesField(List<LabelTemplate> priorities) {
        String label = this.messageSource.getMessage("interface.report.priority.label", null, LocaleContextHolder.getLocale());
        return this.buildTranslationCollectionField(priorities, label, "priority");
    }

    private Field buildAssigneeField() {
        String label = this.messageSource.getMessage("interface.report.assignee.label", null, LocaleContextHolder.getLocale());
        return this.generateTextField("assignee", label);
    }

    private Field buildSummaryField() {
        String label = this.messageSource.getMessage("interface.report.summary.label", null, LocaleContextHolder.getLocale());
        Field field = this.generateTextField("summary", label);
        field.getRendering().setRequired(true);
        return field;
    }

    private Field buildVersionsField(List<Version> versions) {
        String label = this.messageSource.getMessage("interface.report.version.label", null, LocaleContextHolder.getLocale());
        Field field = this.buildCollectionField(versions, label, "version");
        List<FieldValue> possibleVersions = Arrays.stream(field.getPossibleValues()).collect(Collectors.toList());
        possibleVersions.add(0, this.addEmptyOption());
        field.setPossibleValues(possibleVersions.toArray(new FieldValue[0]));
        return field;
    }

    private Field buildCollectionField(List<? extends NameTemplate> values, String label, String fieldId) {
        Field field = this.createDropdownListField(fieldId, label);
        FieldValue[] possibleValues = (FieldValue[])values.stream().map(value -> new FieldValue(value.getName(), value.getName())).toArray(FieldValue[]::new);
        field.setPossibleValues(possibleValues);
        return field;
    }

    private Field buildTranslationCollectionField(List<? extends LabelTemplate> values, String label, String fieldId) {
        Field field = this.createDropdownListField(fieldId, label);
        String code = "interface.report." + fieldId + ".value.";
        FieldValue[] possibleValues = (FieldValue[])values.stream().map(value -> new FieldValue(value.getName(), this.translateFieldName(code, value.getName().replace(" ", "-"), value.getLabel()))).toArray(FieldValue[]::new);
        field.setPossibleValues(possibleValues);
        return field;
    }

    public String translateFieldName(String code, String fieldName, String fieldLabel) {
        try {
            String newLabel = this.messageSource.getMessage(code + fieldName, null, LocaleContextHolder.getLocale());
            return newLabel;
        }
        catch (NoSuchMessageException e) {
            LOGGER.debug("Unable to translate : " + fieldName, (Throwable)e);
            return fieldLabel;
        }
    }

    private Field generateTextField(String id, String label) {
        return this.createBasicField(id, label, InputType.TypeName.TEXT_FIELD.value);
    }

    private Field generateCheckBoxField(String id, String label) {
        return this.createBasicField(id, label, InputType.TypeName.CHECKBOX.value);
    }

    private Field buildDescriptionField() {
        String label = this.messageSource.getMessage("interface.report.description.label", null, LocaleContextHolder.getLocale());
        Field field = this.generateAreaField("description", label);
        field.getRendering().setRequired(true);
        return field;
    }

    private Field buildAdditionalInformationField() {
        String label = this.messageSource.getMessage("interface.report.comment.label", null, LocaleContextHolder.getLocale());
        return this.generateAreaField("additionalInformation", label);
    }

    private Field buildStepsToReproduceField() {
        String label = this.messageSource.getMessage("interface.report.steps-to-reproduce.label", null, LocaleContextHolder.getLocale());
        return this.generateAreaField("stepsToReproduce", label);
    }

    private Field buildVisibilityField() {
        String label = this.messageSource.getMessage("interface.report.visibility.label", null, LocaleContextHolder.getLocale());
        return this.generateCheckBoxField("viewState", label);
    }

    private Field generateAreaField(String id, String label) {
        return this.createBasicField(id, label, InputType.TypeName.TEXT_AREA.value);
    }

    private Field buildTagsField() {
        String label = this.messageSource.getMessage("interface.report.tags.label", null, LocaleContextHolder.getLocale());
        return this.createBasicField("tags", label, InputType.TypeName.TAG_LIST.value);
    }

    private Field buildAttachmentsField() {
        String label = this.messageSource.getMessage("interface.report.attachments.label", null, LocaleContextHolder.getLocale());
        return this.createBasicField("attachments", label, InputType.TypeName.FILE_UPLOAD.value);
    }

    private FieldValue addEmptyOption() {
        String label = this.messageSource.getMessage("interface.report.lists.emptyversion.label", null, LocaleContextHolder.getLocale());
        return new FieldValue(NONE_OPTION, label);
    }
}

