/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.validators;

import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.springframework.stereotype.Component;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.validation.ValidationUtils;
import org.springframework.validation.Validator;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.domain.testcase.Parameter;
import org.squashtest.tm.plugin.rest.controller.helper.ErrorHandlerHelper;
import org.squashtest.tm.plugin.rest.jackson.model.RestType;
import org.squashtest.tm.plugin.rest.jackson.model.TestCaseDto;
import org.squashtest.tm.plugin.rest.jackson.model.TestStepDto;
import org.squashtest.tm.plugin.rest.validators.ParameterValidator;
import org.squashtest.tm.plugin.rest.validators.TestStepValidator;
import org.squashtest.tm.plugin.rest.validators.helper.TestCaseDtoValidationHelper;

@Component
public class TestCasePostValidator
implements Validator {
    @Inject
    private TestCaseDtoValidationHelper testCaseDtoValidationHelper;
    @Inject
    private ParameterValidator parameterValidator;
    @Inject
    private TestStepValidator testStepValidator;

    public boolean supports(Class<?> clazz) {
        return TestCaseDto.class.equals(clazz);
    }

    public void validate(Object target, Errors errors) {
        TestCaseDto testCaseDto = (TestCaseDto)target;
        if (testCaseDto.getId() != null) {
            errors.rejectValue("id", "generated value", "This attribute is generated by database and should not be provided. If you want to update an existing test case, please do a patch request to the test case id. ");
        }
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"name", (String)"required", (String)"This attribute can't be empty");
        this.testCaseDtoValidationHelper.checkParent(errors, testCaseDto, RestType.TEST_CASE);
        if (errors.hasErrors()) {
            return;
        }
        this.testCaseDtoValidationHelper.checkInvalidAttributeForEachTestCaseType(errors, testCaseDto);
        this.testCaseDtoValidationHelper.assignProject(testCaseDto);
        this.testCaseDtoValidationHelper.assignInfoList(errors, testCaseDto);
        this.testCaseDtoValidationHelper.checkCufs(errors, testCaseDto, BindableEntity.TEST_CASE);
        this.testCaseDtoValidationHelper.checkAutomationAttributes(errors, testCaseDto);
    }

    public void validateRequirements(long testCaseId, List<Long> requirementIds, String errorMessage) throws BindException {
        ArrayList<Errors> errors = new ArrayList<Errors>();
        TestCaseDto testCaseDto = new TestCaseDto();
        BeanPropertyBindingResult validationBean = new BeanPropertyBindingResult((Object)testCaseDto, errorMessage);
        this.testCaseDtoValidationHelper.checkEntityExist((Errors)validationBean, RestType.TEST_CASE, testCaseId);
        for (Long id : requirementIds) {
            this.testCaseDtoValidationHelper.checkEntityExist((Errors)validationBean, RestType.REQUIREMENT, id);
        }
        if (validationBean.hasErrors()) {
            errors.add((Errors)validationBean);
        }
        ErrorHandlerHelper.throwIfError(testCaseDto, errors, errorMessage);
    }

    public void validateParameters(TestCaseDto testCaseDto, List<Errors> errors, BindingResult validation) {
        Set<Parameter> parameters = testCaseDto.getParameters();
        if (parameters == null) {
            return;
        }
        for (Parameter parameter : parameters) {
            this.parameterValidator.validate(parameter, (Errors)validation);
            if (!validation.hasErrors()) continue;
            errors.add((Errors)validation);
        }
    }

    public void validateTestSteps(TestCaseDto testCaseDto, List<Errors> errors, BindingResult validation) {
        List<TestStepDto> stepDtos = testCaseDto.getSteps();
        Long projectId = testCaseDto.getProject().getId();
        if (stepDtos == null) {
            return;
        }
        for (TestStepDto stepDto : stepDtos) {
            stepDto.setProjectId(projectId);
            this.testStepValidator.validate(stepDto, (Errors)validation);
            if (!validation.hasErrors()) continue;
            errors.add((Errors)validation);
        }
    }
}

