/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.validators;

import jakarta.inject.Inject;
import java.util.ArrayList;
import org.springframework.stereotype.Component;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.BindException;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.plugin.rest.controller.helper.ErrorHandlerHelper;
import org.squashtest.tm.plugin.rest.jackson.model.RestType;
import org.squashtest.tm.plugin.rest.jackson.model.TestCaseFolderDto;
import org.squashtest.tm.plugin.rest.validators.helper.TestCaseFolderDtoValidationHelper;

@Component
public class TestCaseFolderPatchValidator
implements Validator {
    private static final String PATCH_TESTCASE_FOLDER = "patch-test-Case-folder";
    @Inject
    private TestCaseFolderDtoValidationHelper testCaseFolderDtoValidationHelper;

    public boolean supports(Class<?> clazz) {
        return TestCaseFolderDto.class.equals(clazz);
    }

    public void validate(Object target, Errors errors) {
        TestCaseFolderDto folderPatch = (TestCaseFolderDto)target;
        this.testCaseFolderDtoValidationHelper.checkEntityExist(errors, RestType.TEST_CASE_FOLDER, folderPatch.getId());
        this.testCaseFolderDtoValidationHelper.loadProject(folderPatch);
        this.testCaseFolderDtoValidationHelper.checkParent(errors, folderPatch, RestType.TEST_CASE_FOLDER);
        this.testCaseFolderDtoValidationHelper.checkCufs(errors, folderPatch, BindableEntity.TESTCASE_FOLDER);
    }

    public void validatePatchTestCaseFolder(TestCaseFolderDto patch) throws BindException {
        ArrayList<Errors> errors = new ArrayList<Errors>();
        BeanPropertyBindingResult validation = new BeanPropertyBindingResult((Object)patch, PATCH_TESTCASE_FOLDER);
        this.validate(patch, (Errors)validation);
        if (validation.hasErrors()) {
            errors.add((Errors)validation);
        }
        ErrorHandlerHelper.throwIfError(patch, errors, PATCH_TESTCASE_FOLDER);
    }
}

