/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.jackson.model;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import org.squashtest.tm.domain.customfield.CustomField;
import org.squashtest.tm.domain.customfield.CustomFieldValue;
import org.squashtest.tm.domain.customfield.RawValue;
import org.squashtest.tm.domain.denormalizedfield.DenormalizedFieldValue;
import org.squashtest.tm.domain.denormalizedfield.DenormalizedMultiSelectField;
import org.squashtest.tm.plugin.rest.jackson.deserializer.RestRawValueDeserializer;
import org.squashtest.tm.plugin.rest.jackson.serializer.RestRawValueSerializer;

public class CustomFieldValueDto {
    private String code;
    private String label;
    @JsonSerialize(using=RestRawValueSerializer.class)
    @JsonDeserialize(using=RestRawValueDeserializer.class)
    private RawValue value;

    public CustomFieldValueDto() {
    }

    public CustomFieldValueDto(CustomField customField, CustomFieldValue customFieldValue) {
        this.code = customField.getCode();
        this.label = customField.getLabel();
        this.value = customFieldValue.asRawValue();
    }

    public CustomFieldValueDto(DenormalizedFieldValue dfv) {
        this.code = dfv.getCode();
        this.label = dfv.getLabel();
        RawValue rawValue = DenormalizedMultiSelectField.class.isAssignableFrom(dfv.getClass()) ? new RawValue(((DenormalizedMultiSelectField)dfv).getValues()) : new RawValue(dfv.getValue());
        this.value = rawValue;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public RawValue getValue() {
        return this.value;
    }

    public void setValue(RawValue value) {
        this.value = value;
    }
}

