/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.controller;

import jakarta.inject.Inject;
import org.springframework.hateoas.EntityModel;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.ResponseBody;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.domain.campaign.SprintGroup;
import org.squashtest.tm.plugin.rest.core.jackson.DynamicFilterExpression;
import org.squashtest.tm.plugin.rest.core.web.BaseRestController;
import org.squashtest.tm.plugin.rest.core.web.EntityGetter;
import org.squashtest.tm.plugin.rest.core.web.RestApiController;
import org.squashtest.tm.plugin.rest.core.web.UseDefaultRestApiConfiguration;
import org.squashtest.tm.plugin.rest.service.RestSprintGroupService;

@RestApiController(value=SprintGroup.class)
@UseDefaultRestApiConfiguration
public class RestSprintGroupController
extends BaseRestController {
    @Inject
    private RestSprintGroupService sprintGroupService;

    @GetMapping(value={"/sprint-groups/{id}"})
    @EntityGetter
    @ResponseBody
    @DynamicFilterExpression(value="id, name")
    public ResponseEntity<EntityModel<SprintGroup>> findSprintGroup(@PathVariable(value="id") long id) {
        SprintGroup sprintGroup = this.sprintGroupService.getOne(id);
        EntityModel entityModel = this.toEntityModel((Identified)sprintGroup);
        entityModel.add(this.linkService.createLinkTo((Identified)sprintGroup.getProject()));
        return ResponseEntity.ok((Object)entityModel);
    }
}

