/*
 *     This file is part of the Campaign Assistant for Squash TM (henix-tm-wizard-campaignassistant) project.
 *     Copyright (C) 2017 Henix - All Rights Reserved
 *
 *     Unauthorized copying of this file, via any medium is strictly prohibited
 *     Proprietary and confidential
 *
 * 	 (C)Henix. Tous droits réservés.
 *
 * 	Avertissement : ce programme est protégé par la loi relative au droit d'auteur et par les conventions internationales. Toute reproduction ou distribution partielle ou totale du logiciel, par quelque moyen que ce soit, est strictement interdite.
 */
define([ "jquery", "backbone", "underscore", "app/squash.handlebars.helpers", "squash.translator", "squash.dateutils" ], function($,
		backbone, _, Handlebars, translator, chartUtils, dateutils) {
	"use strict";

    // *********** Prefiling the ajax with the required token (Squash 1.18+) ***********

    if ($("meta[name='_csrf']").length > 0){
        $.ajaxPrefilter(function (options, originalOptions, jqXHR) {
            var token = $("meta[name='_csrf']").attr("content");
            var header = $("meta[name='_csrf_header']").attr("content");
            jqXHR.setRequestHeader(header, token);
        });
    }


	var abstractStepView = Backbone.View.extend({
		el : "#current-step",

        /** Init function. */
		_initialize : function(data, wizrouter) {
			this.router = wizrouter;
			this.steps = this.model.get("steps");
			var currStep = _.findWhere(this.steps, {name : data.name});
			this.currStep = currStep;
			this.next = currStep.nextStep;
			this.previous = currStep.prevStep;
			this.updateMode = true;

			this.showViewTitle(currStep.viewTitle, currStep.stepNumber);
			this.initButtons(currStep.buttons);

            if(this.hasNoSelectedNode()) {
                this.hideAllButtons();
                this.updateMode = false;
                this.render(data, $("#no-selection-step-tpl"));
            }
            else if(this.hasAllNeededAttributes()) {
			    this.render(data, $(this.tmpl));
                this.prepareUI();
                this.reloadDataInView();
			} else {
			    this.showPrevButtonOnly();
                this.updateMode = false;
			    this.render(data, $("#missing-params-step-tpl"));
			    return;
			}

		},

        /** Verifies if a node has not been previously selected in the tree.
        * @return true if no node has been selected
        *         false if yes...
        */
        hasNoSelectedNode: function() {
            var selectedNode = this.model.get("selectedNode");
            return !(selectedNode.id && selectedNode.type);
        },

        /** Verifies if all the needed attributes are set in the model for the current step. */
        hasAllNeededAttributes: function() {
            var self = this;
            var result = true;
            var neededParams = this.currStep.neededParameters;
            _.each(neededParams, function(param) {
                var value = self.model.get(param);
                if(value === undefined) result = false;
            });
            return result;
        },

        /** Gets information from the view and set it in the model. */
        updateModel : function() {

            // do in superclass
        },

        /** Renders special components (load available options in listboxes, open CKEditors, etc...).
        * May be Asynchronous. */
		prepareUI : function() {

			// Defined in subclasses
		},

        /** Reloads the view to comply the current model. */
		reloadDataInView : function() {

		    // Defined in subclasses
		},

        /** Writes the title in the title bar, accordingly to the current step. */
		showViewTitle : function(title, stepNumber) {
            var computedTitle = this._getStepTitle(title, stepNumber);
            $("#step-title").text(computedTitle);
        },

        /** Get the title of a Step page (i.e. '[Step 4/5] : MyStep'), according to the step title and the step number.*/
        _getStepTitle: function(title, stepNumber) {
            return "[" + translator.get("campaignassistant.wizard.step.label") + " " + this._getStepNumberTitle(stepNumber) + "] " + translator.get(title);
        },

        /** Get the String displaying the current step number
        *   and the total number of steps (i.e. "Step 4/5").
        *
        *   /!\ For the moment the total number is fixed to 5. But if several
        *   actions are available, one must find the total number
        *   of steps according to the selected action and the step number.
        */
        _getStepNumberTitle: function(stepNumber) {
            var action = "iterationReplication"; // action is fixed for the moment
            var numberMap = this.model.get("totalStepNumberByAction");
            var totalStepNumber = numberMap[action];
            return stepNumber + "/" + totalStepNumber;

        },

        /** Shows the available buttons in the page. */
		initButtons : function (buttons){

			var allButtons = ["previous", "next", "create", "generate"];

			_.each(buttons, function(button) {
				var select = $("#" + button);
				select.show();
			});

			_.chain(allButtons).difference(buttons).each(function(button) {
				var select = $("#" + button);
				select.hide();
			}
			);

		},

        /** Hides all the buttons */
        hideAllButtons: function() {
            var allButtons = ["previous", "next", "create", "generate"];
            _.each(allButtons, function(buttonId) {
                var btn = $("#" + buttonId);
                btn.hide();
            });
        },

        /** Shows only the 'previous' button and hide the others. */
		showPrevButtonOnly: function() {
            this.hideAllButtons();
		    var previousButton = $("#previous");
		    previousButton.show();
		},

        /** Hides all the buttons. */
        _disableAllButtons: function() {

            $("#next").hide();
        },

        /** Gets the name of the previous step. */
        _getPreviousStep: function() {
            var previousStep = this.previous;
            if(typeof previousStep === 'object') {
                var determinant = this.currStep.previousStepDeterminant;
                previousStep = previousStep[this.model.get(determinant)];
            }
            return previousStep;
        },

        /** Gets the name of the next step. */
        _getNextStep: function() {
            var nextStep = this.next;
            if(typeof nextStep === 'object') {
                var determinant = this.currStep.nextStepDeterminant;
                nextStep = nextStep[this.model.get(determinant)];
            }
            return nextStep;
        },

        /** Navigates to the previous step. */
        navigatePrevious : function() {

            this.router.navigate(this._getPreviousStep(), {trigger : true});
        },

        /** Navigates to the next step. */
		navigateNext : function() {
		    if(this.updateMode === true) this.updateModel();
			if(this._getNextStep() === "previewStep") this.updateTestPlan();
            this.router.navigate(this._getNextStep(), {trigger : true});
		},

        /** Creates the view and appends it in the page. */
		render : function(data, tmpl) {
			var src = tmpl.html();
			this.template = Handlebars.compile(src);

			this.$el.append(this.template(data));

			return this;
		},

        /** Destroys current view. */
		destroy_view : function() {

			this.undelegateEvents();
			this.$el.removeData().unbind();
			this.remove();
			Backbone.View.prototype.remove.call(this);
		}
	});

	abstractStepView.extend = function(child) {
		var view = Backbone.View.extend.apply(this, arguments);
		view.prototype.events = _.extend({}, this.prototype.events, child.events);
		return view;
	};

	return abstractStepView;

});
