/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.report.books.testcases.beans;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.squashtest.tm.plugin.report.books.testcases.beans.Cuf;
import org.squashtest.tm.plugin.report.books.testcases.beans.Dataset;
import org.squashtest.tm.plugin.report.books.testcases.beans.I18nHelper;
import org.squashtest.tm.plugin.report.books.testcases.beans.LinkedRequirements;
import org.squashtest.tm.plugin.report.books.testcases.beans.Parameter;
import org.squashtest.tm.plugin.report.books.testcases.beans.PrintableCuf;
import org.squashtest.tm.plugin.report.books.testcases.beans.TestCaseSteps;

public class TestCase {
    private boolean printChain = true;
    private Long id;
    private String name;
    private String description;
    private String prerequisites;
    private Long level;
    private String createdBy;
    private String createdOn;
    private String lastModifiedBy;
    private String lastModifiedOn;
    private String paragraph;
    private String reference;
    private String importance;
    private String nature;
    private String type;
    private String natureType;
    private String typeType;
    private String status;
    private Long allowAutomationWorkflow;
    private String automatable;
    private String requestStatus;
    private String automationPriority;
    private Long executionMode;
    private Long folder;
    private String chain;
    private String chainDescription;
    private Long attachments;
    private String sortingChain;
    private String kind;
    private List<TestCaseSteps> tcSteps = new ArrayList<TestCaseSteps>();
    private List<PrintableCuf> printableCufs;
    private List<LinkedRequirements> linkedRequirements;
    private String milestoneNames;
    private List<Long> nodeIds;
    private String script;
    private List<Parameter> parameters = new ArrayList<Parameter>();
    private List<Dataset> datasets = new ArrayList<Dataset>();
    private boolean printParameters;
    private boolean printSteps;
    private boolean printLinkedReq;
    private boolean printFolder;
    private boolean printMilestones;

    public boolean acceptAsCuf(Cuf cufBean) {
        return cufBean.getEntityId().equals(this.id);
    }

    public boolean acceptAsPrintCuf(PrintableCuf printCufBean) {
        return printCufBean.getEntityId().equals(this.id);
    }

    public boolean isFolder() {
        return this.folder == 1L;
    }

    public boolean isUnmodified() {
        return StringUtils.isBlank((CharSequence)this.lastModifiedOn);
    }

    public boolean isNoReference() {
        return StringUtils.isBlank((CharSequence)this.reference);
    }

    public boolean isPrintFolder() {
        return this.printFolder;
    }

    public void setPrintFolder(boolean printFolder) {
        this.printFolder = printFolder;
    }

    public boolean isHasNoMilestones() {
        return StringUtils.isBlank((CharSequence)this.milestoneNames);
    }

    public boolean isAtLibraryRoot() {
        return this.level == 0L;
    }

    public boolean isHasNoSteps() {
        return this.tcSteps.isEmpty();
    }

    public boolean isNoPrintChain() {
        return this.level == 0L || !this.printChain;
    }

    public boolean isStandard() {
        return "STANDARD".equals(this.kind);
    }

    public boolean isScripted() {
        return "SCRIPTED".equals(this.kind);
    }

    public boolean isKeyword() {
        return "KEYWORD".equals(this.kind);
    }

    public boolean isNoAllowAutomationWorkflow() {
        return this.allowAutomationWorkflow == 0L;
    }

    public boolean isNoEligible() {
        return !"Y".equals(this.automatable);
    }

    public boolean isPrintAttachment() {
        return this.attachments > 0L;
    }

    public boolean isHasTcSteps() {
        return this.tcSteps.size() > 0;
    }

    public boolean isHasParameters() {
        return this.parameters.size() > 0;
    }

    public boolean isHasDataset() {
        return this.datasets.size() > 0;
    }

    public boolean isHasLinkedReq() {
        if (this.linkedRequirements == null) {
            return false;
        }
        return this.linkedRequirements.size() > 0;
    }

    public boolean isScriptEmpty() {
        return this.script.isEmpty();
    }

    public String getParagraph() {
        return this.paragraph;
    }

    public void setParagraph(List<Integer> paragraphLevel) {
        this.paragraph = "";
        if (paragraphLevel != null && paragraphLevel.size() > 0) {
            Iterator<Integer> itr = paragraphLevel.iterator();
            String delimiter = "";
            while (itr.hasNext()) {
                this.paragraph = this.paragraph + delimiter + String.valueOf(itr.next());
                delimiter = ".";
            }
        }
    }

    public String getImportance() {
        return I18nHelper.translate(switch (this.importance) {
            case "LOW" -> "report.books.testcases.importance.low";
            case "MEDIUM" -> "report.books.testcases.importance.medium";
            case "HIGH" -> "report.books.testcases.importance.high";
            case "VERY_HIGH" -> "report.books.testcases.importance.veryhigh";
            default -> "report.books.testcases.importance.undefined";
        });
    }

    public void setImportance(String importance) {
        this.importance = importance;
    }

    public String getNature() {
        if (this.natureType.equals("SYS")) {
            return I18nHelper.translate("report.books.testcases." + this.nature.toLowerCase());
        }
        return this.nature;
    }

    public void setNature(String nature) {
        this.nature = nature;
    }

    public String getType() {
        if (this.typeType.equals("SYS")) {
            return I18nHelper.translate("report.books.testcases." + this.type.toLowerCase());
        }
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getStatus() {
        return I18nHelper.translate(switch (this.status) {
            case "TO_BE_UPDATED" -> "report.books.testcases.status.tobeupdated";
            case "UNDER_REVIEW" -> "report.books.testcases.status.underreview";
            case "APPROVED" -> "report.books.testcases.status.approved";
            case "OBSOLETE" -> "report.books.testcases.status.obsolete";
            default -> "report.books.testcases.status.workinprogress";
        });
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getAutomatable() {
        return I18nHelper.translate(switch (this.automatable) {
            case "Y" -> "report.books.testcases.automatable.Y";
            case "N" -> "report.books.testcases.automatable.N";
            default -> "report.books.testcases.automatable.M";
        });
    }

    public void setAutomatable(String automatable) {
        this.automatable = automatable;
    }

    public String getRequestStatus() {
        return I18nHelper.translate(switch (this.requestStatus) {
            case "TRANSMITTED" -> "report.books.testcases.request-status.transmitted";
            case "AUTOMATION_IN_PROGRESS" -> "report.books.testcases.request-status.automation-in-progress";
            case "SUSPENDED" -> "report.books.testcases.request-status.suspended";
            case "REJECTED" -> "report.books.testcases.request-status.rejected";
            case "AUTOMATED" -> "report.books.testcases.request-status.automated";
            case "READY_TO_TRANSMIT" -> "report.books.testcases.request-status.ready-to-transmit";
            default -> "report.books.testcases.request-status.work-in-progress";
        });
    }

    public void setRequestStatus(String requestStatus) {
        this.requestStatus = requestStatus;
    }

    public String getChain() {
        return this.chain.replace(" > " + this.name, "");
    }

    public void setChain(String chain) {
        this.chain = chain;
    }

    public String getAttachments() {
        return String.valueOf(this.attachments);
    }

    public void setAttachments(Long attachments) {
        this.attachments = attachments;
    }

    public String getNatureType() {
        return this.natureType;
    }

    public void setNatureType(String natureType) {
        this.natureType = natureType;
    }

    public String getTypeType() {
        return this.typeType;
    }

    public void setTypeType(String typeType) {
        this.typeType = typeType;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Long getLevel() {
        return this.level;
    }

    public void setLevel(Long level) {
        this.level = level;
    }

    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public String getAutomationPriority() {
        return this.automationPriority;
    }

    public void setAutomationPriority(String automationPriority) {
        this.automationPriority = automationPriority;
    }

    public Long getAllowAutomationWorkflow() {
        return this.allowAutomationWorkflow;
    }

    public void setAllowAutomationWorkflow(Long allowAutomationWorkflow) {
        this.allowAutomationWorkflow = allowAutomationWorkflow;
    }

    public void setExecutionMode(Long executionMode) {
        this.executionMode = executionMode;
    }

    public Long getExecutionMode() {
        return this.executionMode;
    }

    public Long getFolder() {
        return this.folder;
    }

    public void setFolder(Long folder) {
        this.folder = folder;
    }

    public String getChainDescription() {
        return this.chainDescription;
    }

    public void setChainDescription(String chainDescription) {
        this.chainDescription = chainDescription;
    }

    public void setPrerequisites(String prerequisites) {
        this.prerequisites = prerequisites;
    }

    public String getPrerequisites() {
        return this.prerequisites;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedOn(String createdOn) {
        this.createdOn = createdOn;
    }

    public String getCreatedOn() {
        return this.createdOn;
    }

    public void setLastModifiedBy(String lastModifiedBy) {
        this.lastModifiedBy = lastModifiedBy;
    }

    public String getLastModifiedBy() {
        return this.lastModifiedBy;
    }

    public void setLastModifiedOn(String lastModifiedOn) {
        this.lastModifiedOn = lastModifiedOn;
    }

    public String getLastModifiedOn() {
        return this.lastModifiedOn;
    }

    public void setTcSteps(List<TestCaseSteps> tcStepsBeans) {
        this.tcSteps = tcStepsBeans;
    }

    public List<TestCaseSteps> getTcSteps() {
        return this.tcSteps;
    }

    public List<LinkedRequirements> getLinkedRequirements() {
        return this.linkedRequirements;
    }

    public void setLinkedRequirements(List<LinkedRequirements> linkedRequirements) {
        this.linkedRequirements = linkedRequirements;
    }

    public String getSortingChain() {
        return this.sortingChain;
    }

    public void setSortingChain(String sortingChain) {
        this.sortingChain = sortingChain;
    }

    public String getMilestoneNames() {
        return this.milestoneNames;
    }

    public void setMilestoneNames(String milestoneLabels) {
        this.milestoneNames = milestoneLabels;
    }

    public boolean isPrintChain() {
        return this.printChain;
    }

    public void setPrintChain(boolean printChain) {
        this.printChain = printChain;
    }

    public List<Long> getNodeIds() {
        return this.nodeIds;
    }

    public void setNodeIds(List<Long> nodeIds) {
        this.nodeIds = nodeIds;
    }

    public String getScript() {
        return this.script;
    }

    public void setScript(String script) {
        this.script = script;
    }

    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<Parameter> parameters) {
        this.parameters = parameters;
    }

    public List<Dataset> getDatasets() {
        return this.datasets;
    }

    public void setDatasets(List<Dataset> datasets) {
        this.datasets = datasets;
    }

    public boolean isPrintParameters() {
        return this.printParameters;
    }

    public void setPrintParameters(boolean printParameters) {
        this.printParameters = printParameters;
    }

    public boolean isPrintLinkedReq() {
        return this.printLinkedReq;
    }

    public void setPrintLinkedReq(boolean printLinkedReq) {
        this.printLinkedReq = printLinkedReq;
    }

    public List<PrintableCuf> getPrintableCufs() {
        return this.printableCufs;
    }

    public void setPrintableCufs(List<PrintableCuf> printableCufs) {
        this.printableCufs = printableCufs;
    }

    public boolean isPrintSteps() {
        return this.printSteps;
    }

    public void setPrintSteps(boolean printSteps) {
        this.printSteps = printSteps;
    }

    public boolean isPrintMilestones() {
        return this.printMilestones;
    }

    public void setPrintMilestones(boolean printMilestones) {
        this.printMilestones = printMilestones;
    }
}

