/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.bugzilla.internal.xmlrcp.client;

import bugzilla.org.apache.xmlrpc.XmlRpcException;
import bugzilla.org.apache.xmlrpc.client.XmlRpcClient;
import bugzilla.org.apache.xmlrpc.client.XmlRpcClientConfigImpl;
import bugzilla.org.apache.xmlrpc.client.XmlRpcLiteHttpTransportFactory;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.squashtest.tm.plugin.bugtracker.bugzilla.internal.exception.BugzillaProjectNotFoundException;
import org.squashtest.tm.plugin.bugtracker.bugzilla.internal.xmlrcp.client.domain.Bug;
import org.squashtest.tm.plugin.bugtracker.bugzilla.internal.xmlrcp.client.domain.BugzillaField;
import org.squashtest.tm.plugin.bugtracker.bugzilla.internal.xmlrcp.client.domain.Product;
import org.squashtest.tm.plugin.bugtracker.bugzilla.internal.xmlrcp.client.domain.User;
import org.squashtest.tm.plugin.bugtracker.bugzilla.internal.xmlrcp.client.exception.BugzillaXmlrpcException;
import org.squashtest.tm.plugin.bugtracker.bugzilla.internal.xmlrcp.client.exception.ExceptionHandler;
import org.squashtest.tm.plugin.bugtracker.bugzilla.internal.xmlrcp.client.service.CacheService;
import org.squashtest.tm.plugin.bugtracker.bugzilla.internal.xmlrcp.client.service.CacheServiceFactory;
import org.squashtest.tm.plugin.bugtracker.bugzilla.internal.xmlrcp.client.service.FieldService;

public class BugzillaXmlrcpClient {
    private static final String NAME = "name";
    private static final String IDS = "ids";
    private static final Object ID = "id";
    private static final Object VERSION = "version";
    private static final String INCLUDE_FIELDS = "include_fields";
    private static final String GET_BUG = "Bug.get";
    private static final String GET_COMMENTS = "Bug.comments";
    private static final String CREATE_BUG = "Bug.create";
    private static final String FIND_USERS = "User.get";
    private static final String ADD_ATTACHMENT = "Bug.add_attachment";
    private static final String GET_ACCESSIBLE_PRODUCT = "Product.get_accessible_products";
    private static final String GET_PRODUCT = "Product.get";
    private static final String BUGZILLA_VERSION = "Bugzilla.version";
    private static final String XMLRPC = "xmlrpc.cgi";
    private static final String FILE_DATA = "data";
    private static final String FILE_NAME = "file_name";
    private static final String FILE_SUMMARY = "summary";
    private static final String FILE_CONTENT_TYPE = "content_type";
    private static final String DEFAULT_FILE_CONTENT_TYPE = "application/file";
    private static final String LOGIN = "Bugzilla_login";
    private static final String PASSWORD = "Bugzilla_password";
    private String login;
    private String password;
    private final XmlRpcClient client;
    private final CacheService cacheService;
    private final FieldService fieldService;
    private final String bugTrackerUrl;

    public BugzillaXmlrcpClient(boolean globalCacheEnabled, String serverURL) throws MalformedURLException {
        this.client = this.getClient(serverURL);
        this.cacheService = new CacheServiceFactory(globalCacheEnabled, serverURL).getCacheService();
        this.fieldService = new FieldService(this.cacheService, this);
        this.bugTrackerUrl = serverURL;
    }

    public List<String> getPriority() throws BugzillaXmlrpcException {
        return this.getListOfPossibleValues("priority");
    }

    public List<String> getComponent() throws BugzillaXmlrpcException {
        return this.getListOfPossibleValues("component");
    }

    public List<String> getVersion() throws BugzillaXmlrpcException {
        return this.getListOfPossibleValues("version");
    }

    public List<String> getSeverity() throws BugzillaXmlrpcException {
        return this.getListOfPossibleValues("severity");
    }

    public List<String> getOS() throws BugzillaXmlrpcException {
        return this.getListOfPossibleValues("op_sys");
    }

    public List<String> getStatus() throws BugzillaXmlrpcException {
        return this.getListOfPossibleValues("status");
    }

    public List<String> getHardware() throws BugzillaXmlrpcException {
        return this.getListOfPossibleValues("platform");
    }

    public List<BugzillaField> getCustomFields() throws BugzillaXmlrpcException {
        return this.cacheService.getCustomFields().stream().map(this.fieldService::createFieldWithPossibleValues).collect(Collectors.toList());
    }

    public void login(String username, String password) {
        this.login = username;
        this.password = password;
    }

    public Bug getBug(String id) throws BugzillaXmlrpcException {
        return this.executeGetBug(id).get(0);
    }

    public List<Bug> getBugs(List<String> ids) throws BugzillaXmlrpcException {
        return this.executeGetBug(ids);
    }

    public Bug createBug(Bug bug) throws BugzillaXmlrpcException {
        HashMap<String, Object> executionData = new HashMap<String, Object>();
        this.addIfNotNull(executionData, "product", bug.getProduct().getName());
        this.addIfNotNull(executionData, "component", bug.getComponent());
        this.addIfNotNull(executionData, FILE_SUMMARY, bug.getSummary());
        this.addIfNotNull(executionData, "version", bug.getVersion());
        this.addIfNotNull(executionData, "description", bug.getDescription());
        this.addIfNotNull(executionData, "severity", bug.getSeverity());
        this.addIfNotNull(executionData, "assigned_to", bug.getAssignee());
        this.addIfNotNull(executionData, "platform", bug.getHardware());
        this.addIfNotNull(executionData, "target_milestone", bug.getMilestone());
        this.addIfNotNull(executionData, "op_sys", bug.getOs());
        this.addIfNotNull(executionData, "priority", bug.getPriority());
        this.fieldService.addCustomFieldForBugCreation(executionData, bug);
        Map<?, ?> result = this.executeCommand(CREATE_BUG, executionData);
        Object idParam = result.get(ID);
        bug.setId((Integer)idParam);
        return bug;
    }

    private void addIfNotNull(Map<String, Object> executionData, String key, Object value) {
        if (value != null) {
            executionData.put(key, value);
        }
    }

    public List<User> getUsers() throws BugzillaXmlrpcException {
        HashMap<String, Object> executionData = new HashMap<String, Object>();
        executionData.put("match", new Object[]{"*"});
        executionData.put("include_disabled", true);
        return this.createUserList(this.executeCommand(FIND_USERS, executionData));
    }

    public void addAttachment(String bugId, String fileName, byte[] data) throws BugzillaXmlrpcException {
        HashMap<String, Object> executionData = new HashMap<String, Object>();
        executionData.put(IDS, bugId);
        executionData.put(FILE_DATA, data);
        executionData.put(FILE_NAME, fileName);
        executionData.put(FILE_SUMMARY, fileName);
        executionData.put(FILE_CONTENT_TYPE, DEFAULT_FILE_CONTENT_TYPE);
        this.executeCommand(ADD_ATTACHMENT, executionData);
    }

    public Product getProductById(int id) throws BugzillaXmlrpcException {
        return this.getProduct(IDS, id);
    }

    public Product getProductByName(String name) throws BugzillaXmlrpcException {
        return this.getProduct("names", name);
    }

    private Product getProduct(String searchType, Object searchParam) throws BugzillaXmlrpcException {
        HashMap<String, Object> executionData = new HashMap<String, Object>();
        executionData.put(searchType, searchParam);
        executionData.put(INCLUDE_FIELDS, Product.getIncludeFieldsInGetProductCommand());
        Map<?, ?> result = this.executeCommand(GET_PRODUCT, executionData);
        Object[] products = (Object[])result.get("products");
        if (products.length == 0) {
            throw new BugzillaProjectNotFoundException(searchParam.toString());
        }
        Map product = (Map)products[0];
        return this.fieldService.createProductFromProductMap(product);
    }

    public List<Product> getAllProducts() throws BugzillaXmlrpcException {
        HashMap<String, Object> executionData = new HashMap<String, Object>();
        executionData.put(IDS, this.getAccessibleProductIds());
        Map<?, ?> result = this.executeCommand(GET_PRODUCT, executionData);
        Object[] products = (Object[])result.get("products");
        ArrayList<Product> listeProduct = new ArrayList<Product>();
        Object[] objectArray = products;
        int n = products.length;
        int n2 = 0;
        while (n2 < n) {
            Object product = objectArray[n2];
            listeProduct.add(this.fieldService.createProductFromProductMap((Map)product));
            ++n2;
        }
        return listeProduct;
    }

    public String getBugzillaVersion() {
        Map<?, ?> result = this.executeCommand(BUGZILLA_VERSION, new HashMap<String, Object>());
        return (String)result.get(VERSION);
    }

    private List<Integer> getAccessibleProductIds() throws BugzillaXmlrpcException {
        ArrayList<Integer> listeIds = new ArrayList<Integer>();
        Map<?, ?> result = this.executeCommand(GET_ACCESSIBLE_PRODUCT, new HashMap<String, Object>());
        Object[] objectArray = (Object[])result.get(IDS);
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            listeIds.add((Integer)o);
            ++n2;
        }
        return listeIds;
    }

    private List<User> createUserList(Map<?, ?> result) {
        Object[] users;
        ArrayList<User> listeUser = new ArrayList<User>();
        Object[] objectArray = users = (Object[])result.get("users");
        int n = users.length;
        int n2 = 0;
        while (n2 < n) {
            Object user = objectArray[n2];
            listeUser.add(this.createUserFromObject(user));
            ++n2;
        }
        return listeUser;
    }

    private User createUserFromObject(Object o) {
        Map map = (Map)o;
        User user = new User();
        user.setName((String)map.get(NAME));
        user.setRealName((String)map.get("real_name"));
        return user;
    }

    private List<String> getListOfPossibleValues(String fieldName) throws BugzillaXmlrpcException {
        List<Map<String, Object>> allFields = this.cacheService.getAllFields();
        List<Map<String, Object>> fieldPossibleValues = this.fieldService.getPossibleValuesOfField(allFields, fieldName);
        return fieldPossibleValues.stream().map(value -> value.get(NAME).toString()).collect(Collectors.toList());
    }

    private List<Bug> executeGetBug(Object issueIds) throws BugzillaXmlrpcException {
        HashMap<String, Object> executionData = new HashMap<String, Object>();
        executionData.put(IDS, issueIds);
        executionData.put(INCLUDE_FIELDS, Bug.getIncludeFieldsInGetBugCommand());
        Map<?, ?> result = this.executeCommand(GET_BUG, executionData);
        Map<String, String> bugIdToDescriptionMap = this.getBugDescriptions(issueIds);
        return Arrays.stream((Object[])result.get("bugs")).map(rawBug -> {
            Bug bug = this.getBugFromObject(rawBug);
            bug.setDescription((String)bugIdToDescriptionMap.get(bug.getId().toString()));
            return bug;
        }).collect(Collectors.toList());
    }

    private Bug getBugFromObject(Object o) throws BugzillaXmlrpcException {
        Bug bug = new Bug();
        Map map = (Map)o;
        Integer bugId = (Integer)map.get("id");
        bug.setAssignee((String)map.get("assigned_to"));
        bug.setComponent((String)map.get("component"));
        bug.setHardware((String)map.get("platform"));
        bug.setId(bugId);
        bug.setOs((String)map.get("op_sys"));
        bug.setPriority((String)map.get("priority"));
        Product product = new Product();
        product.setId(-1);
        product.setName((String)map.get("product"));
        bug.setProduct(product);
        bug.setReporter((String)map.get("creator"));
        bug.setSeverity((String)map.get("severity"));
        bug.setStatus((String)map.get("status"));
        bug.setSummary((String)map.get(FILE_SUMMARY));
        bug.setMilestone((String)map.get("target_milestone"));
        bug.setVersion((String)map.get("version"));
        return bug;
    }

    private Map<String, String> getBugDescriptions(Object issueIds) throws BugzillaXmlrpcException {
        HashMap<String, Object> executionData = new HashMap<String, Object>();
        executionData.put(IDS, issueIds);
        executionData.put(INCLUDE_FIELDS, Bug.getIncludeFieldsInGetBugCommentCommand());
        Map<?, ?> result = this.executeCommand(GET_COMMENTS, executionData);
        Map bugs = (Map)result.get("bugs");
        HashMap<String, String> bugIdToDescriptionMap = new HashMap<String, String>();
        for (Map.Entry entry : bugs.entrySet()) {
            Map bug = (Map)entry.getValue();
            Object[] comments = (Object[])bug.get("comments");
            Map firstComment = (Map)comments[0];
            String description = (String)firstComment.get("text");
            bugIdToDescriptionMap.put((String)entry.getKey(), description);
        }
        return bugIdToDescriptionMap;
    }

    private Map<?, ?> executeCommand(String command, Map<String, Object> executionData) throws BugzillaXmlrpcException {
        try {
            executionData.put(LOGIN, this.login);
            executionData.put(PASSWORD, this.password);
            List<Map<String, Object>> params = Collections.singletonList(executionData);
            return (Map)this.client.execute(command, params);
        }
        catch (XmlRpcException e) {
            throw ExceptionHandler.handleExeption(e);
        }
    }

    private XmlRpcClient getClient(String serverURL) throws MalformedURLException {
        XmlRpcClient rpcClient = new XmlRpcClient();
        String apiURL = serverURL + this.trailingSlash(serverURL) + XMLRPC;
        XmlRpcClientConfigImpl config = new XmlRpcClientConfigImpl();
        config.setServerURL(new URL(apiURL));
        config.setEnabledForExtensions(true);
        rpcClient.setConfig(config);
        rpcClient.setTransportFactory(this.getTransportFactory(rpcClient));
        return rpcClient;
    }

    private String trailingSlash(String serverURL) {
        return serverURL.endsWith("/") ? "" : "/";
    }

    private XmlRpcLiteHttpTransportFactory getTransportFactory(XmlRpcClient rpcClient) {
        return new XmlRpcLiteHttpTransportFactory(rpcClient);
    }

    public String getBugTrackerUrl() {
        return this.bugTrackerUrl;
    }
}

