/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.bugzilla.internal.operations;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import org.apache.commons.io.IOUtils;
import org.squashtest.tm.bugtracker.definition.Attachment;
import org.squashtest.tm.plugin.bugtracker.bugzilla.internal.exception.BugzillaUploadFailed;
import org.squashtest.tm.plugin.bugtracker.bugzilla.internal.operations.BugzillaClientOperation;
import org.squashtest.tm.plugin.bugtracker.bugzilla.internal.xmlrcp.client.BugzillaXmlrcpClient;
import org.squashtest.tm.plugin.bugtracker.bugzilla.internal.xmlrcp.client.exception.BugzillaXmlrpcException;

public class ForwardAttachments
extends BugzillaClientOperation<Void> {
    private final String issueKey;
    private final Collection<Attachment> inputAttachments;

    public ForwardAttachments(BugzillaXmlrcpClient manager, String issueKey, Collection<Attachment> inputAttachments) {
        super(manager);
        this.inputAttachments = inputAttachments;
        this.issueKey = issueKey;
    }

    @Override
    public Void doIt() throws BugzillaXmlrpcException {
        for (Attachment attach : this.inputAttachments) {
            try {
                this.manager.addAttachment(this.issueKey, attach.getName(), IOUtils.toByteArray((InputStream)attach.getStreamContent()));
            }
            catch (IOException e) {
                throw new BugzillaUploadFailed(attach.getName(), e);
            }
        }
        return null;
    }
}

