/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.xsquash4gitlab.graphql.client;

import java.util.HashMap;
import java.util.Map;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.client.GitLabClient;

public class GitLabClientPool {
    private static final Logger LOGGER = LoggerFactory.getLogger(GitLabClientPool.class);
    private final Map<Long, GitLabClient> clients = new HashMap<Long, GitLabClient>();

    public GitLabClient getClient(Long bugtrackerId, String url, String token) {
        if (this.clients.containsKey(bugtrackerId)) {
            return this.getExistingClientOrMarkObsolete(bugtrackerId, url, token);
        }
        return this.createClient(bugtrackerId, url, token);
    }

    private GitLabClient createClient(Long bugtrackerId, String url, String token) {
        GitLabClient newClient = new GitLabClient(url, token);
        this.clients.put(bugtrackerId, newClient);
        return newClient;
    }

    private GitLabClient getExistingClientOrMarkObsolete(Long bugtrackerId, String url, String token) {
        GitLabClient existingClient = this.clients.get(bugtrackerId);
        if (existingClient.getUrl().equals(url) && existingClient.getToken().equals(token)) {
            return existingClient;
        }
        existingClient.setObsolete(true);
        LOGGER.info("GitLab client for bugtracker {} is obsolete, creating a new one.", new Object[]{bugtrackerId});
        return this.createClient(bugtrackerId, url, token);
    }
}

