/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.xsquash4gitlab.domain;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.BuiltinSquashField;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.GitLabField;

public class FieldMapping {
    private static final List<FieldMapping> BUILTIN_MAPPING = new ArrayList<FieldMapping>();
    private String squashField;
    private String gitLabField;
    private boolean locked;
    private boolean allowEdit;

    static {
        BUILTIN_MAPPING.add(new FieldMapping(BuiltinSquashField.LABEL, GitLabField.TITLE.rawValue, true, false));
        BUILTIN_MAPPING.add(new FieldMapping(BuiltinSquashField.REFERENCE, GitLabField.REFERENCE.rawValue, true, false));
        BUILTIN_MAPPING.add(new FieldMapping(BuiltinSquashField.DESCRIPTION, GitLabField.DESCRIPTION.rawValue, true, false));
        BUILTIN_MAPPING.add(new FieldMapping(BuiltinSquashField.CRITICALITY, GitLabField.LABELS.rawValue, false, false));
        BUILTIN_MAPPING.add(new FieldMapping(BuiltinSquashField.CATEGORY, GitLabField.LABELS.rawValue, false, false));
        BUILTIN_MAPPING.add(new FieldMapping(BuiltinSquashField.STATUS, GitLabField.LABELS.rawValue, false, false));
    }

    public FieldMapping() {
    }

    public FieldMapping(BuiltinSquashField squashField, String gitLabField, boolean locked, boolean allowEdit) {
        this(squashField.toString(), gitLabField, locked, allowEdit);
    }

    public FieldMapping(String squashFieldId, String gitLabField, boolean locked, boolean allowEdit) {
        this.squashField = squashFieldId;
        this.gitLabField = gitLabField;
        this.locked = locked;
        this.allowEdit = allowEdit;
    }

    public static Optional<String> getBuiltinMappingGitLabField(String id) {
        return BUILTIN_MAPPING.stream().filter(fieldMapping -> fieldMapping.getId().equals(id)).findFirst().map(FieldMapping::getGitLabField);
    }

    public static List<FieldMapping> getBuiltinMapping() {
        return BUILTIN_MAPPING;
    }

    public String getId() {
        return this.getSquashField();
    }

    public String getSquashField() {
        return this.squashField;
    }

    public void setSquashField(String squashField) {
        this.squashField = StringUtils.trim((String)squashField);
    }

    public String getGitLabField() {
        return this.gitLabField;
    }

    public void setGitLabField(String gitLabField) {
        this.gitLabField = gitLabField;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    public boolean isAllowEdit() {
        return this.allowEdit;
    }

    public void setAllowEdit(boolean allowEdit) {
        this.allowEdit = allowEdit;
    }

    public static List<FieldMapping> getLockedBuiltinMapping() {
        return BUILTIN_MAPPING.stream().filter(FieldMapping::isLocked).collect(Collectors.toList());
    }
}

