/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.gitlab.caching;

import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.springframework.stereotype.Service;
import org.squashtest.tm.domain.bugtracker.BugTracker;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.jooq.domain.tables.BugtrackerProject;

@Service
public class ValueCacheDao {
    private final DSLContext dslContext;
    @PersistenceContext
    private EntityManager em;

    public ValueCacheDao(DSLContext dslContext) {
        this.dslContext = dslContext;
    }

    public List<BugTracker> getAllGitLabBugTrackers() {
        return this.em.createQuery("SELECT b FROM BugTracker b WHERE b.kind = :kind", BugTracker.class).setParameter("kind", (Object)"gitlab.bugtracker").getResultList();
    }

    public Map<Long, List<String>> getProjectPathsByBugTrackerId() {
        Map projectPathsByBugTrackerId = this.dslContext.select((SelectField)Tables.PROJECT.BUGTRACKER_ID, (SelectField)BugtrackerProject.BUGTRACKER_PROJECT.BUGTRACKER_PROJECT_NAME).from((TableLike)Tables.BUGTRACKER).join((TableLike)Tables.PROJECT).on(Tables.BUGTRACKER.BUGTRACKER_ID.eq((Field)Tables.PROJECT.BUGTRACKER_ID)).join((TableLike)BugtrackerProject.BUGTRACKER_PROJECT).on(Tables.PROJECT.PROJECT_ID.eq((Field)BugtrackerProject.BUGTRACKER_PROJECT.PROJECT_ID)).where(Tables.BUGTRACKER.KIND.eq((Object)"gitlab.bugtracker")).fetch().intoGroups((Field)Tables.PROJECT.BUGTRACKER_ID, (Field)BugtrackerProject.BUGTRACKER_PROJECT.BUGTRACKER_PROJECT_NAME);
        projectPathsByBugTrackerId.replaceAll((bugTrackerId, projectPaths) -> new ArrayList(new LinkedHashSet(projectPaths)));
        return projectPathsByBugTrackerId;
    }

    public Set<String> getGitLabProjectPathsByTmProjectId(long projectId) {
        return this.dslContext.select((SelectField)BugtrackerProject.BUGTRACKER_PROJECT.BUGTRACKER_PROJECT_NAME).from((TableLike)BugtrackerProject.BUGTRACKER_PROJECT).join((TableLike)Tables.PROJECT).on(BugtrackerProject.BUGTRACKER_PROJECT.PROJECT_ID.eq((Field)Tables.PROJECT.PROJECT_ID)).where(Tables.PROJECT.PROJECT_ID.eq((Object)projectId)).fetchSet((Field)BugtrackerProject.BUGTRACKER_PROJECT.BUGTRACKER_PROJECT_NAME);
    }

    public Set<String> getGitLabProjectPathsByBugTrackerId(long bugTrackerId) {
        return this.dslContext.select((SelectField)BugtrackerProject.BUGTRACKER_PROJECT.BUGTRACKER_PROJECT_NAME).from((TableLike)Tables.BUGTRACKER).join((TableLike)Tables.PROJECT).on(Tables.BUGTRACKER.BUGTRACKER_ID.eq((Field)Tables.PROJECT.BUGTRACKER_ID)).join((TableLike)BugtrackerProject.BUGTRACKER_PROJECT).on(Tables.PROJECT.PROJECT_ID.eq((Field)BugtrackerProject.BUGTRACKER_PROJECT.PROJECT_ID)).where(Tables.BUGTRACKER.BUGTRACKER_ID.eq((Object)bugTrackerId)).fetchSet((Field)BugtrackerProject.BUGTRACKER_PROJECT.BUGTRACKER_PROJECT_NAME);
    }
}

