/*
 * Decompiled with CFR 0.152.
 */
package plugin.rtc.org.apache.wink.common.model.synd;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import plugin.rtc.org.apache.wink.common.model.synd.SyndCategory;
import plugin.rtc.org.apache.wink.common.model.synd.SyndCommonAttributes;
import plugin.rtc.org.apache.wink.common.model.synd.SyndLink;
import plugin.rtc.org.apache.wink.common.model.synd.SyndPerson;
import plugin.rtc.org.apache.wink.common.model.synd.SyndText;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SyndBase
extends SyndCommonAttributes {
    private String id;
    private SyndText title;
    private Date updated;
    private List<SyndLink> links;
    private List<SyndPerson> authors;
    private List<SyndCategory> categories;

    public SyndBase() {
    }

    public SyndBase(String id, SyndText title, Date updated) {
        this.id = id;
        this.title = title;
        this.updated = updated;
    }

    public SyndBase(SyndBase other) {
        super(other);
        this.title = new SyndText(other.title);
        this.updated = other.updated != null ? new Date(other.updated.getTime()) : null;
        this.copyLinks(other.links);
        this.copyAuthors(other.authors);
        this.copyCategories(other.categories);
    }

    private void copyCategories(List<SyndCategory> categories) {
        this.categories = new ArrayList<SyndCategory>();
        for (SyndCategory value : categories) {
            this.categories.add(new SyndCategory(value));
        }
    }

    private void copyAuthors(List<SyndPerson> authors) {
        this.authors = new ArrayList<SyndPerson>();
        for (SyndPerson value : authors) {
            this.authors.add(new SyndPerson(value));
        }
    }

    private void copyLinks(List<SyndLink> links) {
        this.links = new ArrayList<SyndLink>();
        for (SyndLink value : links) {
            this.links.add(new SyndLink(value));
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void addLink(SyndLink link) {
        this.getLinks().add(link);
    }

    public List<SyndLink> getLinks() {
        if (this.links == null) {
            this.links = new ArrayList<SyndLink>();
        }
        return this.links;
    }

    public SyndLink getLink(String rel) {
        for (SyndLink link : this.getLinks()) {
            if (!link.getRel().equalsIgnoreCase(rel)) continue;
            return link;
        }
        return null;
    }

    public void addAuthor(SyndPerson author) {
        this.getAuthors().add(author);
    }

    public List<SyndPerson> getAuthors() {
        if (this.authors == null) {
            this.authors = new ArrayList<SyndPerson>();
        }
        return this.authors;
    }

    public void addCategory(SyndCategory category) {
        this.getCategories().add(category);
    }

    public List<SyndCategory> getCategories() {
        if (this.categories == null) {
            this.categories = new ArrayList<SyndCategory>();
        }
        return this.categories;
    }

    public SyndText getTitle() {
        return this.title;
    }

    public void setTitle(SyndText title) {
        this.title = title;
    }

    public Date getUpdated() {
        return this.updated;
    }

    public void setUpdated(Date updated) {
        this.updated = updated;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.authors == null ? 0 : ((Object)this.authors).hashCode());
        result = 31 * result + (this.categories == null ? 0 : ((Object)this.categories).hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.links == null ? 0 : ((Object)this.links).hashCode());
        result = 31 * result + (this.title == null ? 0 : this.title.hashCode());
        result = 31 * result + (this.updated == null ? 0 : this.updated.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SyndBase other = (SyndBase)obj;
        if (this.authors == null ? other.authors != null : !((Object)this.authors).equals(other.authors)) {
            return false;
        }
        if (this.categories == null ? other.categories != null : !((Object)this.categories).equals(other.categories)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.links == null ? other.links != null : !((Object)this.links).equals(other.links)) {
            return false;
        }
        if (this.title == null ? other.title != null : !this.title.equals(other.title)) {
            return false;
        }
        return !(this.updated == null ? other.updated != null : !this.updated.equals(other.updated));
    }
}

