/*
 * Decompiled with CFR 0.152.
 */
package plugin.rtc.org.apache.wink.common.internal.registry.metadata;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Member;
import java.lang.reflect.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import plugin.rtc.javax.ws.rs.core.Application;
import plugin.rtc.org.apache.wink.common.internal.registry.Injectable;
import plugin.rtc.org.apache.wink.common.internal.registry.InjectableFactory;
import plugin.rtc.org.apache.wink.common.internal.registry.metadata.AbstractMetadataCollector;
import plugin.rtc.org.apache.wink.common.internal.registry.metadata.ClassMetadata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationMetadataCollector
extends AbstractMetadataCollector {
    private static final Logger logger = LoggerFactory.getLogger(ApplicationMetadataCollector.class);

    private ApplicationMetadataCollector(Class<?> clazz) {
        super(clazz);
    }

    public static ClassMetadata collectMetadata(Class<?> clazz) {
        logger.trace("collectMetadata({})", clazz);
        ApplicationMetadataCollector collector = new ApplicationMetadataCollector(clazz);
        collector.parseFields();
        collector.parseConstructors();
        ClassMetadata md = collector.getMetadata();
        logger.trace("collectMetadata() exit returning {}", (Object)md);
        return md;
    }

    @Override
    protected final Injectable parseAccessibleObject(AccessibleObject field, Type fieldType) {
        logger.trace("parseAccessibleObject({}, {})", (Object)field, (Object)fieldType);
        Injectable injectable = InjectableFactory.getInstance().create(fieldType, field.getAnnotations(), (Member)((Object)field), this.getMetadata().isEncoded(), null);
        logger.trace("Injectable is {}", (Object)injectable);
        if (injectable.getParamType() == Injectable.ParamType.ENTITY) {
            logger.trace("parseAccessibleObject() returning null");
            return null;
        }
        logger.trace("parseAccessibleObject() returning {}", (Object)injectable);
        return injectable;
    }

    @Override
    protected final boolean isConstructorParameterValid(Injectable fp) {
        boolean ret;
        logger.trace("isConstructorParameterValid({}) entry", (Object)fp);
        boolean bl = ret = fp.getParamType() != Injectable.ParamType.ENTITY;
        if (logger.isTraceEnabled()) {
            logger.trace("isConstructorParameterValid() exit returning {}", (Object)ret);
        }
        return ret;
    }

    public static boolean isApplication(Class cls) {
        logger.trace("isApplication({}) entry", (Object)cls);
        boolean ret = Application.class.isAssignableFrom(cls);
        logger.trace("isApplication() exit returning {}", (Object)ret);
        return ret;
    }
}

