/*
 * Decompiled with CFR 0.152.
 */
package plugin.rtc.org.apache.wink.common.internal.providers.entity.csv;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import plugin.rtc.javax.ws.rs.Produces;
import plugin.rtc.javax.ws.rs.WebApplicationException;
import plugin.rtc.javax.ws.rs.core.Context;
import plugin.rtc.javax.ws.rs.core.MediaType;
import plugin.rtc.javax.ws.rs.core.MultivaluedMap;
import plugin.rtc.javax.ws.rs.ext.MessageBodyWriter;
import plugin.rtc.javax.ws.rs.ext.Provider;
import plugin.rtc.javax.ws.rs.ext.Providers;
import plugin.rtc.org.apache.wink.common.model.csv.CsvSerializer;
import plugin.rtc.org.apache.wink.common.model.synd.SyndCategory;
import plugin.rtc.org.apache.wink.common.model.synd.SyndEntry;
import plugin.rtc.org.apache.wink.common.model.synd.SyndFeed;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Provider
@Produces(value={"text/csv"})
public class CsvSyndFeedSerializerProvider
implements MessageBodyWriter<SyndFeed> {
    private static final String[] EMPTY_ARRAY = new String[0];
    @Context
    private Providers providers;

    @Override
    public long getSize(SyndFeed t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    @Override
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        MessageBodyWriter<SyndFeedSerializer> messageBodyWriter = this.providers.getMessageBodyWriter(SyndFeedSerializer.class, genericType, annotations, mediaType);
        return SyndFeed.class.isAssignableFrom(type) && messageBodyWriter != null;
    }

    @Override
    public void writeTo(SyndFeed t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        MessageBodyWriter<SyndFeedSerializer> messageBodyWriter = this.providers.getMessageBodyWriter(SyndFeedSerializer.class, genericType, annotations, mediaType);
        messageBodyWriter.writeTo(new SyndFeedSerializer(t), type, genericType, annotations, mediaType, httpHeaders, entityStream);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SyndFeedSerializer
    implements Iterator<String[]>,
    CsvSerializer {
        private TreeSet<String> categoriesNames;
        private Iterator<SyndEntry> iterator;
        private List<String> header;
        private boolean headerSent = false;

        public SyndFeedSerializer(SyndFeed syndFeed) {
            List<SyndEntry> entries = syndFeed.getEntries();
            this.iterator = entries.iterator();
            this.categoriesNames = new TreeSet();
            for (SyndEntry entry : entries) {
                List<SyndCategory> categories = entry.getCategories();
                if (categories == null) continue;
                for (SyndCategory categoryBean : categories) {
                    this.categoriesNames.add(categoryBean.getScheme());
                }
            }
            this.header = new ArrayList<String>();
            this.header.add("id");
            this.header.add("title");
            this.header.add("content");
            this.header.add("authors");
            this.header.add("published");
            this.header.add("summary");
            this.header.add("updated");
            this.header.add("base");
            this.header.add("lang");
            for (String categoryName : this.categoriesNames) {
                this.header.add(categoryName);
            }
        }

        @Override
        public boolean hasNext() {
            return !this.headerSent || this.iterator.hasNext();
        }

        @Override
        public String[] next() {
            if (!this.headerSent) {
                this.headerSent = true;
                return this.header.toArray(EMPTY_ARRAY);
            }
            SyndEntry entry = this.iterator.next();
            String base = entry.getBase();
            String id = entry.getId();
            String lang = entry.getLang();
            String authors = entry.getAuthors() != null && !entry.getAuthors().isEmpty() ? entry.getAuthors().get(0).getName() : "";
            String title = entry.getTitle() != null ? entry.getTitle().getValue() : "";
            String content = entry.getContent() != null ? entry.getContent().getValue() : "";
            String published = entry.getPublished() != null ? String.valueOf(entry.getPublished()) : "";
            String updated = entry.getUpdated() != null ? String.valueOf(entry.getUpdated()) : "";
            String summary = entry.getSummary() != null ? entry.getSummary().getValue() : "";
            HashMap<String, String> categoriesMap = new HashMap<String, String>();
            List<SyndCategory> categories = entry.getCategories();
            if (categories != null) {
                for (SyndCategory bean : categories) {
                    categoriesMap.put(bean.getScheme(), bean.getTerm());
                }
            }
            String[] row = new String[this.header.size()];
            int index = 0;
            row[index++] = id;
            row[index++] = title;
            row[index++] = content;
            row[index++] = authors;
            row[index++] = published;
            row[index++] = summary;
            row[index++] = updated;
            row[index++] = base;
            row[index++] = lang;
            for (String categoryName : this.categoriesNames) {
                String category = (String)categoriesMap.get(categoryName);
                row[index++] = category != null ? category : "";
            }
            return row;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<String[]> getEntities() {
            return this;
        }
    }
}

