/*
 * Decompiled with CFR 0.152.
 */
package plugin.rtc.org.apache.http.impl.cookie;

import plugin.rtc.org.apache.http.annotation.Contract;
import plugin.rtc.org.apache.http.annotation.ThreadingBehavior;
import plugin.rtc.org.apache.http.cookie.ClientCookie;
import plugin.rtc.org.apache.http.cookie.CommonCookieAttributeHandler;
import plugin.rtc.org.apache.http.cookie.Cookie;
import plugin.rtc.org.apache.http.cookie.CookieOrigin;
import plugin.rtc.org.apache.http.cookie.CookieRestrictionViolationException;
import plugin.rtc.org.apache.http.cookie.MalformedCookieException;
import plugin.rtc.org.apache.http.cookie.SetCookie;
import plugin.rtc.org.apache.http.cookie.SetCookie2;
import plugin.rtc.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RFC2965VersionAttributeHandler
implements CommonCookieAttributeHandler {
    @Override
    public void parse(SetCookie cookie, String value) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        if (value == null) {
            throw new MalformedCookieException("Missing value for version attribute");
        }
        int version2 = -1;
        try {
            version2 = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            version2 = -1;
        }
        if (version2 < 0) {
            throw new MalformedCookieException("Invalid cookie version.");
        }
        cookie.setVersion(version2);
    }

    @Override
    public void validate(Cookie cookie, CookieOrigin origin) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        if (cookie instanceof SetCookie2 && cookie instanceof ClientCookie && !((ClientCookie)cookie).containsAttribute("version")) {
            throw new CookieRestrictionViolationException("Violates RFC 2965. Version attribute is required.");
        }
    }

    @Override
    public boolean match(Cookie cookie, CookieOrigin origin) {
        return true;
    }

    @Override
    public String getAttributeName() {
        return "version";
    }
}

