/*
 * Decompiled with CFR 0.152.
 */
package plugin.rtc.net.oauth;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import plugin.rtc.net.oauth.OAuthConsumer;
import plugin.rtc.net.oauth.OAuthException;
import plugin.rtc.net.oauth.OAuthMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OAuthAccessor
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 5590788443138352999L;
    public final OAuthConsumer consumer;
    public String requestToken;
    public String accessToken;
    public String tokenSecret;
    private final Map<String, Object> properties = new HashMap<String, Object>();

    public OAuthAccessor(OAuthConsumer consumer) {
        this.consumer = consumer;
        this.requestToken = null;
        this.accessToken = null;
        this.tokenSecret = null;
    }

    public OAuthAccessor clone() {
        try {
            return (OAuthAccessor)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    public void setProperty(String name, Object value) {
        this.properties.put(name, value);
    }

    public OAuthMessage newRequestMessage(String method, String url, Collection<? extends Map.Entry> parameters, InputStream body) throws OAuthException, IOException, URISyntaxException {
        if (method == null && (method = (String)this.getProperty("httpMethod")) == null && (method = (String)this.consumer.getProperty("httpMethod")) == null) {
            method = "GET";
        }
        OAuthMessage message = new OAuthMessage(method, url, parameters, body);
        message.addRequiredParameters(this);
        return message;
    }

    public OAuthMessage newRequestMessage(String method, String url, Collection<? extends Map.Entry> parameters) throws OAuthException, IOException, URISyntaxException {
        return this.newRequestMessage(method, url, parameters, null);
    }
}

