/*
 * Decompiled with CFR 0.152.
 */
package plugin.rtc.com.hp.hpl.jena.reasoner.rulesys.builtins;

import plugin.rtc.com.hp.hpl.jena.graph.Graph;
import plugin.rtc.com.hp.hpl.jena.graph.Node;
import plugin.rtc.com.hp.hpl.jena.graph.Triple;
import plugin.rtc.com.hp.hpl.jena.reasoner.InfGraph;
import plugin.rtc.com.hp.hpl.jena.reasoner.TriplePattern;
import plugin.rtc.com.hp.hpl.jena.reasoner.rulesys.BuiltinException;
import plugin.rtc.com.hp.hpl.jena.reasoner.rulesys.ClauseEntry;
import plugin.rtc.com.hp.hpl.jena.reasoner.rulesys.RuleContext;
import plugin.rtc.com.hp.hpl.jena.reasoner.rulesys.Util;
import plugin.rtc.com.hp.hpl.jena.reasoner.rulesys.builtins.BaseBuiltin;

public class Drop
extends BaseBuiltin {
    @Override
    public String getName() {
        return "drop";
    }

    @Override
    public void headAction(Node[] args, int length, RuleContext context) {
        boolean ok = false;
        InfGraph inf = context.getGraph();
        Graph raw = inf.getRawGraph();
        Graph deductions = inf.getDeductionsGraph();
        for (int i = 0; i < length; ++i) {
            ClauseEntry clause;
            Node clauseN = this.getArg(i, args, context);
            if (Util.isNumeric(clauseN)) {
                int clauseIndex = Util.getIntValue(clauseN);
                clause = context.getRule().getBodyElement(clauseIndex);
                if (!(clause instanceof TriplePattern)) {
                    throw new BuiltinException(this, context, "illegal triple to remove non-triple clause");
                }
            } else {
                throw new BuiltinException(this, context, "illegal arg to remove (" + clauseN + "), must be an integer");
            }
            Triple t = context.getEnv().instantiate((TriplePattern)clause);
            raw.delete(t);
            deductions.delete(t);
        }
    }

    @Override
    public boolean isMonotonic() {
        return false;
    }
}

