/*
 * Decompiled with CFR 0.152.
 */
package plugin.rtc.com.hp.hpl.jena.assembler.assemblers;

import java.util.List;
import plugin.rtc.com.hp.hpl.jena.assembler.Assembler;
import plugin.rtc.com.hp.hpl.jena.assembler.Content;
import plugin.rtc.com.hp.hpl.jena.assembler.JA;
import plugin.rtc.com.hp.hpl.jena.assembler.Mode;
import plugin.rtc.com.hp.hpl.jena.assembler.assemblers.AssemblerBase;
import plugin.rtc.com.hp.hpl.jena.assembler.assemblers.ContentAssembler;
import plugin.rtc.com.hp.hpl.jena.assembler.assemblers.PrefixMappingAssembler;
import plugin.rtc.com.hp.hpl.jena.assembler.exceptions.TransactionAbortedException;
import plugin.rtc.com.hp.hpl.jena.rdf.model.Model;
import plugin.rtc.com.hp.hpl.jena.rdf.model.ModelFactory;
import plugin.rtc.com.hp.hpl.jena.rdf.model.Property;
import plugin.rtc.com.hp.hpl.jena.rdf.model.Resource;
import plugin.rtc.com.hp.hpl.jena.rdf.model.Statement;
import plugin.rtc.com.hp.hpl.jena.rdf.model.StmtIterator;
import plugin.rtc.com.hp.hpl.jena.shared.PrefixMapping;
import plugin.rtc.com.hp.hpl.jena.util.iterator.Map1;
import plugin.rtc.com.hp.hpl.jena.vocabulary.RDF;

public abstract class ModelAssembler
extends AssemblerBase
implements Assembler {
    protected abstract Model openEmptyModel(Assembler var1, Resource var2, Mode var3);

    protected Model openModel(Assembler a, Resource root, Content initial, Mode mode) {
        Model m = this.openEmptyModel(a, root, mode);
        if (!initial.isEmpty()) {
            this.addContent(root, m, initial);
        }
        return m;
    }

    @Override
    public Object open(Assembler a, Resource root, Mode mode) {
        Model m = this.openModel(a, root, this.getInitialContent(a, root), mode);
        this.addContent(root, m, this.getContent(a, root));
        m.setNsPrefixes(this.getPrefixMapping(a, root));
        return m;
    }

    protected void addContent(Resource root, Model m, Content c) {
        if (m.supportsTransactions()) {
            m.begin();
            try {
                c.fill(m);
                m.commit();
            }
            catch (Throwable t) {
                m.abort();
                throw new TransactionAbortedException(root, t);
            }
        } else {
            c.fill(m);
        }
    }

    private PrefixMapping getPrefixMapping(Assembler a, Resource root) {
        return PrefixMappingAssembler.getPrefixes(a, root, PrefixMapping.Factory.create());
    }

    @Override
    public Model openModel(Resource root, Mode mode) {
        return (Model)this.open(this, root, mode);
    }

    protected Content getInitialContent(Assembler a, Resource root) {
        Model partial = ModelFactory.createDefaultModel();
        Resource combined = partial.createResource();
        StmtIterator it = root.listProperties(JA.initialContent);
        while (it.hasNext()) {
            this.transferContentProperties(partial, it.nextStatement().getResource(), combined);
        }
        return this.contentFromModel(a, root, partial, combined);
    }

    private Content contentFromModel(Assembler a, Resource root, Model partial, Resource combined) {
        return partial.isEmpty() ? Content.empty : (Content)a.open(this.completedClone(root, combined, partial));
    }

    protected Content getContent(Assembler a, Resource root) {
        Resource newRoot = this.oneLevelClone(root);
        Model fragment = newRoot.getModel();
        return fragment.isEmpty() ? Content.empty : (Content)a.open(a, this.completedClone(root, newRoot, fragment));
    }

    private Resource completedClone(Resource root, Resource newRoot, Model fragment) {
        Model typed = fragment.add(newRoot, RDF.type, JA.Content);
        return newRoot.inModel(ModelFactory.createUnion(root.getModel(), typed));
    }

    private Resource oneLevelClone(Resource root) {
        Model partialCopy = ModelFactory.createDefaultModel();
        Resource newRoot = partialCopy.createResource();
        this.transferContentProperties(partialCopy, root, newRoot);
        return newRoot;
    }

    private void transferContentProperties(Model partial, Resource someInitial, Resource combined) {
        Map1<Statement, Statement> replace = this.replaceSubjectMap(partial, combined);
        for (Property contentProperty : ContentAssembler.contentProperties) {
            partial.add(this.copyProperties(someInitial, replace, contentProperty));
        }
    }

    private List<Statement> copyProperties(Resource root, Map1<Statement, Statement> replace, Property property) {
        return root.listProperties(property).mapWith(replace).toList();
    }

    private Map1<Statement, Statement> replaceSubjectMap(final Model inModel, final Resource newSubject) {
        Map1<Statement, Statement> replace = new Map1<Statement, Statement>(){

            @Override
            public Statement map1(Statement o) {
                Statement s = o;
                return inModel.createStatement(newSubject, s.getPredicate(), s.getObject());
            }
        };
        return replace;
    }
}

