/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.scm.git.internal.scheduling;

import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleScheduledTaskExecutorService {
    private static final Logger LOGGER = LoggerFactory.getLogger(SingleScheduledTaskExecutorService.class);
    private ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
    private ScheduledFuture singleTask;

    public Future schedule(Callable command, long delay, TimeUnit unit) {
        LOGGER.trace("Scheduling task of type {} with delay of {} {}.", new Object[]{command.getClass(), delay, unit.toString()});
        this.cancelScheduledTask();
        this.singleTask = this.scheduler.schedule(command, delay, unit);
        LOGGER.trace("Successfully scheduled task of type {} with delay of {} {}.", new Object[]{command.getClass(), delay, unit.toString()});
        return this.singleTask;
    }

    public void cancelScheduledTask() {
        if (this.singleTask != null) {
            LOGGER.trace("Trying to cancel current task of type {}. {} seconds were remaining.", this.singleTask.getClass(), (Object)this.singleTask.getDelay(TimeUnit.SECONDS));
            this.singleTask.cancel(false);
            LOGGER.debug("Successfully cancelled the current task.");
        } else {
            LOGGER.debug("No task were scheduled.");
        }
    }
}

