/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.validators;

import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Objects;
import org.springframework.stereotype.Component;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.BindException;
import org.springframework.validation.Errors;
import org.springframework.validation.ValidationUtils;
import org.springframework.validation.Validator;
import org.squashtest.tm.domain.testautomation.AutomatedTestTechnology;
import org.squashtest.tm.plugin.rest.controller.helper.ErrorHandlerHelper;
import org.squashtest.tm.plugin.rest.jackson.model.AutomatedTestTechnologyDto;
import org.squashtest.tm.plugin.rest.repository.RestAutomatedTestTechnologyRepository;

@Component
public class AutomatedTestTechnologyValidator
implements Validator {
    private static final String POST_AUTOMATED_TEST_TECHNOLOGY = "post-automated-test-technology";
    @Inject
    private RestAutomatedTestTechnologyRepository restAutomatedTestTechnologyRepository;

    public boolean supports(Class<?> clazz) {
        return AutomatedTestTechnology.class.equals(clazz);
    }

    public void validate(Object target, Errors errors) {
        AutomatedTestTechnologyDto technologyDto = (AutomatedTestTechnologyDto)target;
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"name", (String)"required", (String)"This attribute can't be empty.");
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"actionProviderKey", (String)"required", (String)"This attribute can't be empty.");
        String technologyDtoName = technologyDto.getName();
        if (technologyDtoName != null && Objects.nonNull(this.restAutomatedTestTechnologyRepository.findByName(technologyDtoName))) {
            errors.rejectValue("name", "invalid value", "A technology with the same name already exists");
        }
    }

    public void validatePostAutomatedTestTechnology(AutomatedTestTechnologyDto automatedTestTechnologyDto) throws BindException {
        ArrayList<Errors> errors = new ArrayList<Errors>();
        BeanPropertyBindingResult validation = new BeanPropertyBindingResult((Object)automatedTestTechnologyDto, POST_AUTOMATED_TEST_TECHNOLOGY);
        this.validate(automatedTestTechnologyDto, (Errors)validation);
        if (validation.hasErrors()) {
            errors.add((Errors)validation);
        }
        ErrorHandlerHelper.throwIfError(automatedTestTechnologyDto, errors, POST_AUTOMATED_TEST_TECHNOLOGY);
    }
}

