/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.service.helper;

import jakarta.inject.Inject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Component;
import org.springframework.validation.Errors;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.domain.customfield.BoundEntity;
import org.squashtest.tm.domain.customfield.CustomField;
import org.squashtest.tm.domain.customfield.CustomFieldValue;
import org.squashtest.tm.domain.customfield.RawValue;
import org.squashtest.tm.plugin.rest.jackson.model.CustomFieldValueDto;
import org.squashtest.tm.plugin.rest.validators.helper.CustomFieldValueValidationHelper;
import org.squashtest.tm.service.customfield.CustomFieldBindingFinderService;
import org.squashtest.tm.service.customfield.CustomFieldValueChangerService;
import org.squashtest.tm.service.customfield.CustomFieldValueFinderService;
import org.squashtest.tm.service.internal.repository.CustomFieldDao;

@Component
public final class CustomFieldValueHelper {
    @Inject
    private CustomFieldDao customFieldDao;
    @Inject
    private CustomFieldValueChangerService customFieldValueChangerService;
    @Inject
    private CustomFieldValueFinderService customFieldValueFinderService;
    @Inject
    private CustomFieldBindingFinderService bindingService;

    private CustomFieldValueHelper() {
    }

    public Map<Long, RawValue> convertCustomFieldDtoToMap(List<CustomFieldValueDto> customFieldValueDtos) {
        if (customFieldValueDtos == null) {
            return new HashMap<Long, RawValue>();
        }
        HashMap<Long, RawValue> customFieldRawValues = new HashMap<Long, RawValue>();
        for (CustomFieldValueDto customFieldValueDto : customFieldValueDtos) {
            CustomField customField = this.customFieldDao.findByCode(customFieldValueDto.getCode());
            customFieldRawValues.put(customField.getId(), customFieldValueDto.getValue());
        }
        return customFieldRawValues;
    }

    public List<CustomFieldValue> patchCustomFieldValue(BoundEntity boundEntity, List<CustomFieldValueDto> cufValuesDto) {
        List cufValues = this.customFieldValueFinderService.findAllCustomFieldValues(boundEntity);
        for (CustomFieldValueDto dto : cufValuesDto) {
            for (CustomFieldValue value : cufValues) {
                CustomField cf = value.getBinding().getCustomField();
                if (!dto.getCode().equals(cf.getCode())) continue;
                this.customFieldValueChangerService.changeValue(value.getId().longValue(), dto.getValue());
            }
        }
        return cufValues;
    }

    public void checkCufs(Errors errors, BindableEntity bindableEntity, Long projectId, List<CustomFieldValueDto> listCufsDto, Long entityId) {
        List customFields = this.bindingService.findBoundCustomFields(projectId.longValue(), bindableEntity);
        CustomFieldValueValidationHelper helper = new CustomFieldValueValidationHelper(this.customFieldValueChangerService, bindableEntity, projectId, customFields, listCufsDto, errors);
        helper.setEntityId(entityId);
        helper.validate();
    }
}

