/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.tuleap.internal;

import jakarta.inject.Inject;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.squashtest.csp.core.bugtracker.core.BugTrackerRemoteException;
import org.squashtest.csp.core.bugtracker.spi.BugTrackerInterfaceDescriptor;
import org.squashtest.tm.bugtracker.advanceddomain.AdvancedIssue;
import org.squashtest.tm.bugtracker.advanceddomain.AdvancedProject;
import org.squashtest.tm.bugtracker.advanceddomain.DelegateCommand;
import org.squashtest.tm.bugtracker.advanceddomain.Field;
import org.squashtest.tm.bugtracker.advanceddomain.FieldValue;
import org.squashtest.tm.bugtracker.definition.Attachment;
import org.squashtest.tm.bugtracker.definition.RemoteIssue;
import org.squashtest.tm.bugtracker.definition.context.RemoteIssueContext;
import org.squashtest.tm.domain.bugtracker.BugTracker;
import org.squashtest.tm.domain.servers.Credentials;
import org.squashtest.tm.plugin.bugtracker.tuleap.TuleapBugTrackerInterfaceDescriptor;
import org.squashtest.tm.plugin.bugtracker.tuleap.internal.ExceptionHandler;
import org.squashtest.tm.plugin.bugtracker.tuleap.internal.TuleapClient;
import org.squashtest.tm.plugin.bugtracker.tuleap.internal.config.FieldConfiguration;
import org.squashtest.tm.plugin.bugtracker.tuleap.internal.converters.SquashToTuleapConverter;
import org.squashtest.tm.plugin.bugtracker.tuleap.internal.converters.TuleapToSquashConverter;
import org.squashtest.tm.plugin.bugtracker.tuleap.internal.domain.TuleapArtifact;
import org.squashtest.tm.plugin.bugtracker.tuleap.internal.domain.TuleapAttachmentPatch;
import org.squashtest.tm.plugin.bugtracker.tuleap.internal.domain.TuleapField;
import org.squashtest.tm.plugin.bugtracker.tuleap.internal.domain.TuleapFile;
import org.squashtest.tm.plugin.bugtracker.tuleap.internal.domain.TuleapPatch;
import org.squashtest.tm.plugin.bugtracker.tuleap.internal.domain.TuleapProject;
import org.squashtest.tm.plugin.bugtracker.tuleap.internal.domain.TuleapTracker;
import org.squashtest.tm.service.spi.AdvancedBugTrackerConnector;

@Component
@Scope(value="prototype")
public class TuleapConnector
implements AdvancedBugTrackerConnector {
    private static final String ORIGINAL_SUBMISSION_FIELD_ID = "Original Submission";
    @Inject
    private TuleapClient tuleapClient;
    @Inject
    private TuleapBugTrackerInterfaceDescriptor interfaceDescriptor;
    @Inject
    private TuleapToSquashConverter tuleapToSquashConverter;
    @Inject
    private SquashToTuleapConverter squashToTuleapConverter;
    @Inject
    private FieldConfiguration fieldConfiguration;
    @Inject
    private ExceptionHandler exceptionHandler;
    private BugTracker bugTracker;

    public void authenticate(Credentials credentials) {
        this.tuleapClient.init(this.bugTracker, credentials);
    }

    public void checkCredentials(Credentials credentials) throws BugTrackerRemoteException {
        this.authenticate(credentials);
        this.tuleapClient.fetchPaginatedTuleapProjects(1, 0);
    }

    public URL makeViewIssueUrl(String issueId) {
        Optional<TuleapArtifact> optionalArtifact = this.tuleapClient.findArtifactByIdFailSafe(issueId);
        Object url = this.bugTracker.getUrl();
        while (((String)url).endsWith("/")) {
            url = ((String)url).substring(0, ((String)url).length() - 1);
        }
        if (optionalArtifact.isPresent()) {
            TuleapArtifact artifact = optionalArtifact.get();
            url = (String)url + artifact.getPageUrl();
        }
        try {
            return new URL((String)url);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public AdvancedProject findProject(String projectName) throws BugTrackerRemoteException {
        TuleapProject tuleapProject = this.doFindTuleapProjects(projectName);
        List<TuleapTracker> trackers = this.tuleapClient.findTrackers(tuleapProject);
        tuleapProject.setTrackers(trackers);
        return this.tuleapToSquashConverter.convertProject(tuleapProject);
    }

    public AdvancedProject findProjectById(String projectId) throws BugTrackerRemoteException {
        TuleapProject tuleapProject = this.doFindTuleapProjectById(projectId);
        return this.tuleapToSquashConverter.convertProject(tuleapProject);
    }

    public AdvancedIssue createIssue(RemoteIssue remoteIssue) throws BugTrackerRemoteException {
        AdvancedIssue issue = (AdvancedIssue)remoteIssue;
        String projectId = issue.getProject().getId();
        TuleapProject tuleapProject = this.doFindTuleapProjectById(projectId);
        TuleapTracker tuleapTracker = tuleapProject.findTrackerBySchemeName(issue.getCurrentScheme());
        TuleapArtifact tuleapArtifact = this.squashToTuleapConverter.convertAdvancedIssue(issue, tuleapTracker);
        this.tuleapClient.createArtifact(tuleapArtifact);
        issue.setId(tuleapArtifact.getId().toString());
        return issue;
    }

    public BugTrackerInterfaceDescriptor getInterfaceDescriptor() {
        return this.interfaceDescriptor;
    }

    public RemoteIssue createReportIssueTemplate(String projectName, RemoteIssueContext context) {
        TuleapProject tuleapProject = this.doFindTuleapProjects(projectName);
        AdvancedProject project = this.tuleapToSquashConverter.convertProject(tuleapProject);
        AdvancedIssue advancedIssue = new AdvancedIssue();
        advancedIssue.setBugtracker(this.bugTracker.getName());
        advancedIssue.setProject(project);
        String firstSchemeKey = (String)project.getSchemeMap().keySet().stream().findFirst().orElseThrow();
        advancedIssue.setCurrentScheme(firstSchemeKey);
        Collection fields = project.getFieldScheme(firstSchemeKey);
        for (Field field : fields) {
            if (ORIGINAL_SUBMISSION_FIELD_ID.equals(field.getLabel())) {
                advancedIssue.setFieldValue(field.getLabel(), new FieldValue("", context.getDefaultDescription()));
                continue;
            }
            advancedIssue.setFieldValue(field.getLabel(), null);
        }
        return advancedIssue;
    }

    public AdvancedIssue findIssue(String issueId) {
        TuleapArtifact tuleapArtifact = this.doFindIssueWithTracker(issueId);
        return this.tuleapToSquashConverter.convertTuleapArtifact(tuleapArtifact);
    }

    public List<AdvancedIssue> findIssues(List<String> issueIds) {
        if (issueIds.isEmpty()) {
            return new ArrayList<AdvancedIssue>();
        }
        HashMap tuleapProjectMap = new HashMap();
        HashMap tuleapTrackerMap = new HashMap();
        List<TuleapArtifact> artifacts = this.tuleapClient.findArtifactsByIds(issueIds);
        Map artifactMap = artifacts.stream().collect(Collectors.toMap(artifact -> artifact.getId().toString(), Function.identity()));
        return issueIds.stream().map(issueId -> {
            if (artifactMap.containsKey(issueId)) {
                TuleapArtifact artifact = (TuleapArtifact)artifactMap.get(issueId);
                Long projectId = artifact.getProject().getId();
                Long trackerId = artifact.getTracker().getId();
                if (!tuleapProjectMap.containsKey(projectId)) {
                    TuleapProject tuleapProject = this.doFindTuleapProjectById(projectId.toString());
                    tuleapProjectMap.put(tuleapProject.getId(), tuleapProject);
                    for (TuleapTracker tuleapTracker : tuleapProject.getTrackers()) {
                        tuleapTrackerMap.put(tuleapTracker.getId(), tuleapTracker);
                    }
                }
                artifact.setProject((TuleapProject)tuleapProjectMap.get(projectId));
                artifact.setTracker((TuleapTracker)tuleapTrackerMap.get(trackerId));
                return artifact;
            }
            TuleapArtifact artifact = new TuleapArtifact();
            artifact.setId(Long.parseLong(issueId));
            artifact.setNotFound(true);
            return artifact;
        }).map(this.tuleapToSquashConverter::convertTuleapArtifact).collect(Collectors.toList());
    }

    private TuleapArtifact doFindIssueWithTracker(String issueId) {
        TuleapArtifact artifact = this.tuleapClient.findArtifactById(issueId);
        TuleapProject tuleapProject = this.tuleapClient.findProjectById(artifact.getProject().getId().toString());
        List<TuleapTracker> trackers = this.tuleapClient.findTrackers(tuleapProject);
        tuleapProject.setTrackers(trackers);
        artifact.setTracker(tuleapProject.findTrackerById(artifact.getTracker().getId()));
        artifact.setProject(tuleapProject);
        return artifact;
    }

    public void forwardAttachments(String issueKey, List<Attachment> attachments) {
        ArrayList<Long> ids = new ArrayList<Long>();
        for (Attachment attachment : attachments) {
            TuleapFile tuleapFile = this.squashToTuleapConverter.convertFile(attachment);
            Long temporaryFileId = this.tuleapClient.createTemporaryFile(tuleapFile);
            ids.add(temporaryFileId);
        }
        TuleapArtifact tuleapArtifact = this.tuleapClient.findArtifactById(issueKey);
        TuleapTracker tracker = this.tuleapClient.findTracker(tuleapArtifact.getTracker().getId().toString());
        TuleapField attachmentField = this.findAttachmentField(tracker);
        TuleapAttachmentPatch tuleapAttachmentPatch = new TuleapAttachmentPatch();
        tuleapAttachmentPatch.setFieldId(attachmentField.getId());
        tuleapAttachmentPatch.setValue(ids);
        TuleapPatch tuleapPatch = new TuleapPatch();
        tuleapPatch.addValue(tuleapAttachmentPatch);
        this.tuleapClient.patchArtifactForAttachments(issueKey, tuleapPatch);
    }

    public Object executeDelegateCommand(DelegateCommand delegateCommand) {
        return null;
    }

    public void linkIssues(String s, List<String> list) {
    }

    public void setBugTracker(BugTracker bugTracker) {
        this.bugTracker = bugTracker;
    }

    private TuleapProject doFindTuleapProjectById(String projectId) {
        TuleapProject tuleapProject = this.tuleapClient.findProjectById(projectId);
        List<TuleapTracker> trackers = this.tuleapClient.findTrackers(tuleapProject);
        tuleapProject.setTrackers(trackers);
        return tuleapProject;
    }

    private TuleapProject doFindTuleapProjects(String projectName) {
        int offset = 0;
        TuleapProject matchingProject = null;
        while (matchingProject == null) {
            List<TuleapProject> currentPageProjects = this.tuleapClient.fetchPaginatedTuleapProjects(10, offset);
            if (currentPageProjects.isEmpty()) {
                throw this.exceptionHandler.projectNotFound(projectName);
            }
            matchingProject = currentPageProjects.stream().filter(candidate -> candidate.getLabel().equals(projectName)).findFirst().orElse(null);
            offset += 10;
        }
        List<TuleapTracker> trackers = this.tuleapClient.findTrackers(matchingProject);
        matchingProject.setTrackers(trackers);
        return matchingProject;
    }

    private TuleapField findAttachmentField(TuleapTracker tracker) {
        TuleapField attachmentField = tracker.findFieldByName(this.fieldConfiguration.getAttachment());
        if (attachmentField.getId() == null) {
            attachmentField = tracker.findFirstAttachmentField();
        }
        return attachmentField;
    }
}

