/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.admin.validators;

import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.util.ArrayList;
import java.util.Objects;
import org.springframework.stereotype.Component;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;
import org.squashtest.tm.domain.project.GenericProject;
import org.squashtest.tm.domain.testautomation.TestAutomationServer;
import org.squashtest.tm.plugin.rest.controller.helper.ErrorHandlerHelper;
import org.squashtest.tm.plugin.rest.jackson.model.GenericProjectDto;

@Component
public class ProjectValidator
implements Validator {
    public static final String BIND_TEST_AUTOMATION_SERVER_TO_PROJECT = "bind-test-automation-server-to-project";
    public static final String UNBIND_TEST_AUTOMATION_SERVER_FROM_PROJECT = "unbind-test-automation-server-from-project";
    @PersistenceContext
    protected EntityManager entityManager;

    public boolean supports(Class<?> clazz) {
        return GenericProjectDto.class.equals(clazz);
    }

    public void validate(Object target, Errors errors) {
    }

    public void validateBindTestAutomationServerToProject(long projectId, long serverId) throws BindException {
        TestAutomationServer bindTestAutomationServerToProject = new TestAutomationServer();
        BeanPropertyBindingResult validationBean = new BeanPropertyBindingResult((Object)bindTestAutomationServerToProject, BIND_TEST_AUTOMATION_SERVER_TO_PROJECT);
        GenericProject project = (GenericProject)this.entityManager.find(GenericProject.class, (Object)projectId);
        this.checkEntityExists(projectId, project, "project", (BindingResult)validationBean);
        TestAutomationServer testAutomationServer = (TestAutomationServer)this.entityManager.find(TestAutomationServer.class, (Object)serverId);
        this.checkEntityExists(serverId, testAutomationServer, "test-automation-server", (BindingResult)validationBean);
        ArrayList<BeanPropertyBindingResult> errors = new ArrayList<BeanPropertyBindingResult>();
        if (validationBean.hasErrors()) {
            errors.add(validationBean);
        }
        ErrorHandlerHelper.throwIfError((Object)bindTestAutomationServerToProject, errors, (String)BIND_TEST_AUTOMATION_SERVER_TO_PROJECT);
    }

    private void checkEntityExists(long entityId, Object entity, String entityType, BindingResult validationBean) {
        if (Objects.isNull(entity)) {
            String message = String.format("No entity known for type %s and id %d", entityType, entityId);
            validationBean.rejectValue("id", "invalid id", message);
        }
    }

    public void validateUnbindTestAutomationServerFromProject(long projectId) throws BindException {
        TestAutomationServer unbindTestAutomationServerFromProject = new TestAutomationServer();
        BeanPropertyBindingResult validationBean = new BeanPropertyBindingResult((Object)unbindTestAutomationServerFromProject, UNBIND_TEST_AUTOMATION_SERVER_FROM_PROJECT);
        GenericProject project = (GenericProject)this.entityManager.find(GenericProject.class, (Object)projectId);
        this.checkEntityExists(projectId, project, "project", (BindingResult)validationBean);
        ArrayList<BeanPropertyBindingResult> errors = new ArrayList<BeanPropertyBindingResult>();
        if (validationBean.hasErrors()) {
            errors.add(validationBean);
        }
        ErrorHandlerHelper.throwIfError((Object)unbindTestAutomationServerFromProject, errors, (String)BIND_TEST_AUTOMATION_SERVER_TO_PROJECT);
    }
}

