/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.admin.controller;

import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.PagedModel;
import org.springframework.hateoas.server.RepresentationModelAssembler;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.BindException;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.squashtest.tm.domain.users.ApiToken;
import org.squashtest.tm.domain.users.Team;
import org.squashtest.tm.domain.users.User;
import org.squashtest.tm.plugin.rest.admin.controller.RestAdminBaseController;
import org.squashtest.tm.plugin.rest.admin.service.RestAdminApiTokenService;
import org.squashtest.tm.plugin.rest.admin.service.RestAdminPartyService;
import org.squashtest.tm.plugin.rest.admin.validators.ApiTokenValidator;
import org.squashtest.tm.plugin.rest.controller.helper.ErrorHandlerHelper;
import org.squashtest.tm.plugin.rest.core.jackson.DynamicFilterExpression;
import org.squashtest.tm.plugin.rest.core.web.EntityGetter;
import org.squashtest.tm.plugin.rest.core.web.RestApiController;
import org.squashtest.tm.plugin.rest.core.web.UseDefaultRestApiConfiguration;
import org.squashtest.tm.plugin.rest.jackson.model.ApiTokenRestDto;
import org.squashtest.tm.service.internal.dto.ApiTokenDto;

@RestApiController(value=User.class)
@UseDefaultRestApiConfiguration
public class RestAdminUserController
extends RestAdminBaseController {
    @Inject
    private RestAdminPartyService restAdminPartyService;
    @Inject
    private RestAdminApiTokenService restAdminApiTokenService;
    @Inject
    private ApiTokenValidator apiTokenValidator;
    private final ApiTokenRessourceAssembler apiTokenResourceAssembler = new ApiTokenRessourceAssembler();

    @GetMapping(value={"/users/login/{login}"})
    @EntityGetter
    @DynamicFilterExpression(value="*, teams[*, -members]")
    public ResponseEntity<EntityModel<User>> findUserByLogin(@PathVariable(value="login") String login) {
        User user = this.restAdminPartyService.findUserByLogin(login);
        EntityModel<User> res = this.toEntityModel(user);
        return ResponseEntity.ok(res);
    }

    @GetMapping(value={"/users/login/{userLogin}/teams"})
    @ResponseBody
    @DynamicFilterExpression(value="*, -members")
    public ResponseEntity<PagedModel<EntityModel<Team>>> findTeamsByUserLogin(@PathVariable(value="userLogin") String userLogin, Pageable pageable) {
        Page<Team> teams = this.restAdminPartyService.findTeamsByUserLogin(userLogin, pageable);
        PagedModel<EntityModel<Team>> res = this.toPagedModel(teams);
        return ResponseEntity.ok(res);
    }

    @PostMapping(value={"/users/login/{userLogin}/teams"})
    @ResponseBody
    public ResponseEntity<Void> addTeamsToUser(@PathVariable(value="userLogin") String userLogin, @RequestParam(value="teamNames") List<String> teamNames) {
        this.restAdminPartyService.addTeamsToUser(userLogin, teamNames);
        return ResponseEntity.noContent().build();
    }

    @DeleteMapping(value={"/users/login/{userLogin}/teams"})
    @ResponseBody
    public ResponseEntity<Void> disassociateUserFromTeams(@PathVariable(value="userLogin") String userLogin, @RequestParam(value="teamNames") List<String> teamNames) {
        this.restAdminPartyService.disassociateUserFromTeams(userLogin, teamNames);
        return ResponseEntity.noContent().build();
    }

    @GetMapping(value={"/users/{userId}/tokens"})
    @ResponseBody
    @EntityGetter
    public ResponseEntity<PagedModel<EntityModel<ApiToken>>> getAllTokensByTestAutoServerUser(@PathVariable(value="userId") long userId, Pageable pageable) {
        Page<ApiToken> pagedApiTokens = this.restAdminApiTokenService.getAllTokensByTestAutoServerUser(pageable, userId);
        PagedModel res = this.pageAssembler.toModel(pagedApiTokens, (RepresentationModelAssembler)this.apiTokenResourceAssembler);
        return ResponseEntity.ok((Object)res);
    }

    @DeleteMapping(value={"/users/tokens/{tokenId}"})
    public ResponseEntity<String> deleteTestAutoServerApiToken(@PathVariable(value="tokenId") long tokenId) {
        this.restAdminApiTokenService.deleteTestAutoServerApiToken(tokenId);
        return ResponseEntity.noContent().build();
    }

    @PostMapping(value={"/users/{userId}/tokens"})
    @ResponseBody
    @DynamicFilterExpression(value="*,name,api_token[name]")
    public ResponseEntity<ApiTokenRestDto> postApiToken(@PathVariable(value="userId") long userId, @RequestBody ApiTokenRestDto apiTokenRestDto) throws BindException {
        this.validatePostApiToken(apiTokenRestDto);
        ApiTokenDto apiTokenDto = this.restAdminApiTokenService.addToken(userId, apiTokenRestDto);
        apiTokenRestDto.setGeneratedToken(apiTokenDto.generatedJwtToken());
        apiTokenRestDto.setId(apiTokenDto.squashApiToken().getId());
        apiTokenRestDto.setUser(apiTokenDto.squashApiToken().getUser());
        apiTokenRestDto.setCreatedOn(apiTokenDto.squashApiToken().getCreatedOn());
        apiTokenRestDto.setCreatedBy(apiTokenDto.squashApiToken().getCreatedBy());
        apiTokenRestDto.setUuid(apiTokenDto.squashApiToken().getUuid());
        apiTokenRestDto.setLastUsage(apiTokenDto.squashApiToken().getLastUsage());
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)apiTokenRestDto);
    }

    private void validatePostApiToken(ApiTokenRestDto apiTokenRestDto) throws BindException {
        ArrayList<BeanPropertyBindingResult> errors = new ArrayList<BeanPropertyBindingResult>();
        BeanPropertyBindingResult validation = new BeanPropertyBindingResult((Object)apiTokenRestDto, "post-api-token");
        this.apiTokenValidator.validate(apiTokenRestDto, (Errors)validation);
        if (validation.hasErrors()) {
            errors.add(validation);
        }
        ErrorHandlerHelper.throwIfError((Object)apiTokenRestDto, errors, (String)"post-api-token");
    }

    private static class ApiTokenRessourceAssembler
    implements RepresentationModelAssembler<ApiToken, EntityModel<ApiToken>> {
        private ApiTokenRessourceAssembler() {
        }

        public EntityModel<ApiToken> toModel(ApiToken entity) {
            return EntityModel.of((Object)entity);
        }
    }
}

