/*
 *     This file is part of the Campaign Assistant for Squash TM (henix-tm-wizard-campaignassistant) project.
 *     Copyright (C) 2017 Henix - All Rights Reserved
 *
 *     Unauthorized copying of this file, via any medium is strictly prohibited
 *     Proprietary and confidential
 *
 * 	 (C)Henix. Tous droits réservés.
 *
 * 	Avertissement : ce programme est protégé par la loi relative au droit d'auteur et par les conventions internationales. Toute reproduction ou distribution partielle ou totale du logiciel, par quelque moyen que ce soit, est strictement interdite.
 */
define(["jquery", "backbone", "underscore", "handlebars", "squash.attributeparser", "serverauth/auth-manager", "./abstractStepView",
        "search/SearchDateWidget", "search/SearchMultiAutocompleteWidget", "jquery.switchButton"],
	function($, backbone, _, Handlebars, attrparser, authmanager, AbstractStepView) {
	"use strict";


	var advancedCriteriaStepView = AbstractStepView.extend({

        events: {
            "click input[name='entity']": "_toggleEntityPanelVisibility",
            "change #keep-issued-checkbox": "_fillIssueComboBox",
            "change #toggle-activation-checkbox": "_chooseIssueMode"
        },

        listBoxMap: {
            "tc-status-listbox": "testCaseStatuses",
            "tc-importance-listbox": "testCaseImportances",
            "tc-nat-listbox": "testCaseNatures",
            "tc-type-listbox": "testCaseTypes",

            "req-crit-listbox": "requirementCriticalities",
            "req-status-listbox": "requirementStatuses",
            "req-cat-listbox": "requirementCategories",

            "exec-status-listbox": "executionStatuses",
            "exec-mode-listbox": "executionModes"
        },

		initialize : function(data, wizrouter) {
			this.tmpl = "#advanced-criteria-step-tpl";
			this.model = data;
			this.model.set({ "simpleCriteria": undefined });
			data.name = "advancedCriteriaStep";
			this._initialize(data, wizrouter);
		},

		prepareUI : function() {
            var self = this;

		    self._initTestPlanItemPanel();
		    //this._initRequirementPanel();
		    self._initTestSuitePanel();
		    var keepIssued = squashtm.wizard.keepIssued;
            var bt = squashtm.wizard.bt;
		    if (keepIssued && bt.status === "AUTHENTICATED" && $("#generate").is(":visible")) {
		        self._initIssueMode(false);
		    }

		    if (bt.id == null) {
		        $("#ISSUE-box").hide();
		        $("#ISSUE-panel").hide();
		    }

		    _.mapObject(self.listBoxMap, function(value, key) {
		        self._initListBox(key, value);
		    });
		},

        reloadDataInView : function() {

            var self = this;

            var emptyCriteria = {};

        	var criteria = this.model.get("advancedCriteria") || emptyCriteria;

            /* Reload all the ListBoxes of fixed values. */

            _.mapObject(self.listBoxMap, function(value, key) {
                self._reloadListBox(key, criteria[value]);
            });

            /* Execution Panel */

            $("#exec-user-textbox").val(criteria.executionUsers);

            if(!!criteria.executionFromDate || !!criteria.executionToDate) {
                $("#exec-date-inputs").searchDateWidget("fieldvalue", {
                    startDate: criteria.executionFromDate,
                    endDate: criteria.executionToDate
                });
            }

            /* Test Suite Panel */

            self._reloadListBox("test-suite-listbox", criteria["testSuites"]);

            /* Issue Panel */
            var keepIssued = $("#keep-issued-checkbox").is(":checked");
            if (keepIssued) {
                $("#keep-issued-checkbox").prop('checked', keepIssued);
            } else {
                $("#keep-issued-checkbox").prop('checked', criteria.keepIssued);
            }

            var isIssuesAllExecs = squashtm.wizard.isIssuesAllExecs;
            if (isIssuesAllExecs) {
                $("#toggle-activation-checkbox").switchButton({checked:true});
            } else {
                $("#toggle-activation-checkbox").switchButton({checked:false});
            }


            var bt = squashtm.wizard.bt;
            if (criteria.keepIssued && (bt.kind === "jira.rest" || bt.kind === "jira.cloud") && bt.status === "AUTHENTICATED") {
                $("#keep-issued-combobox").removeClass("not-displayed");
                $("#keep-issued-switch").removeClass("not-displayed");

                self._reloadListBox("keep-issue-status-listbox", criteria["keepIssuedStatuses"]);
                self._reloadListBox("keep-issue-priority-listbox", criteria["keepIssuedPriorities"]);
                self._reloadListBox("keep-issue-assignee-listbox", criteria["keepIssuedAssignees"]);
            }

            /* Entities */

            _.each(criteria.selectedEntities, function(id) {
                $("#" + id).prop('checked', true);
                $("#" + id + "-panel").removeClass("not-displayed");
            });

        },

        _reloadListBox: function(listDomId, selectedAttrList) {
            $("#" + listDomId + " option").filter(function() {
                return _.contains(selectedAttrList, $(this).val());
            }).prop('selected', true);
        },

        updateModel : function() {

            var selectedEntities = _.pluck($("[name='entity']").filter(":checked"), "id");

            var execStatus, execUsers, execTimeInterval, execFromDate, execToDate, execModes;
            if(_.contains(selectedEntities, "TEST_PLAN_ITEM")) {
                execStatus = $("#exec-status-listbox").val();
                execUsers = $("#exec-user-textbox").searchMultiAutocompleteWidget("fieldvalue").values;
                execTimeInterval = $("#exec-date-inputs").searchDateWidget("fieldvalue");
                if(!!execTimeInterval) {
                    execFromDate = execTimeInterval.startDate;
                    execToDate = execTimeInterval.endDate;
                }
                execModes = $("#exec-mode-listbox").val();
            }

            var tcStatuses, tcImportances, tcNatures, tcTypes;
            if(_.contains(selectedEntities, "TEST_CASE")) {
                tcStatuses = $("#tc-status-listbox").val();
                tcImportances = $("#tc-importance-listbox").val();
                tcNatures = $("#tc-nat-listbox").val();
                tcTypes = $("#tc-type-listbox").val();
            }

            var reqCriticalities, reqStatuses, reqCategories;
            if(_.contains(selectedEntities, "REQUIREMENT")) {
                reqCriticalities = $("#req-crit-listbox").val();
                reqStatuses = $("#req-status-listbox").val();
                reqCategories = $("#req-cat-listbox").val();
            }

            var testSuites;
            if(_.contains(selectedEntities, "TEST_SUITE")) {

                testSuites = $("#test-suite-listbox").val();
            }

            var keepIssued, isIssuesAllExecs;
            if(_.contains(selectedEntities, "ISSUE")) {
                keepIssued = $("#keep-issued-checkbox").is(":checked");

                var bt = squashtm.wizard.bt;
                if (keepIssued && (bt.kind === "jira.rest" || bt.kind === "jira.cloud") && bt.status === "AUTHENTICATED") {
                    isIssuesAllExecs = $("#toggle-activation-checkbox").is(':checked');
                    squashtm.wizard.isIssuesAllExecs = isIssuesAllExecs;
                    $("#keep-issued-combobox").removeClass("not-displayed");
                    $("#keep-issued-switch").removeClass("not-displayed");
                    var keepIssuedStatuses = $("#keep-issue-status-listbox").val();
                    var keepIssuedPriorities = $("#keep-issue-priority-listbox").val();
                    var keepIssuedAssignees = $("#keep-issue-assignee-listbox").val();
                    var tcByRemoteIds = [];

                    if (keepIssuedStatuses || keepIssuedPriorities || keepIssuedAssignees) {
                        var keepIssuedCriteria = {
                            "status": keepIssuedStatuses,
                            "priority": keepIssuedPriorities,
                            "assignee": keepIssuedAssignees
                        };
                    }
                }
            }

        	var advancedCriteria = {
        	    selectedEntities: selectedEntities,

        		executionStatuses: execStatus,
        		executionUsers: execUsers,
        		executionFromDate: execFromDate,
        		executionToDate: execToDate,
        		executionModes: execModes,

        		testCaseStatuses: tcStatuses,
        		testCaseImportances: tcImportances,
        		testCaseNatures: tcNatures,
        		testCaseTypes: tcTypes,

        		requirementCriticalities: reqCriticalities,
        		requirementStatuses: reqStatuses,
        		requirementCategories: reqCategories,

        		testSuites: testSuites,

        		keepIssued: keepIssued,
        		keepIssuedStatuses: keepIssuedStatuses,
                keepIssuedPriorities: keepIssuedPriorities,
                keepIssuedAssignees: keepIssuedAssignees,
        		keepIssuedCriteria: keepIssuedCriteria,
        		issuesAllExecs: isIssuesAllExecs
        	};


        	this.model.set({
                advancedCriteria: advancedCriteria
        	});
        },

		_initTestPlanItemPanel: function() {
            this._initUserTextbox();
            this._initExecDates();
		},

        _initListBox: function(listDomId, modelAttributeName) {
            var list = this.model.get(modelAttributeName);
            var listBox = this.$el.find("#" + listDomId);
            _.mapObject(list, function(value, key) {
                listBox.append("<option value='" + key + "'></option>");
                var option = listBox.find("option[value=" + key + "]");
                option.html(value);
            });
        },

        _initTestSuitePanel: function() {
            var self = this;
            this._fetchAvailableTestSuites().done(function(fetchTestSuites) {
                self._fillTestSuiteComboBox(fetchTestSuites);
                self.reloadDataInView();
            });
        },

        _fillTestSuiteComboBox: function(availableTestSuites) {
            var testSuiteListBox = this.$el.find("#test-suite-listbox");
            _.each(availableTestSuites, function(testSuite) {
                testSuiteListBox.append("<option value='" + testSuite.id + "'></option>");
                var tsOption = testSuiteListBox.find('option[value=' + testSuite.id + ']');
                tsOption.html(testSuite.name);
            });
        },

        _fetchAvailableTestSuites: function() {

            var iterationId = this.model.get("replicationParameters").iterationId;

            return $.ajax({
                method: "GET",
                contentType: "application/json",
                url: squashtm.app.contextRoot + "iterations/" + iterationId + "/test-suites",
            });
        },

        // ISSUE PANEL

        _fillIssueComboBox: function() {
            var self = this;
            var bt = squashtm.wizard.bt;
            var keepIssued = $("#keep-issued-checkbox").is(":checked");
            if (keepIssued && (bt.kind === "jira.rest" || bt.kind === "jira.cloud")) {
                // Issue 7517
                var authBugTracker = {
                    serverId : bt.id,
                    protocol : bt.protocol,
                    status : bt.status
                }
                var logged = authmanager.get(authBugTracker).authenticate();
                $.when(logged).then(function() {
                    self._btLogSuccess();
                    self._initIssueMode(true);
                }).fail(function() {
                    self._btLogFail();
                });
            } else {
                $("#keep-issued-combobox").addClass("not-displayed");
                $("#keep-issued-switch").addClass("not-displayed");
            }
        },

        _initIssueMode: function(selectAll) {
            var activCbx = $("#toggle-activation-checkbox");
            this._initSwitchButton(activCbx);
            var isIssuesAllExecs = squashtm.wizard.isIssuesAllExecs;
            if (isIssuesAllExecs) {
                activCbx.switchButton({checked: true});
                this._initIssuePanelAllExecs(selectAll);
            }
            else {
                if ($("#toggle-activation-checkbox").prop('checked')) {
                    activCbx.switchButton({checked: false});
                } else {
                    activCbx.switchButton({checked: false});
                    this._initIssuePanel(selectAll);
                }
            }
        },

        _chooseIssueMode: function() {
            var isIssuesAllExecs = $("#toggle-activation-checkbox").prop('checked');
            if (isIssuesAllExecs) {
                squashtm.wizard.isIssuesAllExecs = true;
                this._initIssuePanelAllExecs(true);
            }
            else {
                squashtm.wizard.isIssuesAllExecs = false;
                this._initIssuePanel(true);
            }
        },

        _initIssuePanelAllExecs: function(selectAll) {
            var self = this;
            self._fetchAvailableIssues().done(function(fetchIssues) {
                self._initFillIssues(fetchIssues, selectAll);
            });
        },

        _initIssuePanel: function(selectAll) {
            var self = this;
            self._fetchAvailableIssuesOnlyLastExec().done(function(fetchIssues) {
                self._initFillIssues(fetchIssues, selectAll);
            });
        },

        _fillIssuesComboBox: function(availableIssues) {
            var self = this;
            var statusBox = $("#keep-issue-status-listbox"), priorityBox = $("#keep-issue-priority-listbox"), assigneeBox = $("#keep-issue-assignee-listbox");
            this._resetIssuesComboBox(statusBox, priorityBox, assigneeBox);
            var statuses = [], priorities = [], assignees = [];
            _.each(availableIssues, function(issue) {
                if (issue.status != null) {
                    var status = issue.status.scalar;
                    if (! _.contains(statuses, status) && status !== "--" && status != null) {
                        statuses.push(status);
                    }
                }
                if (issue.priority != null) {
                    var priority = issue.priority.scalar;
                    if (! _.contains(priorities, priority) && priority !== "--" && priority != null) {
                        priorities.push(priority);
                    }
                }
                if (issue.assignee != null) {
                    var assignee = issue.assignee.name;
                    if (! _.contains(assignees, assignee) && assignee !== "--" && assignee != null) {
                        assignees.push(assignee);
                    }
                }
            });
            self._createOptions(statuses, statusBox);
            self._createOptions(priorities, priorityBox);
            self._createOptions(assignees, assigneeBox);
        },

        _fetchAvailableIssues: function() {
            var iterationId = this.model.get("replicationParameters").iterationId;
            var serverId = squashtm.wizard.bt.id;
            return $.ajax({
                method: "GET",
                contentType: "application/json",
                url: squashtm.app.contextRoot + "campaign-assistant/iteration-replication/remote-issues",
                data: {
                    iterationId: iterationId,
                    serverId: serverId
                }
            });
        },

        _fetchAvailableIssuesOnlyLastExec: function() {
            var iterationId = this.model.get("replicationParameters").iterationId;
            var serverId = squashtm.wizard.bt.id;
            return $.ajax({
                method: "GET",
                contentType: "application/json",
                url: squashtm.app.contextRoot + "campaign-assistant/iteration-replication/remote-issues-last-exec",
                data: {
                    iterationId: iterationId,
                    serverId: serverId
                }
            });
        },


        _btLogSuccess: function() {
            $("#keep-issued-checkbox").prop('checked', true);
            squashtm.wizard.keepIssued = true;
            squashtm.wizard.bt.status = "AUTHENTICATED";
            squashtm.wizard.isIssuesAllExecs = false;
            $("#keep-issued-combobox").removeClass("not-displayed");
            $("#keep-issued-switch").removeClass("not-displayed");
        },

        _btLogFail: function() {
            $("#keep-issued-checkbox").prop('checked', false);
            squashtm.wizard.keepIssued = false;
            squashtm.wizard.bt.status = "NON_AUTHENTICATED";
        },

        _initSwitchButton: function(activCbx) {
            var activConf = attrparser.parse(activCbx.data('def'));
            activCbx.switchButton(activConf);
            // a bit of css tweak now for aligning label and switchButton
            $("#switch-button").css({position : 'relative', top : '8px'});
            activCbx.siblings('.switch-button-background').css({position : 'relative', top : '5px'});
        },

        _initFillIssues: function(fetchIssues, selectAll) {
            this._fillIssuesComboBox(fetchIssues);
            if (selectAll) {
                $("#keep-issue-status-listbox option").prop("selected", true);
                $("#keep-issue-priority-listbox option").prop("selected", true);
                $("#keep-issue-assignee-listbox option").prop("selected", true);
            } else {
                this.reloadDataInView();
            }
        },

        _resetIssuesComboBox: function(statusBox, priorityBox, assigneeBox) {
            statusBox.empty();
            priorityBox.empty();
            assigneeBox.empty();
        },

        _createOptions: function(items, itemBox) {
            items = _.sortBy(items, function(item) { return item.toLowerCase(); });
            _.each(items, function(item) {
                itemBox.append('<option value="' + item + '"></option>');
                var option = itemBox.find('option[value="' + item + '"]');
                option.html(item);
            });
        },


        _initUserTextbox: function() {
            var execUsers = this.model.get("executionUsers");
            var execUserText = this.$el.find('#exec-user-textbox');
            execUserText.searchMultiAutocompleteWidget({
                fieldId : 'exec-user-input-field',
             	options : execUsers
            });
        },

        _initExecDates: function() {
            var execDates = this.$el.find('#exec-date-inputs');
            execDates.searchDateWidget();
            execDates.searchDateWidget("createDom");
        },

        _toggleEntityPanelVisibility: function(event) {
            var entityClicked = event.target.id;
        	var entityPanelToToggle = $("#" + entityClicked + "-panel");
        	entityPanelToToggle.toggleClass("not-displayed");
        },

        /** Ajax Sync. method. Returns the promise to fetch the test plan based on the advanced criteria. */
        _loadPreviewTestPlan: function() {

            var advancedCriteria = this.model.get("advancedCriteria");

            var iterationId = this.model.get("replicationParameters").iterationId;
            var replicationParameters = this.model.get("replicationParameters");

            var advancedCriteria = {
                iterationId: iterationId,

                keepTestSuites: replicationParameters.keepTestSuites,
                keepAssignees: replicationParameters.keepAssignees,

                testCaseStatuses: advancedCriteria.testCaseStatuses || [],
                testCaseImportances: advancedCriteria.testCaseImportances || [],
                testCaseNatures: advancedCriteria.testCaseNatures || [],
                testCaseTypes: advancedCriteria.testCaseTypes || [],

                requirementCriticalities: advancedCriteria.requirementCriticalities || [],
                requirementStatuses: advancedCriteria.requirementStatuses || [],
                requirementCategories: advancedCriteria.requirementCategories || [],

                executionStatuses: advancedCriteria.executionStatuses || [],
                executionUsers: advancedCriteria.executionUsers || [],
                executionFromDate: advancedCriteria.executionFromDate,
                executionToDate: advancedCriteria.executionToDate,
                executionModes: advancedCriteria.executionModes || [],

                testSuites: advancedCriteria.testSuites || [],
                keepIssued: advancedCriteria.keepIssued,
                keepIssuedCriteria: advancedCriteria.keepIssuedCriteria,
                serverId: squashtm.wizard.bt.id,
                jiraServer: squashtm.wizard.bt.kind === 'jira.rest' || squashtm.wizard.bt.kind === 'jira.cloud',
                issuesAllExecs: advancedCriteria.issuesAllExecs
            }

            var dataString = JSON.stringify(advancedCriteria);

            return $.ajax({
                method: "POST",
                contentType: "application/json",
                url: squashtm.app.contextRoot + "campaign-assistant/iteration-replication/advanced-preview",
                data: dataString,
                async: false
            });
        },

        /** Updates the model with the test plan matching the advanced criteria in the model. */
        updateTestPlan: function(event) {
            var self = this;
            self._loadPreviewTestPlan().done(function(data) {
                self.model.set({
                    testPlan: data.aaData
                });
            });
        }

	});

	return advancedCriteriaStepView;

});