/*
 *     This file is part of the Campaign Assistant for Squash TM (henix-tm-wizard-campaignassistant) project.
 *     Copyright (C) 2017 Henix - All Rights Reserved
 *
 *     Unauthorized copying of this file, via any medium is strictly prohibited
 *     Proprietary and confidential
 *
 * 	 (C)Henix. Tous droits réservés.
 *
 * 	Avertissement : ce programme est protégé par la loi relative au droit d'auteur et par les conventions internationales. Toute reproduction ou distribution partielle ou totale du logiciel, par quelque moyen que ce soit, est strictement interdite.
 */
define([ "jquery", "backbone", "app/ws/squashtm.workspace", "workspace.routing",
         "./campaignAssistantWizardRouter", "./campaignAssistantWizardView", "./campaignAssistantWizardModel", 'jquery.squash.formdialog'],
         function($, Backbone, workspace, router, WizardRouter, WizardView, WizardModel) {

	function init() {
		$("#back-popup").confirmDialog().on('confirmdialogconfirm', function(){
			var url = router.buildURL('campaigns.workspace');
			window.location.href = url;
			});

		$("#back").on('click', function() {

			$("#back-popup").confirmDialog('open');
		});

		$(document).keyup(function(event) {
			if (event.keyCode == 13) {
                var keepIssued = $("#ISSUE").is(":checked");
				if($("#next").is(":visible")) {
				    $("#next").click();
				}
				else if($("#generate").is(":visible") && !keepIssued) {
				   $("#generate").click();
				}
			}
		});

		workspace.init();

		var data = {
			selectedNode: {
			    id: squashtm.wizard.selectedNode.id,
			    type: squashtm.wizard.selectedNode.type
			},
			executionStatuses: JSON.parse(squashtm.wizard.executionStatuses),
			executionUsers: squashtm.wizard.executionUsers,
			executionModes: JSON.parse(squashtm.wizard.executionModes),
			testCaseStatuses: JSON.parse(squashtm.wizard.testCaseStatuses),
			testCaseImportances: JSON.parse(squashtm.wizard.testCaseImportances),
			testCaseNatures: JSON.parse(squashtm.wizard.testCaseNatures),
			testCaseTypes: JSON.parse(squashtm.wizard.testCaseTypes),
			requirementCriticalities: JSON.parse(squashtm.wizard.requirementCriticalities),
			requirementStatuses: JSON.parse(squashtm.wizard.requirementStatuses),
			requirementCategories: JSON.parse(squashtm.wizard.requirementCategories)
		};

		var model = new WizardModel(data);

		var wizardView = new WizardView ({
			model: model
		});

		new WizardRouter({
			wizardView : wizardView
		});

		Backbone.history.start();
	}

	return {
		init : init
	};

});
