/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.jiracloud.internal.operations;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import jiracloud.com.atlassian.jira.rest.client.api.RestClientException;
import jiracloud.com.sun.ws.rs.core.UriBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.squashtest.tm.plugin.bugtracker.jiracloud.internal.extension.ExtendedJiraRestClient;
import org.squashtest.tm.plugin.bugtracker.jiracloud.internal.extension.ExtensionClient;
import org.squashtest.tm.plugin.bugtracker.jiracloud.internal.json.SimpleBoardIDListJsonParser;
import org.squashtest.tm.plugin.bugtracker.jiracloud.internal.json.SimpleSprint;
import org.squashtest.tm.plugin.bugtracker.jiracloud.internal.json.SimpleSprintListJsonParser;
import org.squashtest.tm.plugin.bugtracker.jiracloud.internal.operations.JiraRestClientOperation;

public class SearchSprints
extends JiraRestClientOperation<Iterable<SimpleSprint>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SearchSprints.class);
    private final String jiraCloudApiBaseUrl;
    private final SimpleBoardIDListJsonParser simpleBoardIDListJsonParser = new SimpleBoardIDListJsonParser();
    private final SimpleSprintListJsonParser simpleSprintListWithoutGreenHopperJsonParser = new SimpleSprintListJsonParser();

    public SearchSprints(ExtendedJiraRestClient extClient, String jiraCloudApiBaseUrl) {
        super(extClient);
        this.jiraCloudApiBaseUrl = jiraCloudApiBaseUrl;
    }

    @Override
    public Iterable<SimpleSprint> doIt() {
        ExtensionClient extension = this.client.getExtensionClient();
        URI baseURI = null;
        try {
            baseURI = new URI(this.jiraCloudApiBaseUrl);
        }
        catch (URISyntaxException e) {
            LOGGER.error("Bad URI syntax for Jira Cloud API '{}'", (Object)this.jiraCloudApiBaseUrl, (Object)e);
        }
        List<Long> boardIds = this.findBoardIds(extension, baseURI);
        return this.fetchAllSprints(boardIds, extension, baseURI);
    }

    private List<Long> findBoardIds(ExtensionClient extension, URI baseUrl) {
        URI boardsUri = UriBuilder.fromUri(String.valueOf(baseUrl) + "/rest/agile/1.0/board").build(new Object[0]);
        return extension.getAndParse(boardsUri, this.simpleBoardIDListJsonParser).claim();
    }

    private Iterable<SimpleSprint> fetchAllSprints(List<Long> boardIds, ExtensionClient extension, URI baseUrl) {
        ArrayList<SimpleSprint> sprints = new ArrayList<SimpleSprint>();
        List<CompletableFuture> futures = boardIds.parallelStream().map(boardId -> this.getAllSprintsForBoard((Long)boardId, extension, baseUrl)).collect(Collectors.toList());
        futures.forEach(future -> {
            try {
                sprints.addAll((Collection)future.get());
            }
            catch (InterruptedException | ExecutionException e) {
                LOGGER.error("Could not retrieve sprints", (Throwable)e);
            }
        });
        this.sortSimpleSprintByName(sprints);
        return sprints;
    }

    private CompletableFuture<List<SimpleSprint>> getAllSprintsForBoard(Long boardId, ExtensionClient extension, URI btUrl) {
        URI sprintsByBoardUri = UriBuilder.fromUri(String.valueOf(btUrl) + "/rest/agile/1.0/board/" + String.valueOf(boardId) + "/sprint").build(new Object[0]);
        try {
            return CompletableFuture.completedFuture(extension.getAndParse(sprintsByBoardUri, this.simpleSprintListWithoutGreenHopperJsonParser).claim());
        }
        catch (RestClientException e) {
            LOGGER.error("Could not retrieve sprints from Jira api", (Throwable)e);
            return CompletableFuture.completedFuture(new ArrayList());
        }
    }

    private void sortSimpleSprintByName(List<SimpleSprint> sprints) {
        sprints.sort(Comparator.comparing(SimpleSprint::getName));
    }
}

