/*
 * Decompiled with CFR 0.152.
 */
package jiracloud.org.apache.http.impl.io;

import java.io.IOException;
import jiracloud.org.apache.http.ConnectionClosedException;
import jiracloud.org.apache.http.HttpException;
import jiracloud.org.apache.http.HttpRequest;
import jiracloud.org.apache.http.HttpRequestFactory;
import jiracloud.org.apache.http.ParseException;
import jiracloud.org.apache.http.RequestLine;
import jiracloud.org.apache.http.config.MessageConstraints;
import jiracloud.org.apache.http.impl.DefaultHttpRequestFactory;
import jiracloud.org.apache.http.impl.io.AbstractMessageParser;
import jiracloud.org.apache.http.io.SessionInputBuffer;
import jiracloud.org.apache.http.message.LineParser;
import jiracloud.org.apache.http.message.ParserCursor;
import jiracloud.org.apache.http.params.HttpParams;
import jiracloud.org.apache.http.util.Args;
import jiracloud.org.apache.http.util.CharArrayBuffer;

public class DefaultHttpRequestParser
extends AbstractMessageParser<HttpRequest> {
    private final HttpRequestFactory requestFactory;
    private final CharArrayBuffer lineBuf;

    @Deprecated
    public DefaultHttpRequestParser(SessionInputBuffer buffer, LineParser lineParser, HttpRequestFactory requestFactory, HttpParams params) {
        super(buffer, lineParser, params);
        this.requestFactory = Args.notNull(requestFactory, "Request factory");
        this.lineBuf = new CharArrayBuffer(128);
    }

    public DefaultHttpRequestParser(SessionInputBuffer buffer, LineParser lineParser, HttpRequestFactory requestFactory, MessageConstraints constraints) {
        super(buffer, lineParser, constraints);
        this.requestFactory = requestFactory != null ? requestFactory : DefaultHttpRequestFactory.INSTANCE;
        this.lineBuf = new CharArrayBuffer(128);
    }

    public DefaultHttpRequestParser(SessionInputBuffer buffer, MessageConstraints constraints) {
        this(buffer, null, null, constraints);
    }

    public DefaultHttpRequestParser(SessionInputBuffer buffer) {
        this(buffer, null, null, MessageConstraints.DEFAULT);
    }

    @Override
    protected HttpRequest parseHead(SessionInputBuffer sessionBuffer) throws IOException, HttpException, ParseException {
        this.lineBuf.clear();
        int readLen = sessionBuffer.readLine(this.lineBuf);
        if (readLen == -1) {
            throw new ConnectionClosedException("Client closed connection");
        }
        ParserCursor cursor = new ParserCursor(0, this.lineBuf.length());
        RequestLine requestline = this.lineParser.parseRequestLine(this.lineBuf, cursor);
        return this.requestFactory.newHttpRequest(requestline);
    }
}

