/*
 * Decompiled with CFR 0.152.
 */
package jiracloud.org.apache.http.impl.conn;

import jiracloud.org.apache.http.HttpResponse;
import jiracloud.org.apache.http.HttpResponseFactory;
import jiracloud.org.apache.http.annotation.Contract;
import jiracloud.org.apache.http.annotation.ThreadingBehavior;
import jiracloud.org.apache.http.config.MessageConstraints;
import jiracloud.org.apache.http.impl.DefaultHttpResponseFactory;
import jiracloud.org.apache.http.impl.conn.DefaultHttpResponseParser;
import jiracloud.org.apache.http.io.HttpMessageParser;
import jiracloud.org.apache.http.io.HttpMessageParserFactory;
import jiracloud.org.apache.http.io.SessionInputBuffer;
import jiracloud.org.apache.http.message.BasicLineParser;
import jiracloud.org.apache.http.message.LineParser;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class DefaultHttpResponseParserFactory
implements HttpMessageParserFactory<HttpResponse> {
    public static final DefaultHttpResponseParserFactory INSTANCE = new DefaultHttpResponseParserFactory();
    private final LineParser lineParser;
    private final HttpResponseFactory responseFactory;

    public DefaultHttpResponseParserFactory(LineParser lineParser, HttpResponseFactory responseFactory) {
        this.lineParser = lineParser != null ? lineParser : BasicLineParser.INSTANCE;
        this.responseFactory = responseFactory != null ? responseFactory : DefaultHttpResponseFactory.INSTANCE;
    }

    public DefaultHttpResponseParserFactory(HttpResponseFactory responseFactory) {
        this(null, responseFactory);
    }

    public DefaultHttpResponseParserFactory() {
        this(null, null);
    }

    @Override
    public HttpMessageParser<HttpResponse> create(SessionInputBuffer buffer, MessageConstraints constraints) {
        return new DefaultHttpResponseParser(buffer, this.lineParser, this.responseFactory, constraints);
    }
}

