/*
 * Decompiled with CFR 0.152.
 */
package jiracloud.com.atlassian.jira.rest.client.internal.json.gen;

import jiracloud.com.atlassian.jira.rest.client.api.domain.BasicUser;
import jiracloud.com.atlassian.jira.rest.client.api.domain.Visibility;
import jiracloud.com.atlassian.jira.rest.client.api.domain.input.WorklogInput;
import jiracloud.com.atlassian.jira.rest.client.internal.json.JsonParseUtil;
import jiracloud.com.atlassian.jira.rest.client.internal.json.gen.BasicUserJsonGenerator;
import jiracloud.com.atlassian.jira.rest.client.internal.json.gen.JsonGenerator;
import jiracloud.com.atlassian.jira.rest.client.internal.json.gen.VisibilityJsonGenerator;
import jiracloud.org.codehaus.jettison.json.JSONException;
import jiracloud.org.codehaus.jettison.json.JSONObject;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;

public class WorklogInputJsonGenerator
implements JsonGenerator<WorklogInput> {
    private final JsonGenerator<Visibility> visibilityGenerator = new VisibilityJsonGenerator();
    private final JsonGenerator<BasicUser> basicUserJsonGenerator = new BasicUserJsonGenerator();
    private final DateTimeFormatter dateTimeFormatter;

    public WorklogInputJsonGenerator() {
        this(JsonParseUtil.JIRA_DATE_TIME_FORMATTER);
    }

    public WorklogInputJsonGenerator(DateTimeFormatter dateTimeFormatter) {
        this.dateTimeFormatter = dateTimeFormatter;
    }

    @Override
    public JSONObject generate(WorklogInput worklogInput) throws JSONException {
        JSONObject res = new JSONObject().put("self", worklogInput.getSelf()).put("comment", worklogInput.getComment()).put("started", this.dateTimeFormatter.print((ReadableInstant)worklogInput.getStartDate())).put("timeSpent", worklogInput.getMinutesSpent() + "m");
        this.putGeneratedIfNotNull("visibility", worklogInput.getVisibility(), res, this.visibilityGenerator);
        this.putGeneratedIfNotNull("author", worklogInput.getAuthor(), res, this.basicUserJsonGenerator);
        this.putGeneratedIfNotNull("updateAuthor", worklogInput.getUpdateAuthor(), res, this.basicUserJsonGenerator);
        return res;
    }

    private <K> JSONObject putGeneratedIfNotNull(String key, K value, JSONObject dest, JsonGenerator<K> generator) throws JSONException {
        if (value != null) {
            dest.put(key, generator.generate(value));
        }
        return dest;
    }
}

