/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.redminereq.domain;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.squashtest.tm.plugin.redminereq.domain.BuiltinSquashField;

public class FieldMapping {
    private static final List<FieldMapping> BUILTIN_MAPPING = new ArrayList<FieldMapping>();
    private String squashField;
    private String redmineField;
    private boolean locked;

    static {
        BUILTIN_MAPPING.add(new FieldMapping(BuiltinSquashField.REFERENCE, "id", true));
        BUILTIN_MAPPING.add(new FieldMapping(BuiltinSquashField.LABEL, "subject", true));
        BUILTIN_MAPPING.add(new FieldMapping(BuiltinSquashField.CRITICALITY, "priority", true));
        BUILTIN_MAPPING.add(new FieldMapping(BuiltinSquashField.DESCRIPTION, "description", true));
        BUILTIN_MAPPING.add(new FieldMapping(BuiltinSquashField.CATEGORY, "tracker", true));
        BUILTIN_MAPPING.add(new FieldMapping(BuiltinSquashField.STATUS, "status", true));
    }

    public FieldMapping() {
    }

    public FieldMapping(BuiltinSquashField squashField, String redmineField, boolean locked) {
        this.squashField = squashField.toString();
        this.redmineField = redmineField;
        this.locked = locked;
    }

    public FieldMapping(String squashFieldId, String redmineFieldId, boolean locked) {
        this.squashField = squashFieldId;
        this.redmineField = redmineFieldId;
        this.locked = locked;
    }

    public String getId() {
        return this.squashField;
    }

    public String getSquashField() {
        return this.squashField;
    }

    public void setSquashField(String squashField) {
        this.squashField = StringUtils.trim((String)squashField);
    }

    public String getRedmineField() {
        return this.redmineField;
    }

    public void setRedmineField(String redmineField) {
        this.redmineField = StringUtils.trim((String)redmineField);
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    public static List<FieldMapping> getBuiltinMapping() {
        return new ArrayList<FieldMapping>(BUILTIN_MAPPING);
    }

    public static FieldMapping byId(String id) {
        return new FieldMapping(id, null, false);
    }

    public String toString() {
        return this.squashField + "<->" + this.redmineField;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.squashField == null ? 0 : this.squashField.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FieldMapping other = (FieldMapping)obj;
        return !(this.squashField == null ? other.squashField != null : !this.squashField.equals(other.squashField));
    }
}

