/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.validators;

import jakarta.inject.Inject;
import java.util.ArrayList;
import org.springframework.stereotype.Component;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.BindException;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.plugin.rest.controller.helper.ErrorHandlerHelper;
import org.squashtest.tm.plugin.rest.jackson.model.CampaignFolderDto;
import org.squashtest.tm.plugin.rest.jackson.model.RestType;
import org.squashtest.tm.plugin.rest.validators.helper.CampaignFolderDtoValidationHelper;

@Component
public class CampaignFolderPatchValidator
implements Validator {
    private static final String PATCH_CAMPAIGN_FOLDER = "patch-campaign-folder";
    @Inject
    private CampaignFolderDtoValidationHelper campaignFolderDtoValidationHelper;

    public boolean supports(Class<?> clazz) {
        return CampaignFolderDto.class.equals(clazz);
    }

    public void validate(Object target, Errors errors) {
        CampaignFolderDto folderPatch = (CampaignFolderDto)target;
        this.campaignFolderDtoValidationHelper.checkEntityExist(errors, RestType.CAMPAIGN_FOLDER, folderPatch.getId());
        this.campaignFolderDtoValidationHelper.loadProject(folderPatch);
        this.campaignFolderDtoValidationHelper.checkParent(errors, folderPatch, RestType.CAMPAIGN_FOLDER);
        this.campaignFolderDtoValidationHelper.checkCufs(errors, folderPatch, BindableEntity.CAMPAIGN_FOLDER);
    }

    public void validatePatchCampaignFolder(CampaignFolderDto patch) throws BindException {
        ArrayList<Errors> errors = new ArrayList<Errors>();
        BeanPropertyBindingResult validation = new BeanPropertyBindingResult((Object)patch, PATCH_CAMPAIGN_FOLDER);
        this.validate(patch, (Errors)validation);
        if (validation.hasErrors()) {
            errors.add((Errors)validation);
        }
        ErrorHandlerHelper.throwIfError(patch, errors, PATCH_CAMPAIGN_FOLDER);
    }
}

