/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.service.impl;

import jakarta.inject.Inject;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityNotFoundException;
import jakarta.persistence.PersistenceContext;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jooq.DSLContext;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.springframework.context.MessageSource;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.BindException;
import org.squashtest.tm.api.security.acls.Permissions;
import org.squashtest.tm.core.foundation.lang.Wrapped;
import org.squashtest.tm.domain.customfield.BoundEntity;
import org.squashtest.tm.domain.customfield.RawValue;
import org.squashtest.tm.domain.infolist.InfoListItem;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.scm.ScmRepository;
import org.squashtest.tm.domain.testautomation.AutomatedTestTechnology;
import org.squashtest.tm.domain.testcase.ActionTestStep;
import org.squashtest.tm.domain.testcase.CallTestStep;
import org.squashtest.tm.domain.testcase.Dataset;
import org.squashtest.tm.domain.testcase.DatasetParamValue;
import org.squashtest.tm.domain.testcase.ExploratoryTestCase;
import org.squashtest.tm.domain.testcase.KeywordTestCase;
import org.squashtest.tm.domain.testcase.KeywordTestStep;
import org.squashtest.tm.domain.testcase.Parameter;
import org.squashtest.tm.domain.testcase.ScriptedTestCase;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestCaseFolder;
import org.squashtest.tm.domain.testcase.TestCaseVisitor;
import org.squashtest.tm.domain.testcase.TestStep;
import org.squashtest.tm.domain.tf.automationrequest.AutomationRequestStatus;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.plugin.rest.jackson.model.ActionTestStepDto;
import org.squashtest.tm.plugin.rest.jackson.model.CalledTestStepDto;
import org.squashtest.tm.plugin.rest.jackson.model.CustomFieldValueDto;
import org.squashtest.tm.plugin.rest.jackson.model.DatasetDto;
import org.squashtest.tm.plugin.rest.jackson.model.DatasetParamValueDto;
import org.squashtest.tm.plugin.rest.jackson.model.ExploratoryTestCaseDto;
import org.squashtest.tm.plugin.rest.jackson.model.KeywordTestCaseDto;
import org.squashtest.tm.plugin.rest.jackson.model.KeywordTestStepDto;
import org.squashtest.tm.plugin.rest.jackson.model.ParentEntity;
import org.squashtest.tm.plugin.rest.jackson.model.RequirementVersionDto;
import org.squashtest.tm.plugin.rest.jackson.model.ScriptedTestCaseDto;
import org.squashtest.tm.plugin.rest.jackson.model.TestCaseDto;
import org.squashtest.tm.plugin.rest.jackson.model.TestCaseDtoVisitor;
import org.squashtest.tm.plugin.rest.jackson.model.TestStepDto;
import org.squashtest.tm.plugin.rest.jackson.model.TestStepDtoVisitor;
import org.squashtest.tm.plugin.rest.repository.RestTestCaseRepository;
import org.squashtest.tm.plugin.rest.service.RestInternalCustomFieldValueUpdaterService;
import org.squashtest.tm.plugin.rest.service.RestRequirementVersionService;
import org.squashtest.tm.plugin.rest.service.RestTestCaseService;
import org.squashtest.tm.plugin.rest.service.helper.CustomFieldValueHelper;
import org.squashtest.tm.plugin.rest.service.impl.KeywordTestStepPatcher;
import org.squashtest.tm.plugin.rest.service.impl.TestCasePatcher;
import org.squashtest.tm.plugin.rest.utils.PaginationUtils;
import org.squashtest.tm.plugin.rest.validators.TestCasePatchValidator;
import org.squashtest.tm.service.deletion.SuppressionPreviewReport;
import org.squashtest.tm.service.internal.repository.InfoListItemDao;
import org.squashtest.tm.service.project.ProjectFinder;
import org.squashtest.tm.service.requirement.VerifiedRequirementsManagerService;
import org.squashtest.tm.service.security.PermissionEvaluationService;
import org.squashtest.tm.service.testautomation.AutomatedTestTechnologyFinderService;
import org.squashtest.tm.service.testcase.ParameterModificationService;
import org.squashtest.tm.service.testcase.TestCaseLibraryNavigationService;
import org.squashtest.tm.service.testcase.TestCaseModificationService;

@Service
@Transactional
public class RestTestCaseServiceImpl
implements RestTestCaseService {
    @Inject
    private TestCasePatcher testCasePatcher;
    @Inject
    private KeywordTestStepPatcher keywordTestStepPatcher;
    @Inject
    private InfoListItemDao infoListItemDao;
    @Inject
    private TestCaseModificationService testCaseModificationService;
    @Inject
    private VerifiedRequirementsManagerService verifiedRequirementsManagerService;
    @Inject
    private RestRequirementVersionService requirementVersionService;
    @Inject
    private ProjectFinder projectFinder;
    @Inject
    private RestTestCaseRepository dao;
    @Inject
    private ParameterModificationService parameterModificationService;
    @Inject
    private TestCaseLibraryNavigationService testCaseLibraryNavigationService;
    @Inject
    private RestInternalCustomFieldValueUpdaterService internalCufService;
    @Inject
    private CustomFieldValueHelper customFieldValueConverter;
    @Inject
    private PermissionEvaluationService permissionService;
    @Inject
    private TestCasePatchValidator testCasePatchValidator;
    @Inject
    private AutomatedTestTechnologyFinderService automatedTestTechnologyFinderService;
    @Inject
    private MessageSource messageSource;
    @Inject
    private DSLContext dslContext;
    @PersistenceContext
    private EntityManager entityManager;

    @Override
    public TestCase getOne(Long id) {
        return this.testCaseModificationService.findById(id.longValue());
    }

    @Override
    @Transactional(readOnly=true)
    public Page<TestCase> getAllReadableTestCases(Pageable pageable) {
        Collection<Long> ids = this.getAllProjectIds();
        return ids.isEmpty() ? PaginationUtils.emptyPage(pageable) : this.dao.findAllInProjects(ids, pageable);
    }

    @Override
    @Transactional(readOnly=true)
    @PreAuthorize(value="@apiSecurity.hasPermission(#tcid,'org.squashtest.tm.domain.testcase.TestCase' , 'READ')")
    public Page<TestStep> getTestCaseSteps(long tcid, Pageable pageable) {
        return this.dao.findTestCaseSteps(tcid, pageable);
    }

    @Override
    public TestCase createTestCase(TestCaseDto testCaseDto) throws InvocationTargetException, IllegalAccessException, BindException {
        String testCaseName = testCaseDto.getName();
        TestCase testCase = TestCaseDto.convertDto(testCaseDto);
        testCase.setName(testCaseName);
        this.fillDefaultValues(testCaseDto);
        this.testCasePatcher.patch(testCase, testCaseDto);
        this.patchAutomationAttributes(testCaseDto, testCase);
        this.addToParent(testCaseDto, testCase);
        this.entityManager.persist((Object)testCase);
        this.entityManager.flush();
        this.createSteps(testCaseDto, testCase);
        this.createParameters(testCaseDto, testCase);
        this.createDatasets(testCaseDto, testCase);
        this.addOrMergeVerifiedRequirements(testCaseDto, testCase);
        return testCase;
    }

    @Override
    @PreAuthorize(value="@apiSecurity.hasPermission(#id,'org.squashtest.tm.domain.testcase.TestCase' , 'WRITE')")
    public TestCase patchTestCase(TestCaseDto testCasePatch, long id) {
        TestCase testCase = this.dao.retrieveById(id);
        if (StringUtils.isNotBlank((CharSequence)testCasePatch.getName())) {
            this.testCaseModificationService.rename(testCase.getId().longValue(), testCasePatch.getName());
        }
        this.testCasePatcher.patch(testCase, testCasePatch);
        this.patchTypeSpecificAttributesIfExist(testCasePatch, testCase);
        this.patchAutomationAttributes(testCasePatch, testCase);
        this.internalCufService.mergeCustomFields((BoundEntity)testCase, testCasePatch.getCustomFields());
        return testCase;
    }

    private void patchAutomationAttributes(TestCaseDto testCasePatch, TestCase testCase) {
        if (testCasePatch.getAutomatedTestTechnology() != null) {
            AutomatedTestTechnology techno = this.automatedTestTechnologyFinderService.findByNameIgnoreCase(testCasePatch.getAutomatedTestTechnology());
            testCase.setAutomatedTestTechnology(techno);
        }
        if (testCasePatch.getScmRepositoryId() != null) {
            ScmRepository repo = (ScmRepository)this.entityManager.find(ScmRepository.class, (Object)testCasePatch.getScmRepositoryId());
            testCase.setScmRepository(repo);
        }
        if (testCasePatch.getAutomatable() != null) {
            this.testCaseModificationService.changeAutomatable(testCasePatch.getAutomatable(), testCase.getId());
        }
        if (testCasePatch.getAutomationPriority() != null) {
            this.testCaseModificationService.changeAutomationPriority(testCase.getId().longValue(), testCasePatch.getAutomationPriority());
        }
        if (testCasePatch.getAutomationStatus() != null) {
            testCase.getAutomationRequest().setRequestStatus(testCasePatch.getAutomationStatus());
            if (AutomationRequestStatus.AUTOMATED.equals((Object)testCase.getAutomationRequest().getRequestStatus())) {
                testCase.getAutomationRequest().setTransmissionDate(new Date());
            }
        }
    }

    private void patchTypeSpecificAttributesIfExist(final TestCaseDto testCasePatch, TestCase testCase) {
        TestCaseVisitor testCaseVisitor = new TestCaseVisitor(){

            public void visit(TestCase testCase) {
            }

            public void visit(KeywordTestCase keywordTestCase) {
            }

            public void visit(ExploratoryTestCase exploratoryTestCase) {
                RestTestCaseServiceImpl.this.patchExploratoryTestCaseAttributes(exploratoryTestCase, testCasePatch);
            }

            public void visit(ScriptedTestCase scriptedTestCase) {
                RestTestCaseServiceImpl.this.patchScriptedTestCaseAttributes(scriptedTestCase, testCasePatch);
            }
        };
        testCase.accept(testCaseVisitor);
    }

    @Override
    public List<String> deleteTestCase(List<Long> testCaseIds, Boolean dryRun, Locale locale) {
        this.permissionService.checkPermission(testCaseIds, Permissions.DELETE.name(), TestCase.class.getName());
        List<SuppressionPreviewReport> reports = this.testCasePatchValidator.simulationDelete(testCaseIds);
        if (dryRun == null || !dryRun.booleanValue()) {
            this.testCaseLibraryNavigationService.deleteNodes(testCaseIds);
        }
        ArrayList<String> reportMessages = new ArrayList<String>(reports.size());
        for (SuppressionPreviewReport report : reports) {
            reportMessages.add(report.toString(this.messageSource, locale));
        }
        return reportMessages;
    }

    @Override
    @Transactional(readOnly=true)
    public Page<TestCase> getAllStandardTestCases(Pageable paging) {
        Collection<Long> ids = this.getAllProjectIds();
        return ids.isEmpty() ? PaginationUtils.emptyPage(paging) : this.dao.findAllStandardTestCasesInProject(ids, paging);
    }

    private Collection<Long> getAllProjectIds() {
        return this.projectFinder.findReadableProjectIdsOnTestCaseLibrary();
    }

    @Override
    @Transactional(readOnly=true)
    public Page<TestCase> getAllScriptedTestCases(Pageable paging) {
        Collection<Long> ids = this.getAllProjectIds();
        return ids.isEmpty() ? PaginationUtils.emptyPage(paging) : this.dao.findAllScriptedTestCasesInProject(ids, paging);
    }

    @Override
    @Transactional(readOnly=true)
    public Page<TestCase> getAllKeywordTestCases(Pageable paging) {
        Collection<Long> ids = this.getAllProjectIds();
        return ids.isEmpty() ? PaginationUtils.emptyPage(paging) : this.dao.findAllKeywordTestCasesInProject(ids, paging);
    }

    @Override
    @Transactional(readOnly=true)
    public Page<TestCase> getAllExploratoryTestCases(Pageable paging) {
        Collection<Long> ids = this.getAllProjectIds();
        return ids.isEmpty() ? PaginationUtils.emptyPage(paging) : this.dao.findAllExploratoryTestCasesInProject(ids, paging);
    }

    private void fillDefaultValues(TestCaseDto testCaseDto) {
        InfoListItem nature;
        Project project = testCaseDto.getProject();
        if (testCaseDto.getNature() == null) {
            nature = this.infoListItemDao.findDefaultTestCaseNature(project.getId().longValue());
            testCaseDto.setNature(nature);
        }
        if (testCaseDto.getType() == null) {
            nature = this.infoListItemDao.findDefaultTestCaseType(project.getId().longValue());
            testCaseDto.setType(nature);
        }
    }

    private void addToParent(TestCaseDto testCaseDto, TestCase testCase) {
        ParentEntity parent = testCaseDto.getParent();
        switch (parent.getRestType()) {
            case PROJECT: {
                this.addTestCaseToLibrary(testCase, testCaseDto, parent);
                break;
            }
            case TEST_CASE_FOLDER: {
                this.addTestCaseToFolder(testCase, testCaseDto, parent);
                break;
            }
            default: {
                throw new IllegalArgumentException("Programmatic error : Rest type " + String.valueOf((Object)parent.getRestType()) + "is not a valid parent. You should validate this before.");
            }
        }
    }

    private void addTestCaseToFolder(TestCase testCase, TestCaseDto testCaseDto, ParentEntity parent) {
        TestCaseFolder testCaseFolder = (TestCaseFolder)this.entityManager.find(TestCaseFolder.class, (Object)parent.getId());
        if (testCaseFolder == null) {
            throw new IllegalArgumentException("Programmatic error : test case folder with id " + String.valueOf(parent.getId()) + "is unknown. You should validate this before.");
        }
        Map<Long, RawValue> customFieldMap = this.customFieldValueConverter.convertCustomFieldDtoToMap(testCaseDto.getCustomFields());
        this.testCaseLibraryNavigationService.addTestCaseToFolder(testCaseFolder.getId().longValue(), testCase, customFieldMap, null, new ArrayList());
    }

    private void addTestCaseToLibrary(TestCase testCase, TestCaseDto testCaseDto, ParentEntity parent) {
        Project project = (Project)this.entityManager.find(Project.class, (Object)parent.getId());
        if (project == null) {
            throw new IllegalArgumentException("Programmatic error : project with id " + String.valueOf(parent.getId()) + "is unknown. You should validate this before.");
        }
        Map<Long, RawValue> customFieldMap = this.customFieldValueConverter.convertCustomFieldDtoToMap(testCaseDto.getCustomFields());
        this.testCaseLibraryNavigationService.addTestCaseToLibrary(project.getTestCaseLibrary().getId().longValue(), testCase, customFieldMap, null, new ArrayList());
    }

    private void createDatasetParamValues(TestCase testCase, DatasetDto datasetDto, Dataset newDataset) {
        Set<DatasetParamValueDto> datasetParamValues = datasetDto.getValueDtos();
        List parameters = this.parameterModificationService.findAllParameters(testCase.getId().longValue());
        for (Parameter param : parameters) {
            String newValue = "";
            for (DatasetParamValueDto valueDto : datasetParamValues) {
                if (!valueDto.getParameterName().equals(param.getName())) continue;
                newValue = valueDto.getValue();
                datasetParamValues.remove(valueDto);
                break;
            }
            new DatasetParamValue(param, newDataset, newValue);
        }
        if (!datasetParamValues.isEmpty()) {
            throw new IllegalArgumentException("Error in parameter_values : parameter name '" + datasetParamValues.iterator().next().getParameterName() + "' must exist and be posted only once.");
        }
    }

    private void createParameters(TestCaseDto testCaseDto, TestCase testCase) {
        if (testCaseDto.getParameters() == null) {
            return;
        }
        for (Parameter parameter : testCaseDto.getParameters()) {
            Parameter detachedCopy = parameter.detachedCopy();
            detachedCopy.setTestCase(testCase);
        }
    }

    private void createSteps(TestCaseDto testCaseDto, TestCase testCase) throws BindException {
        if (testCaseDto.getSteps() == null) {
            return;
        }
        List<TestStepDto> stepDtos = testCaseDto.getSteps();
        for (TestStepDto stepDto : stepDtos) {
            this.createStep(testCase, stepDto);
        }
    }

    private void createStep(final TestCase testCase, TestStepDto stepDto) throws BindException {
        final TestStep testStep = TestStepDto.convertDto(stepDto);
        testStep.setTestCase(testCase);
        TestStepDtoVisitor visitor = new TestStepDtoVisitor(){

            @Override
            public void visit(ActionTestStepDto actionTestStepDto) {
                List<CustomFieldValueDto> customFieldValueDtos = actionTestStepDto.getCustomFields();
                Map<Long, RawValue> customFieldRawValues = RestTestCaseServiceImpl.this.customFieldValueConverter.convertCustomFieldDtoToMap(customFieldValueDtos);
                RestTestCaseServiceImpl.this.testCaseModificationService.addActionTestStep(testCase.getId().longValue(), (ActionTestStep)testStep, customFieldRawValues);
            }

            @Override
            public void visit(CalledTestStepDto calledTestStepDto) {
                CallTestStep callTestStep = (CallTestStep)testStep;
                testCase.addStep((TestStep)callTestStep);
            }

            @Override
            public void visit(KeywordTestStepDto keywordTestStepDto) {
                KeywordTestStep createdKeywordTestStep = RestTestCaseServiceImpl.this.testCaseModificationService.addKeywordTestStep(testCase.getId().longValue(), keywordTestStepDto.getKeyword().name(), keywordTestStepDto.getAction());
                RestTestCaseServiceImpl.this.keywordTestStepPatcher.patch(createdKeywordTestStep, keywordTestStepDto);
            }
        };
        stepDto.accept(visitor);
    }

    private void createDatasets(TestCaseDto testCaseDto, TestCase testCase) {
        if (testCaseDto.getDatasets() == null) {
            return;
        }
        for (DatasetDto dataset : testCaseDto.getDatasets()) {
            if (!DatasetDto.class.isAssignableFrom(dataset.getClass())) continue;
            DatasetDto datasetDto = dataset;
            Dataset newDataset = new Dataset(datasetDto.getName(), testCase);
            this.createDatasetParamValues(testCase, datasetDto, newDataset);
        }
    }

    private void addOrMergeVerifiedRequirements(TestCaseDto testCaseDto, TestCase testCase) {
        if (testCaseDto.getVerifiedRequirements() == null) {
            return;
        }
        List<Long> reqVerIds = testCaseDto.getVerifiedRequirements().stream().map(RequirementVersionDto::getId).collect(Collectors.toList());
        List<Long> verifReqIds = this.requirementVersionService.findReqIdsByVersionIds(reqVerIds);
        this.verifiedRequirementsManagerService.addVerifiedRequirementsToTestCase(verifReqIds, testCase.getId().longValue());
    }

    private void patchExploratoryTestCaseAttributes(ExploratoryTestCase exploratoryTestCase, TestCaseDto testCasePatch) {
        int newSessionDuration;
        final Wrapped charterWrapped = new Wrapped(null);
        final Wrapped sessionDurationWrapped = new Wrapped(null);
        TestCaseDtoVisitor dtoVisitor = new TestCaseDtoVisitor(){

            @Override
            public void visit(TestCaseDto testCaseDto) {
            }

            @Override
            public void visit(ScriptedTestCaseDto scriptedTestCaseDto) {
            }

            @Override
            public void visit(KeywordTestCaseDto keywordTestCaseDto) {
            }

            @Override
            public void visit(ExploratoryTestCaseDto exploratoryTestCaseDto) {
                charterWrapped.setValue((Object)exploratoryTestCaseDto.getCharter());
                sessionDurationWrapped.setValue((Object)exploratoryTestCaseDto.getSessionDuration());
            }
        };
        testCasePatch.accept(dtoVisitor);
        String newCharter = (String)charterWrapped.getValue();
        if (newCharter != null) {
            exploratoryTestCase.setCharter(newCharter);
        }
        if ((newSessionDuration = ((Integer)sessionDurationWrapped.getValue()).intValue()) != exploratoryTestCase.getSessionDuration()) {
            exploratoryTestCase.setSessionDuration(Integer.valueOf(newSessionDuration));
        }
    }

    private void patchScriptedTestCaseAttributes(ScriptedTestCase scriptedTestCase, TestCaseDto testCasePatch) {
        final Wrapped scriptWrapped = new Wrapped(null);
        TestCaseDtoVisitor dtoVisitor = new TestCaseDtoVisitor(){

            @Override
            public void visit(TestCaseDto testCaseDto) {
            }

            @Override
            public void visit(ScriptedTestCaseDto scriptedTestCaseDto) {
                scriptWrapped.setValue((Object)scriptedTestCaseDto.getScript());
            }

            @Override
            public void visit(KeywordTestCaseDto keywordTestCaseDto) {
            }

            @Override
            public void visit(ExploratoryTestCaseDto exploratoryTestCaseDto) {
            }
        };
        testCasePatch.accept(dtoVisitor);
        String newScript = (String)scriptWrapped.getValue();
        if (newScript != null) {
            scriptedTestCase.setScript(newScript);
        }
    }

    @Override
    @PreAuthorize(value="@apiSecurity.hasPermission(#testCaseId,'org.squashtest.tm.domain.testcase.TestCase' , 'READ')")
    public List<Long> getExecutionIdsByTestCase(Long testCaseId) {
        TestCase testCase = (TestCase)this.entityManager.find(TestCase.class, (Object)testCaseId);
        if (testCase == null) {
            throw new EntityNotFoundException("Test case with id " + String.valueOf(testCaseId) + " does not exist.");
        }
        return this.dslContext.select((SelectField)Tables.EXECUTION.EXECUTION_ID).from((TableLike)Tables.EXECUTION).where(Tables.EXECUTION.TCLN_ID.eq((Object)testCaseId)).fetchInto(Long.class);
    }
}

