/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.service.impl;

import jakarta.inject.Inject;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityNotFoundException;
import jakarta.persistence.PersistenceContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.Name;
import org.jooq.Select;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.api.security.acls.Permissions;
import org.squashtest.tm.domain.customfield.RawValue;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.requirement.HighLevelNewRequirementVersionDto;
import org.squashtest.tm.domain.requirement.NewRequirementVersionDto;
import org.squashtest.tm.domain.requirement.Requirement;
import org.squashtest.tm.domain.requirement.RequirementFolder;
import org.squashtest.tm.domain.requirement.RequirementLibrary;
import org.squashtest.tm.domain.requirement.RequirementLibraryNode;
import org.squashtest.tm.domain.requirement.RequirementSyncExtender;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.jooq.domain.tables.RequirementVersion;
import org.squashtest.tm.plugin.rest.core.exception.IllegalPremiumFeatureAccessException;
import org.squashtest.tm.plugin.rest.jackson.model.ParentEntity;
import org.squashtest.tm.plugin.rest.jackson.model.RemoteReqInfoRecord;
import org.squashtest.tm.plugin.rest.jackson.model.RequirementDto;
import org.squashtest.tm.plugin.rest.jackson.model.RequirementVersionDto;
import org.squashtest.tm.plugin.rest.jackson.model.RestType;
import org.squashtest.tm.plugin.rest.repository.RestRequirementRepository;
import org.squashtest.tm.plugin.rest.repository.RestRequirementSyncExtenderRepository;
import org.squashtest.tm.plugin.rest.repository.RestRequirementVersionRepository;
import org.squashtest.tm.plugin.rest.service.RestRequirementVersionService;
import org.squashtest.tm.plugin.rest.service.helper.CustomFieldValueHelper;
import org.squashtest.tm.plugin.rest.service.impl.RequirementVersionPatcher;
import org.squashtest.tm.plugin.rest.utils.PaginationUtils;
import org.squashtest.tm.service.internal.repository.hibernate.ProjectDaoImpl;
import org.squashtest.tm.service.plugin.PluginFinderService;
import org.squashtest.tm.service.project.ProjectFinder;
import org.squashtest.tm.service.requirement.RequirementLibraryNavigationService;
import org.squashtest.tm.service.requirement.RequirementVersionManagerService;
import org.squashtest.tm.service.user.UserAccountService;

@Service
@Transactional
public class RestRequirementVersionServiceImpl
implements RestRequirementVersionService {
    private static final String WRONG_PARENT_REST_TYPE_ERROR_MESSAGE = "Rest type %s is not a valid parent. You should validate this before.";
    public static final String MAX_VERSIONS = "MAX_VERSIONS";
    public static final String REQUIREMENT_ID = "REQUIREMENT_ID";
    public static final String MAX_VERSION_NUMBER = "MAX_VERSION_NUMBER";
    @Inject
    private ProjectFinder projectFinder;
    @Inject
    private RequirementVersionManagerService service;
    @Inject
    private RestRequirementRepository reqDao;
    @Inject
    private RestRequirementVersionRepository reqVerRepository;
    @Inject
    private RestRequirementSyncExtenderRepository syncExtenderDao;
    @Inject
    private RequirementLibraryNavigationService requirementLibraryNavigationService;
    @Inject
    private CustomFieldValueHelper customFieldValueConverter;
    @Inject
    private RestRequirementRepository restRequirementRepository;
    @Inject
    private RequirementVersionPatcher requirementVersionPatcher;
    @Inject
    private UserAccountService userAccountService;
    @Inject
    private ProjectDaoImpl projectDaoImpl;
    @PersistenceContext
    private EntityManager entityManager;
    @Inject
    private DSLContext dslContext;
    @Inject
    private PluginFinderService pluginFinderService;

    @Override
    @Transactional(readOnly=true)
    public Page<Requirement> findAllReadable(Pageable paging) {
        List projectIds = this.projectFinder.findReadableProjectIdsOnRequirementLibrary();
        return projectIds.isEmpty() ? PaginationUtils.emptyPage(paging) : this.reqDao.findAllInProjects(projectIds, paging);
    }

    @Override
    @Transactional(readOnly=true)
    @PreAuthorize(value="@apiSecurity.hasPermission(#requirementId,'org.squashtest.tm.domain.requirement.Requirement' , 'READ')")
    public Requirement findRequirement(long requirementId) {
        return this.service.findRequirementById(requirementId);
    }

    @Override
    @Transactional(readOnly=true)
    @PreAuthorize(value="@apiSecurity.hasPermission(#requirementId,'org.squashtest.tm.domain.requirement.Requirement' , 'READ')")
    public Page<Requirement> findRequirementChildren(long requirementId, Pageable paging) {
        return this.reqDao.findRequirementChildren(requirementId, paging);
    }

    @Override
    @Transactional(readOnly=true)
    @PreAuthorize(value="@apiSecurity.hasPermission(#requirementId,'org.squashtest.tm.domain.requirement.Requirement' , 'READ')")
    public Page<Requirement> findRequirementAllChildren(long requirementId, Pageable paging) {
        return this.reqDao.findRequirementAllChildren(requirementId, paging);
    }

    @Override
    @Transactional(readOnly=true)
    public org.squashtest.tm.domain.requirement.RequirementVersion findRequirementVersion(long versionId) {
        return this.service.findById(versionId);
    }

    @Override
    public Requirement createRequirement(RequirementDto requirementDto, Boolean highLevel) throws IllegalPremiumFeatureAccessException {
        if (highLevel.booleanValue()) {
            if (!this.pluginFinderService.isPremiumPluginInstalled()) {
                throw new IllegalPremiumFeatureAccessException();
            }
            HighLevelNewRequirementVersionDto highLevelNewRequirementVersionDto = this.convertRequirementDtoToNewHighLevelRequirementVersionDto(requirementDto);
            return this.addToParent(requirementDto, (NewRequirementVersionDto)highLevelNewRequirementVersionDto);
        }
        NewRequirementVersionDto newRequirementVersionDto = this.convertRequirementDtoToNewRequirementVersionDto(requirementDto);
        return this.addToParent(requirementDto, newRequirementVersionDto);
    }

    @Override
    public void deleteRequirements(List<Long> reqIds) {
        this.requirementLibraryNavigationService.deleteNodes(reqIds);
    }

    @Override
    @Transactional(readOnly=true)
    public List<Requirement> findSynchronizedRequirementsBy(String remoteKey, String serverName) {
        Collection<RequirementSyncExtender> extenders = this.syncExtenderDao.findAllByRemoteReqIdAndServerName(remoteKey, serverName);
        if (!this.userAccountService.findCurrentUserDto().isAdmin()) {
            List<Long> accessibleRequirementLibraryIds = this.findAllRequirementLibraryIdsByPermission(this.userAccountService.findCurrentUserDto().getPartyIds(), Permissions.READ.getMask());
            extenders = extenders.stream().filter(ex -> accessibleRequirementLibraryIds.contains(ex.getRequirement().getLibrary().getId())).toList();
        }
        return extenders.stream().map(RequirementSyncExtender::getRequirement).toList();
    }

    @Override
    public List<Long> findReqIdsByVersionIds(List<Long> versionIds) {
        return this.reqVerRepository.findRequirementIdsByRequirementVersionIds(versionIds);
    }

    @Override
    public org.squashtest.tm.domain.requirement.RequirementVersion createRequirementVersion(long requirementId, boolean inheritReqLinks, boolean inheritTestcasesReqLinks) {
        this.service.createNewVersion(requirementId, inheritReqLinks, inheritTestcasesReqLinks);
        Requirement currentRequirement = (Requirement)this.reqDao.getReferenceById(requirementId);
        return currentRequirement.getCurrentVersion();
    }

    @Override
    @PreAuthorize(value="@apiSecurity.hasPermission(#versionId,'org.squashtest.tm.domain.requirement.RequirementVersion' , 'WRITE')")
    public org.squashtest.tm.domain.requirement.RequirementVersion modifyRequirementVersion(RequirementVersionDto requirementVersionDto, Long versionId) {
        org.squashtest.tm.domain.requirement.RequirementVersion reqVersion = this.service.findById(versionId.longValue());
        this.requirementVersionPatcher.patch(reqVersion, requirementVersionDto);
        if (requirementVersionDto.isHasCufs()) {
            this.requirementVersionPatcher.patchCustomFieldValue(requirementVersionDto, reqVersion);
        }
        return reqVersion;
    }

    @Override
    @PreAuthorize(value="@apiSecurity.hasPermission(#requirementId,'org.squashtest.tm.domain.requirement.Requirement' , 'WRITE')")
    public Requirement modifyRequirement(RequirementDto requirementDto, Long requirementId) {
        Requirement requirement = (Requirement)this.restRequirementRepository.getReferenceById(requirementId);
        org.squashtest.tm.domain.requirement.RequirementVersion reqVersion = requirement.getCurrentVersion();
        this.requirementVersionPatcher.patch(reqVersion, requirementDto.getCurrentVersion());
        if (requirementDto.getCurrentVersion().isHasCufs()) {
            this.requirementVersionPatcher.patchCustomFieldValue(requirementDto.getCurrentVersion(), reqVersion);
        }
        return requirement;
    }

    @Override
    public Long findCurrentVersionIdByRequirementId(Long requirementId) {
        Long currentVersionId = (Long)this.dslContext.select((SelectField)Tables.REQUIREMENT.CURRENT_VERSION_ID).from((TableLike)Tables.REQUIREMENT).where(Tables.REQUIREMENT.RLN_ID.eq((Object)requirementId)).fetchOneInto(Long.class);
        if (currentVersionId == null) {
            throw new EntityNotFoundException("Try to retrieve Requirement with given id: %d, but could not find it".formatted(requirementId));
        }
        return currentVersionId;
    }

    @Override
    public List<org.squashtest.tm.domain.requirement.RequirementVersion> getRequirementVersionFromIssue(String remoteIssueId, Long executionId) {
        return this.dslContext.select((SelectField)RequirementVersion.REQUIREMENT_VERSION).from((TableLike)RequirementVersion.REQUIREMENT_VERSION).join((TableLike)Tables.REQUIREMENT).on(Tables.REQUIREMENT.RLN_ID.eq((Field)RequirementVersion.REQUIREMENT_VERSION.REQUIREMENT_ID)).join((TableLike)Tables.RLN_RESOURCE).on(Tables.RLN_RESOURCE.RLN_ID.eq((Field)Tables.REQUIREMENT.RLN_ID)).join((TableLike)Tables.RESOURCE).on(Tables.RESOURCE.RES_ID.eq((Field)Tables.RLN_RESOURCE.RES_ID)).join((TableLike)Tables.REQUIREMENT_VERSION_COVERAGE).on(Tables.REQUIREMENT_VERSION_COVERAGE.VERIFIED_REQ_VERSION_ID.eq((Field)RequirementVersion.REQUIREMENT_VERSION.RES_ID)).join((TableLike)Tables.EXECUTION).on(Tables.EXECUTION.TCLN_ID.eq((Field)Tables.REQUIREMENT_VERSION_COVERAGE.VERIFYING_TEST_CASE_ID)).join((TableLike)Tables.EXECUTION_ISSUES_CLOSURE).on(Tables.EXECUTION_ISSUES_CLOSURE.EXECUTION_ID.eq((Field)Tables.EXECUTION.EXECUTION_ID)).join((TableLike)Tables.ISSUE).on(Tables.ISSUE.ISSUE_ID.eq((Field)Tables.EXECUTION_ISSUES_CLOSURE.ISSUE_ID)).where(Tables.EXECUTION_ISSUES_CLOSURE.EXECUTION_ID.eq((Object)executionId).and(Tables.ISSUE.REMOTE_ISSUE_ID.eq((Object)remoteIssueId))).fetchInto(org.squashtest.tm.domain.requirement.RequirementVersion.class);
    }

    @Override
    @PreAuthorize(value="@apiSecurity.hasPermission(#versionId,'org.squashtest.tm.domain.requirement.RequirementVersion', 'READ')")
    public List<Long> getExecutionIdsByRequirementVersion(Long versionId) {
        Page<Requirement> requirementPage;
        ArrayList allRequirement = new ArrayList();
        int page = 0;
        List<Long> requirementId = this.reqVerRepository.findRequirementIdsByRequirementVersionIds(Collections.singletonList(versionId));
        Optional premierIdOptional = requirementId.stream().findFirst();
        do {
            requirementPage = this.restRequirementRepository.findRequirementAllChildren((Long)premierIdOptional.get(), (Pageable)PageRequest.of((int)page, (int)Integer.MAX_VALUE));
            allRequirement.addAll(requirementPage.getContent());
            ++page;
        } while (requirementPage.hasNext());
        ArrayList<Long> finalRequirementIds = new ArrayList<Long>(allRequirement.stream().map(RequirementLibraryNode::getId).toList());
        List<Long> linkedRequirementIds = this.getRequirementIdsLinkedToHighLevelRequirement(versionId);
        finalRequirementIds.addAll(linkedRequirementIds);
        return this.dslContext.select((SelectField)Tables.EXECUTION.EXECUTION_ID).from((TableLike)Tables.EXECUTION).join((TableLike)Tables.REQUIREMENT_VERSION_COVERAGE).on(Tables.REQUIREMENT_VERSION_COVERAGE.VERIFYING_TEST_CASE_ID.eq((Field)Tables.EXECUTION.TCLN_ID)).join((TableLike)RequirementVersion.REQUIREMENT_VERSION).on(Tables.REQUIREMENT_VERSION_COVERAGE.VERIFIED_REQ_VERSION_ID.eq((Field)RequirementVersion.REQUIREMENT_VERSION.RES_ID)).leftJoin((TableLike)DSL.select((SelectField)RequirementVersion.REQUIREMENT_VERSION.REQUIREMENT_ID, (SelectField)DSL.max((Field)RequirementVersion.REQUIREMENT_VERSION.VERSION_NUMBER).as(MAX_VERSION_NUMBER)).from((TableLike)RequirementVersion.REQUIREMENT_VERSION).where(RequirementVersion.REQUIREMENT_VERSION.REQUIREMENT_ID.in(finalRequirementIds)).groupBy(new GroupField[]{RequirementVersion.REQUIREMENT_VERSION.REQUIREMENT_ID}).asTable(MAX_VERSIONS)).on(RequirementVersion.REQUIREMENT_VERSION.REQUIREMENT_ID.eq(DSL.field((Name)DSL.name((String[])new String[]{MAX_VERSIONS, REQUIREMENT_ID}), Long.class)).and(RequirementVersion.REQUIREMENT_VERSION.VERSION_NUMBER.eq(DSL.field((Name)DSL.name((String[])new String[]{MAX_VERSIONS, MAX_VERSION_NUMBER}), Long.class).coerce(RequirementVersion.REQUIREMENT_VERSION.VERSION_NUMBER.getDataType())))).where(RequirementVersion.REQUIREMENT_VERSION.RES_ID.eq((Object)versionId).or(RequirementVersion.REQUIREMENT_VERSION.REQUIREMENT_ID.in(finalRequirementIds).and(DSL.field((Name)DSL.name((String[])new String[]{MAX_VERSIONS, REQUIREMENT_ID}), Long.class).isNotNull()))).fetchInto(Long.class);
    }

    @Override
    public RemoteReqInfoRecord getRemoteReqInfoByRequirementId(Long id) {
        return (RemoteReqInfoRecord)this.dslContext.select((SelectField)Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_REQ_ID, (SelectField)Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_REQ_URL, (SelectField)Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_REQ_PERIMETER_STATUS).from((TableLike)Tables.REQUIREMENT_SYNC_EXTENDER).where(Tables.REQUIREMENT_SYNC_EXTENDER.REQUIREMENT_ID.eq((Object)id)).fetchOneInto(RemoteReqInfoRecord.class);
    }

    private List<Long> getRequirementIdsLinkedToHighLevelRequirement(Long versionId) {
        return this.dslContext.selectDistinct((SelectField)Tables.REQUIREMENT.RLN_ID).from((TableLike)Tables.REQUIREMENT).join((TableLike)RequirementVersion.REQUIREMENT_VERSION).on(RequirementVersion.REQUIREMENT_VERSION.REQUIREMENT_ID.eq((Field)Tables.REQUIREMENT.RLN_ID)).where(Tables.REQUIREMENT.HIGH_LEVEL_REQUIREMENT_ID.eq((Select)this.dslContext.select((SelectField)RequirementVersion.REQUIREMENT_VERSION.REQUIREMENT_ID).from((TableLike)RequirementVersion.REQUIREMENT_VERSION).where(RequirementVersion.REQUIREMENT_VERSION.RES_ID.eq((Object)versionId)))).fetchInto(Long.class);
    }

    private Requirement addToParent(RequirementDto requirementDto, NewRequirementVersionDto newRequirementVersionDto) {
        ParentEntity parent = requirementDto.getParent();
        Requirement requirement = switch (parent.getRestType()) {
            case RestType.PROJECT -> this.addRequirementToLibrary(newRequirementVersionDto, parent);
            case RestType.REQUIREMENT_FOLDER -> this.addRequirementToFolder(newRequirementVersionDto, parent);
            case RestType.REQUIREMENT -> this.addRequirementToRequirement(newRequirementVersionDto, parent);
            default -> throw new IllegalArgumentException(String.format(WRONG_PARENT_REST_TYPE_ERROR_MESSAGE, new Object[]{parent.getRestType()}));
        };
        requirement.getCurrentVersion().updateStatusWithoutCheck(requirementDto.getCurrentVersion().getStatus());
        return requirement;
    }

    private Requirement addRequirementToLibrary(NewRequirementVersionDto newRequirementVersionDto, ParentEntity parent) {
        Project project = (Project)this.entityManager.find(Project.class, (Object)parent.getId());
        if (project != null) {
            return this.requirementLibraryNavigationService.addRequirementToRequirementLibrary(project.getRequirementLibrary().getId().longValue(), newRequirementVersionDto, new ArrayList());
        }
        throw new IllegalArgumentException("Programmatic error : project with id " + String.valueOf(parent.getId()) + "is unknown. You should validate this before.");
    }

    private Requirement addRequirementToFolder(NewRequirementVersionDto newRequirementVersionDto, ParentEntity parent) {
        RequirementFolder requirementFolder = (RequirementFolder)this.entityManager.find(RequirementFolder.class, (Object)parent.getId());
        if (requirementFolder != null) {
            return this.requirementLibraryNavigationService.addRequirementToRequirementFolder(requirementFolder.getId().longValue(), newRequirementVersionDto, new ArrayList());
        }
        throw new IllegalArgumentException("Programmatic error : requirement folder with id " + String.valueOf(parent.getId()) + "is unknown. You should validate this before.");
    }

    private Requirement addRequirementToRequirement(NewRequirementVersionDto newRequirementVersionDto, ParentEntity parent) {
        Requirement req = (Requirement)this.entityManager.find(Requirement.class, (Object)parent.getId());
        if (req != null) {
            return this.requirementLibraryNavigationService.addRequirementToRequirement(req.getId().longValue(), newRequirementVersionDto, new ArrayList());
        }
        throw new IllegalArgumentException("Programmatic error : requirement folder with id " + String.valueOf(parent.getId()) + "is unknown. You should validate this before.");
    }

    private NewRequirementVersionDto convertRequirementDtoToNewRequirementVersionDto(RequirementDto requirementDto) {
        NewRequirementVersionDto newRequirementVersionDto = new NewRequirementVersionDto();
        this.populateRequirementVersionDto(requirementDto, newRequirementVersionDto);
        return newRequirementVersionDto;
    }

    private HighLevelNewRequirementVersionDto convertRequirementDtoToNewHighLevelRequirementVersionDto(RequirementDto requirementDto) {
        HighLevelNewRequirementVersionDto newRequirementVersionDto = new HighLevelNewRequirementVersionDto();
        this.populateRequirementVersionDto(requirementDto, (NewRequirementVersionDto)newRequirementVersionDto);
        return newRequirementVersionDto;
    }

    private void populateRequirementVersionDto(RequirementDto requirementDto, NewRequirementVersionDto newRequirementVersionDto) {
        Map<Long, RawValue> customFieldMap = this.customFieldValueConverter.convertCustomFieldDtoToMap(requirementDto.getCustomFields());
        newRequirementVersionDto.setName(requirementDto.getName());
        newRequirementVersionDto.setReference(requirementDto.getCurrentVersion().getReference());
        newRequirementVersionDto.setCategory(requirementDto.getCurrentVersion().getCategory().getCode());
        newRequirementVersionDto.setCriticality(requirementDto.getCurrentVersion().getCriticality());
        newRequirementVersionDto.setDescription(requirementDto.getDescription());
        newRequirementVersionDto.setCustomFields(customFieldMap);
    }

    private List<Long> findAllRequirementLibraryIdsByPermission(List<Long> partyIds, int permission) {
        return this.projectDaoImpl.findAllProjectIdsByPermissionMaskAndClassName(partyIds, permission, RequirementLibrary.class.getName(), Tables.PROJECT.RL_ID);
    }
}

