/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.jackson.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.ser.VirtualBeanPropertyWriter;
import com.fasterxml.jackson.databind.util.Annotations;
import jakarta.inject.Inject;
import org.springframework.stereotype.Component;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.campaign.CampaignLibraryNode;
import org.squashtest.tm.domain.library.TreeNode;
import org.squashtest.tm.domain.library.WhichNodeVisitor;
import org.squashtest.tm.domain.requirement.RequirementLibraryNode;
import org.squashtest.tm.domain.testcase.TestCaseLibraryNode;
import org.squashtest.tm.service.internal.library.PathService;

@Component
public class PathPropertyWriter
extends VirtualBeanPropertyWriter {
    @Inject
    private PathService pathService;

    public PathPropertyWriter() {
    }

    public PathPropertyWriter(BeanPropertyDefinition propDef, Annotations contextAnnotations, JavaType declaredType, PathService service) {
        super(propDef, contextAnnotations, declaredType);
        this.pathService = service;
    }

    protected Object value(Object bean, JsonGenerator gen, SerializerProvider prov) throws Exception {
        if (!TreeNode.class.isAssignableFrom(bean.getClass())) {
            throw new IllegalArgumentException("attempted to serializer the path of a '" + bean.getClass().getName() + "', but only implementors of TreeNode are accepted");
        }
        EntityType beanType = new WhichNodeVisitor().getTypeOf((TreeNode)bean);
        return switch (beanType) {
            case EntityType.TEST_CASE, EntityType.TEST_CASE_FOLDER -> this.pathService.buildTestCasePath(((TestCaseLibraryNode)bean).getId().longValue());
            case EntityType.HIGH_LEVEL_REQUIREMENT, EntityType.REQUIREMENT, EntityType.REQUIREMENT_FOLDER -> this.pathService.buildRequirementPath(((RequirementLibraryNode)bean).getId().longValue());
            case EntityType.CAMPAIGN, EntityType.CAMPAIGN_FOLDER -> this.pathService.buildCampaignPath(((CampaignLibraryNode)bean).getId().longValue());
            default -> "not-implemented";
        };
    }

    public VirtualBeanPropertyWriter withConfig(MapperConfig<?> config, AnnotatedClass declaringClass, BeanPropertyDefinition propDef, JavaType type) {
        return new PathPropertyWriter(propDef, declaringClass.getAnnotations(), type, this.pathService);
    }
}

