/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.jackson.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.ser.VirtualBeanPropertyWriter;
import com.fasterxml.jackson.databind.util.Annotations;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import org.springframework.stereotype.Component;
import org.squashtest.tm.domain.testcase.Dataset;
import org.squashtest.tm.domain.testcase.DatasetParamValue;
import org.squashtest.tm.domain.testcase.Parameter;
import org.squashtest.tm.plugin.rest.jackson.serializer.HateoasWrapperConverter;

@Component
public class DatasetParameterPropertyWriter
extends VirtualBeanPropertyWriter {
    @Inject
    HateoasWrapperConverter hateoasConverter;
    public static final Comparator<Parameter> ID_COMPARATOR = new Comparator<Parameter>(){

        @Override
        public int compare(Parameter arg0, Parameter arg1) {
            Parameter p = arg0;
            Parameter q = arg1;
            if (p.getId() == q.getId()) {
                return p.getName().compareTo(q.getName());
            }
            if (p.getId() > q.getId()) {
                return 1;
            }
            return -1;
        }
    };

    public DatasetParameterPropertyWriter() {
    }

    public DatasetParameterPropertyWriter(BeanPropertyDefinition propDef, Annotations contextAnnotations, JavaType declaredType) {
        super(propDef, contextAnnotations, declaredType);
    }

    protected Object value(Object bean, JsonGenerator gen, SerializerProvider prov) throws Exception {
        Dataset dataset = (Dataset)bean;
        Set parameterValues = dataset.getParameterValues();
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        for (DatasetParamValue parameterValue : parameterValues) {
            parameters.add(parameterValue.getParameter());
        }
        Collections.sort(parameters, ID_COMPARATOR);
        return parameters;
    }

    public VirtualBeanPropertyWriter withConfig(MapperConfig<?> config, AnnotatedClass declaringClass, BeanPropertyDefinition propDef, JavaType type) {
        return new DatasetParameterPropertyWriter(propDef, declaringClass.getAnnotations(), type);
    }
}

