/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.redmine3.redmineextendedmanager.internal;

import com.taskadapter.redmineapi.bean.CustomField;
import com.taskadapter.redmineapi.bean.Project;
import com.taskadapter.redmineapi.bean.Role;
import com.taskadapter.redmineapi.bean.Tracker;
import com.taskadapter.redmineapi.internal.RedmineJSONParser;
import com.taskadapter.redmineapi.internal.json.JsonInput;
import com.taskadapter.redmineapi.internal.json.JsonObjectParser;
import java.util.ArrayList;
import java.util.List;
import org.squashtest.tm.plugin.bugtracker.redmine3.json.JSONArray;
import org.squashtest.tm.plugin.bugtracker.redmine3.json.JSONException;
import org.squashtest.tm.plugin.bugtracker.redmine3.json.JSONObject;
import org.squashtest.tm.plugin.bugtracker.redmine3.redmineextendedmanager.bean.ExtendedCustomField;
import org.squashtest.tm.plugin.bugtracker.redmine3.redmineextendedmanager.bean.ExtendedRole;
import org.squashtest.tm.plugin.bugtracker.redmine3.redmineextendedmanager.bean.ExtendedTracker;

public final class ExtendedRedmine3JsonParser
extends RedmineJSONParser {
    public static final JsonObjectParser<CustomField> CUSTOM_FIELD_PARSER = new JsonObjectParser<CustomField>(){

        @Override
        public CustomField parse(JSONObject input) throws JSONException {
            return ExtendedRedmine3JsonParser.parseCustomField(input);
        }
    };
    public static final JsonObjectParser<Tracker> TRACKER_PARSER = new JsonObjectParser<Tracker>(){

        @Override
        public Tracker parse(JSONObject input) throws JSONException {
            return ExtendedRedmine3JsonParser.parseTracker(input);
        }
    };
    public static final JsonObjectParser<Role> ROLE_PARSER = new JsonObjectParser<Role>(){

        @Override
        public Role parse(JSONObject input) throws JSONException {
            return ExtendedRedmine3JsonParser.parseRole(input);
        }
    };

    private ExtendedRedmine3JsonParser() {
    }

    public static Role parseRole(JSONObject content) throws JSONException {
        ExtendedRole result = new ExtendedRole();
        int id = JsonInput.getInt(content, "id");
        String name = JsonInput.getStringNotNull(content, "name");
        result.setId(id);
        result.setName(name);
        result.setAssignable(JsonInput.getOptionalBool(content, "assignable"));
        return result;
    }

    public static Tracker parseTracker(JSONObject content) throws JSONException {
        ExtendedTracker result = new ExtendedTracker();
        int id = JsonInput.getInt(content, "id");
        String name = JsonInput.getStringNotNull(content, "name");
        result.setId(id);
        result.setName(name);
        result.setCoreFields(ExtendedRedmine3JsonParser.getList(content, "core_fields"));
        JSONArray tmp = JsonInput.getArrayOrNull(content, "custom_fields");
        ArrayList<ExtendedCustomField> customFields = new ArrayList<ExtendedCustomField>();
        int i = 0;
        while (i < tmp.length()) {
            ExtendedCustomField custom = ExtendedRedmine3JsonParser.parseCustomField(tmp.getJSONObject(i));
            customFields.add(custom);
            ++i;
        }
        result.setCustomFields(customFields);
        return result;
    }

    private static List<String> getList(JSONObject content, String name) throws JSONException {
        JSONArray tmp = JsonInput.getArrayOrNull(content, name);
        ArrayList<String> strings = new ArrayList<String>();
        int i = 0;
        while (i < tmp.length()) {
            strings.add(String.valueOf(tmp.get(i)));
            ++i;
        }
        return strings;
    }

    public static ExtendedCustomField parseCustomField(JSONObject content) throws JSONException {
        ExtendedCustomField result = new ExtendedCustomField();
        ExtendedRedmine3JsonParser.setCustomFieldFields(result, content);
        JSONArray jsonProjects = JsonInput.getArrayOrNull(content, "projects");
        if (jsonProjects != null) {
            ArrayList<Project> projects = new ArrayList<Project>();
            int i = 0;
            while (i < jsonProjects.length()) {
                Project project = ExtendedRedmine3JsonParser.parseMinimalProject(jsonProjects.getJSONObject(i));
                projects.add(project);
                ++i;
            }
            result.setProject(projects);
        }
        if (JsonInput.getArrayOrNull(content, "possible_values") != null) {
            ArrayList<String> strings = new ArrayList<String>();
            JSONArray tmp = JsonInput.getArrayOrNull(content, "possible_values");
            int i = 0;
            while (i < tmp.length()) {
                strings.add(JsonInput.getStringOrEmpty((JSONObject)tmp.get(i), "value"));
                ++i;
            }
            result.setPossibleValues(strings);
        }
        return result;
    }

    private static void setCustomFieldFields(ExtendedCustomField result, JSONObject content) throws JSONException {
        result.setId(JsonInput.getInt(content, "id"));
        result.setName(JsonInput.getStringOrNull(content, "name"));
        result.setCustomizedType(JsonInput.getStringOrNull(content, "customized_type"));
        result.setFieldFormat(JsonInput.getStringOrNull(content, "field_format"));
        result.setRequired(JsonInput.getOptionalBool(content, "is_required"));
        result.setAvailableForAllProject(JsonInput.getOptionalBool(content, "is_for_all"));
        result.setMultiple(JsonInput.getOptionalBool(content, "multiple"));
    }
}

