/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.redmine3.operations;

import com.taskadapter.redmineapi.RedmineException;
import com.taskadapter.redmineapi.RedmineManager;
import com.taskadapter.redmineapi.bean.Membership;
import com.taskadapter.redmineapi.bean.Role;
import com.taskadapter.redmineapi.bean.User;
import java.util.ArrayList;
import java.util.List;
import org.squashtest.tm.plugin.bugtracker.redmine3.operations.Redmine3RestClientOperation;

public class SearchPossibleReporter
extends Redmine3RestClientOperation<List<User>> {
    private final String projectKey;
    private final String namePrefix;
    private static final String ADD_ISSUE = "add_issue";

    public SearchPossibleReporter(RedmineManager manager, String projectKey, String namePrefix) {
        super(manager);
        this.projectKey = projectKey;
        this.namePrefix = namePrefix;
    }

    @Override
    public List<User> doIt() throws RedmineException {
        List<Membership> membership = this.manager.getMemberships(this.projectKey);
        ArrayList<User> users = new ArrayList<User>(membership.size());
        for (Membership member : membership) {
            if (member.getUser() == null || !member.getUser().getFullName().startsWith(this.namePrefix) || !this.userCanSubmitIssue(member)) continue;
            users.add(member.getUser());
        }
        return users;
    }

    private boolean userCanSubmitIssue(Membership member) throws RedmineException {
        List<Role> roles = member.getRoles();
        boolean result = false;
        for (Role r : roles) {
            Role role = this.manager.getRoleById(r.getId());
            if (!role.getPermissions().contains(ADD_ISSUE)) continue;
            result = true;
        }
        return result;
    }
}

