/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.redmine3.http.protocol;

import java.io.IOException;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.HttpException;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.HttpRequest;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.HttpRequestInterceptor;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.annotation.Contract;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.annotation.ThreadingBehavior;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.protocol.HttpContext;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestConnControl
implements HttpRequestInterceptor {
    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        String method = request.getRequestLine().getMethod();
        if (method.equalsIgnoreCase("CONNECT")) {
            return;
        }
        if (!request.containsHeader("Connection")) {
            request.addHeader("Connection", "Keep-Alive");
        }
    }
}

